function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import moment from 'moment';
import { PersistedLog } from '../persisted_log';
export var TimeHistory = /*#__PURE__*/function () {
  function TimeHistory(storage) {
    _classCallCheck(this, TimeHistory);

    _defineProperty(this, "history", void 0);

    var historyOptions = {
      maxLength: 10,
      filterDuplicates: true,
      isDuplicate: function isDuplicate(oldItem, newItem) {
        return oldItem.from === newItem.from && oldItem.to === newItem.to;
      }
    };
    this.history = new PersistedLog('kibana.timepicker.timeHistory', historyOptions, storage);
  }

  _createClass(TimeHistory, [{
    key: "add",
    value: function add(time) {
      if (!time || !time.from || !time.to) {
        return;
      } // time from/to can be strings or moment objects - convert to strings so always dealing with same types


      var justStringsTime = {
        from: moment.isMoment(time.from) ? time.from.toISOString() : time.from,
        to: moment.isMoment(time.to) ? time.to.toISOString() : time.to
      };
      this.history.add(justStringsTime);
    }
  }, {
    key: "get",
    value: function get() {
      return this.history.get();
    }
  }]);

  return TimeHistory;
}();