function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { convertDirectiveToRenderFn } from './doc_views_helpers';
export var DocViewsRegistry = /*#__PURE__*/function () {
  function DocViewsRegistry() {
    var _this = this;

    _classCallCheck(this, DocViewsRegistry);

    _defineProperty(this, "docViews", []);

    _defineProperty(this, "angularInjectorGetter", null);

    _defineProperty(this, "setAngularInjectorGetter", function (injectorGetter) {
      _this.angularInjectorGetter = injectorGetter;
    });
  }

  _createClass(DocViewsRegistry, [{
    key: "addDocView",

    /**
     * Extends and adds the given doc view to the registry array
     */
    value: function addDocView(docViewRaw) {
      var _this2 = this;

      var docView = typeof docViewRaw === 'function' ? docViewRaw() : docViewRaw;

      if (docView.directive) {
        // convert angular directive to render function for backwards compatibility
        docView.render = convertDirectiveToRenderFn(docView.directive, function () {
          if (!_this2.angularInjectorGetter) {
            throw new Error('Angular was not initialized');
          }

          return _this2.angularInjectorGetter();
        });
      }

      if (typeof docView.shouldShow !== 'function') {
        docView.shouldShow = function () {
          return true;
        };
      }

      this.docViews.push(docView);
    }
    /**
     * Returns a sorted array of doc_views for rendering tabs
     */

  }, {
    key: "getDocViewsSorted",
    value: function getDocViewsSorted(hit) {
      return this.docViews.filter(function (docView) {
        return docView.shouldShow(hit);
      }).sort(function (a, b) {
        return Number(a.order) > Number(b.order) ? 1 : -1;
      });
    }
  }]);

  return DocViewsRegistry;
}();