function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiGlobalToastList, EuiPageContent, EuiHorizontalRule } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { withRouter } from 'react-router-dom';
import { StepIndexPattern } from './components/step_index_pattern';
import { StepTimeField } from './components/step_time_field';
import { Header } from './components/header';
import { LoadingState } from './components/loading_state';
import { EmptyState } from './components/empty_state';
import { context as contextType } from '../../../../kibana_react/public';
import { getCreateBreadcrumbs } from '../breadcrumbs';
import { ensureMinimumTime, getIndices } from './lib';
export var CreateIndexPatternWizard = /*#__PURE__*/function (_Component) {
  _inherits(CreateIndexPatternWizard, _Component);

  var _super = _createSuper(CreateIndexPatternWizard);

  function CreateIndexPatternWizard(props, context) {
    var _this;

    _classCallCheck(this, CreateIndexPatternWizard);

    _this = _super.call(this, props, context);

    _defineProperty(_assertThisInitialized(_this), "context", void 0);

    _defineProperty(_assertThisInitialized(_this), "catchAndWarn", /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(asyncFn, errorValue, errorMsg) {
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return asyncFn;

              case 3:
                return _context.abrupt("return", _context.sent);

              case 6:
                _context.prev = 6;
                _context.t0 = _context["catch"](0);

                _this.setState(function (prevState) {
                  return {
                    toasts: prevState.toasts.concat([{
                      title: errorMsg,
                      id: errorMsg.props.id,
                      color: 'warning',
                      iconType: 'alert'
                    }])
                  };
                });

                return _context.abrupt("return", errorValue);

              case 10:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 6]]);
      }));

      return function (_x, _x2, _x3) {
        return _ref.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "fetchData", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var indicesFailMsg, clustersFailMsg;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              indicesFailMsg = /*#__PURE__*/React.createElement(FormattedMessage, {
                id: "indexPatternManagement.createIndexPattern.loadIndicesFailMsg",
                defaultMessage: "Failed to load indices"
              });
              clustersFailMsg = /*#__PURE__*/React.createElement(FormattedMessage, {
                id: "indexPatternManagement.createIndexPattern.loadClustersFailMsg",
                defaultMessage: "Failed to load remote clusters"
              }); // query local and remote indices, updating state independently

              ensureMinimumTime(_this.catchAndWarn(getIndices(_this.context.services.http, _this.state.indexPatternCreationType, "*", false), [], indicesFailMsg)).then(function (allIndices) {
                return _this.setState({
                  allIndices: allIndices,
                  isInitiallyLoadingIndices: false
                });
              });

              _this.catchAndWarn( // if we get an error from remote cluster query, supply fallback value that allows user entry.
              // ['a'] is fallback value
              getIndices(_this.context.services.http, _this.state.indexPatternCreationType, "*:*", false), ['a'], clustersFailMsg).then(function (remoteIndices) {
                return _this.setState({
                  remoteClustersExist: !!remoteIndices.length
                });
              });

            case 4:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));

    _defineProperty(_assertThisInitialized(_this), "createIndexPattern", /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(timeFieldName, indexPatternId) {
        var history, indexPattern, emptyPattern, createdId, confirmMessage, isConfirmed;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                history = _this.props.history;
                indexPattern = _this.state.indexPattern;
                _context3.next = 4;
                return _this.context.services.data.indexPatterns.make();

              case 4:
                emptyPattern = _context3.sent;
                Object.assign(emptyPattern, _objectSpread({
                  id: indexPatternId,
                  title: indexPattern,
                  timeFieldName: timeFieldName
                }, _this.state.indexPatternCreationType.getIndexPatternMappings()));
                _context3.next = 8;
                return emptyPattern.create();

              case 8:
                createdId = _context3.sent;

                if (createdId) {
                  _context3.next = 19;
                  break;
                }

                confirmMessage = i18n.translate('indexPatternManagement.indexPattern.titleExistsLabel', {
                  values: {
                    title: emptyPattern.title
                  },
                  defaultMessage: "An index pattern with the title '{title}' already exists."
                });
                _context3.next = 13;
                return _this.context.services.overlays.openConfirm(confirmMessage, {
                  confirmButtonText: i18n.translate('indexPatternManagement.indexPattern.goToPatternButtonLabel', {
                    defaultMessage: 'Go to existing pattern'
                  })
                });

              case 13:
                isConfirmed = _context3.sent;

                if (!isConfirmed) {
                  _context3.next = 18;
                  break;
                }

                return _context3.abrupt("return", history.push("/patterns/".concat(indexPatternId)));

              case 18:
                return _context3.abrupt("return");

              case 19:
                if (_this.context.services.uiSettings.get('defaultIndex')) {
                  _context3.next = 22;
                  break;
                }

                _context3.next = 22;
                return _this.context.services.uiSettings.set('defaultIndex', createdId);

              case 22:
                _this.context.services.data.indexPatterns.clearCache(createdId);

                history.push("/patterns/".concat(createdId));

              case 24:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      return function (_x4, _x5) {
        return _ref3.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "goToTimeFieldStep", function (indexPattern, selectedTimeField) {
      _this.setState({
        step: 2,
        indexPattern: indexPattern,
        selectedTimeField: selectedTimeField
      });
    });

    _defineProperty(_assertThisInitialized(_this), "goToIndexPatternStep", function () {
      _this.setState({
        step: 1
      });
    });

    _defineProperty(_assertThisInitialized(_this), "removeToast", function (id) {
      _this.setState(function (prevState) {
        return {
          toasts: prevState.toasts.filter(function (toast) {
            return toast.id !== id;
          })
        };
      });
    });

    context.services.setBreadcrumbs(getCreateBreadcrumbs());
    var type = new URLSearchParams(props.location.search).get('type') || undefined;
    _this.state = {
      step: 1,
      indexPattern: '',
      allIndices: [],
      remoteClustersExist: false,
      isInitiallyLoadingIndices: true,
      toasts: [],
      indexPatternCreationType: context.services.indexPatternManagementStart.creation.getType(type),
      docLinks: context.services.docLinks
    };
    return _this;
  }

  _createClass(CreateIndexPatternWizard, [{
    key: "UNSAFE_componentWillMount",
    value: function () {
      var _UNSAFE_componentWillMount = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                this.fetchData();

              case 1:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function UNSAFE_componentWillMount() {
        return _UNSAFE_componentWillMount.apply(this, arguments);
      }

      return UNSAFE_componentWillMount;
    }()
  }, {
    key: "renderHeader",
    value: function renderHeader() {
      return /*#__PURE__*/React.createElement(Header, {
        prompt: this.state.indexPatternCreationType.renderPrompt(),
        indexPatternName: this.state.indexPatternCreationType.getIndexPatternName(),
        isBeta: this.state.indexPatternCreationType.getIsBeta(),
        docLinks: this.state.docLinks
      });
    }
  }, {
    key: "renderContent",
    value: function renderContent() {
      var _this$state = this.state,
          allIndices = _this$state.allIndices,
          isInitiallyLoadingIndices = _this$state.isInitiallyLoadingIndices,
          step = _this$state.step,
          indexPattern = _this$state.indexPattern,
          remoteClustersExist = _this$state.remoteClustersExist;

      if (isInitiallyLoadingIndices) {
        return /*#__PURE__*/React.createElement(LoadingState, null);
      }

      var hasDataIndices = allIndices.some(function (_ref4) {
        var name = _ref4.name;
        return !name.startsWith('.');
      });

      if (!hasDataIndices && !remoteClustersExist) {
        return /*#__PURE__*/React.createElement(EmptyState, {
          onRefresh: this.fetchData,
          prependBasePath: this.context.services.http.basePath.prepend
        });
      }

      var header = this.renderHeader();

      if (step === 1) {
        var location = this.props.location;
        var initialQuery = new URLSearchParams(location.search).get('id') || undefined;
        return /*#__PURE__*/React.createElement(EuiPageContent, null, header, /*#__PURE__*/React.createElement(EuiHorizontalRule, null), /*#__PURE__*/React.createElement(StepIndexPattern, {
          allIndices: allIndices,
          initialQuery: indexPattern || initialQuery,
          indexPatternCreationType: this.state.indexPatternCreationType,
          goToNextStep: this.goToTimeFieldStep,
          showSystemIndices: this.state.indexPatternCreationType.getShowSystemIndices() && this.state.step === 1
        }));
      }

      if (step === 2) {
        return /*#__PURE__*/React.createElement(EuiPageContent, null, header, /*#__PURE__*/React.createElement(EuiHorizontalRule, null), /*#__PURE__*/React.createElement(StepTimeField, {
          indexPattern: indexPattern,
          goToPreviousStep: this.goToIndexPatternStep,
          createIndexPattern: this.createIndexPattern,
          indexPatternCreationType: this.state.indexPatternCreationType,
          selectedTimeField: this.state.selectedTimeField
        }));
      }

      return null;
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var content = this.renderContent();
      return /*#__PURE__*/React.createElement(React.Fragment, null, content, /*#__PURE__*/React.createElement(EuiGlobalToastList, {
        toasts: this.state.toasts,
        dismissToast: function dismissToast(_ref5) {
          var id = _ref5.id;

          _this2.removeToast(id);
        },
        toastLifeTimeMs: 6000
      }));
    }
  }]);

  return CreateIndexPatternWizard;
}(Component);

_defineProperty(CreateIndexPatternWizard, "contextType", contextType);

export var CreateIndexPatternWizardWithRouter = withRouter(CreateIndexPatternWizard);