function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { keys, EuiInMemoryTable, EuiFieldText, EuiButtonIcon, RIGHT_ALIGNMENT } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
var filterHeader = i18n.translate('indexPatternManagement.editIndexPattern.source.table.filterHeader', {
  defaultMessage: 'Filter'
});
var filterDescription = i18n.translate('indexPatternManagement.editIndexPattern.source.table.filterDescription', {
  defaultMessage: 'Filter name'
});
var matchesHeader = i18n.translate('indexPatternManagement.editIndexPattern.source.table.matchesHeader', {
  defaultMessage: 'Matches'
});
var matchesDescription = i18n.translate('indexPatternManagement.editIndexPattern.source.table.matchesDescription', {
  defaultMessage: 'Language used for the field'
});
var editAria = i18n.translate('indexPatternManagement.editIndexPattern.source.table.editAria', {
  defaultMessage: 'Edit'
});
var saveAria = i18n.translate('indexPatternManagement.editIndexPattern.source.table.saveAria', {
  defaultMessage: 'Save'
});
var deleteAria = i18n.translate('indexPatternManagement.editIndexPattern.source.table.deleteAria', {
  defaultMessage: 'Delete'
});
var cancelAria = i18n.translate('indexPatternManagement.editIndexPattern.source.table.cancelAria', {
  defaultMessage: 'Cancel'
});
export var Table = /*#__PURE__*/function (_Component) {
  _inherits(Table, _Component);

  var _super = _createSuper(Table);

  function Table(props) {
    var _this;

    _classCallCheck(this, Table);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "startEditingFilter", function (editingFilterId, editingFilterValue) {
      return _this.setState({
        editingFilterId: editingFilterId,
        editingFilterValue: editingFilterValue
      });
    });

    _defineProperty(_assertThisInitialized(_this), "stopEditingFilter", function () {
      return _this.setState({
        editingFilterId: ''
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onEditingFilterChange", function (e) {
      return _this.setState({
        editingFilterValue: e.target.value
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onEditFieldKeyDown", function (_ref) {
      var key = _ref.key;

      if (keys.ENTER === key && _this.state.editingFilterId && _this.state.editingFilterValue) {
        _this.props.saveFilter({
          clientId: _this.state.editingFilterId,
          value: _this.state.editingFilterValue
        });

        _this.stopEditingFilter();
      }

      if (keys.ESCAPE === key) {
        _this.stopEditingFilter();
      }
    });

    _this.state = {
      editingFilterId: '',
      editingFilterValue: ''
    };
    return _this;
  }

  _createClass(Table, [{
    key: "getColumns",
    value: function getColumns() {
      var _this2 = this;

      var _this$props = this.props,
          deleteFilter = _this$props.deleteFilter,
          fieldWildcardMatcher = _this$props.fieldWildcardMatcher,
          indexPattern = _this$props.indexPattern,
          saveFilter = _this$props.saveFilter;
      return [{
        field: 'value',
        name: filterHeader,
        description: filterDescription,
        dataType: 'string',
        sortable: true,
        render: function render(value, filter) {
          if (_this2.state.editingFilterId && _this2.state.editingFilterId === filter.clientId) {
            return /*#__PURE__*/React.createElement(EuiFieldText, {
              autoFocus: true,
              value: _this2.state.editingFilterValue,
              onChange: _this2.onEditingFilterChange,
              onKeyDown: _this2.onEditFieldKeyDown
            });
          }

          return /*#__PURE__*/React.createElement("span", null, value);
        }
      }, {
        field: 'value',
        name: matchesHeader,
        description: matchesDescription,
        dataType: 'string',
        sortable: true,
        render: function render(value, filter) {
          var wildcardMatcher = fieldWildcardMatcher([_this2.state.editingFilterId === filter.clientId ? _this2.state.editingFilterValue : value]);
          var matches = indexPattern.getNonScriptedFields().map(function (currentFilter) {
            return currentFilter.name;
          }).filter(wildcardMatcher).sort();

          if (matches.length) {
            return /*#__PURE__*/React.createElement("span", null, matches.join(', '));
          }

          return /*#__PURE__*/React.createElement("em", null, /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "indexPatternManagement.editIndexPattern.source.table.notMatchedLabel",
            defaultMessage: "The source filter doesn't match any known fields."
          }));
        }
      }, {
        name: '',
        align: RIGHT_ALIGNMENT,
        width: '100',
        render: function render(filter) {
          if (_this2.state.editingFilterId === filter.clientId) {
            return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiButtonIcon, {
              size: "s",
              onClick: function onClick() {
                saveFilter({
                  clientId: _this2.state.editingFilterId,
                  value: _this2.state.editingFilterValue
                });

                _this2.stopEditingFilter();
              },
              iconType: "checkInCircleFilled",
              "aria-label": saveAria
            }), /*#__PURE__*/React.createElement(EuiButtonIcon, {
              size: "s",
              onClick: function onClick() {
                _this2.stopEditingFilter();
              },
              iconType: "cross",
              "aria-label": cancelAria
            }));
          }

          return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiButtonIcon, {
            size: "s",
            onClick: function onClick() {
              return _this2.startEditingFilter(filter.clientId, filter.value);
            },
            iconType: "pencil",
            "aria-label": editAria
          }), /*#__PURE__*/React.createElement(EuiButtonIcon, {
            size: "s",
            color: "danger",
            onClick: function onClick() {
              return deleteFilter(filter);
            },
            iconType: "trash",
            "aria-label": deleteAria
          }));
        }
      }];
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          items = _this$props2.items,
          isSaving = _this$props2.isSaving;
      var columns = this.getColumns();
      var pagination = {
        initialPageSize: 10,
        pageSizeOptions: [5, 10, 25, 50]
      };
      return /*#__PURE__*/React.createElement(EuiInMemoryTable, {
        loading: isSaving,
        items: items,
        columns: columns,
        pagination: pagination,
        sorting: true
      });
    }
  }]);

  return Table;
}(Component);