function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { EuiButton, EuiContextMenuItem, EuiContextMenuPanel, EuiPopover } from '@elastic/eui';
import { exportAsCsv } from '../lib/export_csv';

var DataDownloadOptions = /*#__PURE__*/function (_Component) {
  _inherits(DataDownloadOptions, _Component);

  var _super = _createSuper(DataDownloadOptions);

  function DataDownloadOptions() {
    var _this;

    _classCallCheck(this, DataDownloadOptions);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isPopoverOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "onTogglePopover", function () {
      _this.setState(function (state) {
        return {
          isPopoverOpen: !state.isPopoverOpen
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "exportCsv", function () {
      var customParams = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var filename = _this.props.title;

      if (!filename || filename.length === 0) {
        filename = i18n.translate('inspector.data.downloadOptionsUnsavedFilename', {
          defaultMessage: 'unsaved'
        });
      }

      exportAsCsv(_objectSpread({
        filename: "".concat(filename, ".csv"),
        columns: _this.props.columns,
        rows: _this.props.rows,
        csvSeparator: _this.props.csvSeparator,
        quoteValues: _this.props.quoteValues
      }, customParams));
    });

    _defineProperty(_assertThisInitialized(_this), "exportFormattedCsv", function () {
      _this.exportCsv({
        valueFormatter: function valueFormatter(item) {
          return item.formatted;
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "exportFormattedAsRawCsv", function () {
      _this.exportCsv({
        valueFormatter: function valueFormatter(item) {
          return item.raw;
        }
      });
    });

    return _this;
  }

  _createClass(DataDownloadOptions, [{
    key: "renderUnformattedDownload",
    value: function renderUnformattedDownload() {
      return /*#__PURE__*/React.createElement(EuiButton, {
        size: "s",
        onClick: this.exportCsv
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.data.downloadCSVButtonLabel",
        defaultMessage: "Download CSV"
      }));
    }
  }, {
    key: "renderFormattedDownloads",
    value: function renderFormattedDownloads() {
      var button = /*#__PURE__*/React.createElement(EuiButton, {
        iconType: "arrowDown",
        iconSide: "right",
        size: "s",
        onClick: this.onTogglePopover
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.data.downloadCSVToggleButtonLabel",
        defaultMessage: "Download CSV"
      }));
      var items = [/*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: "csv",
        onClick: this.exportFormattedCsv,
        toolTipContent: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.data.formattedCSVButtonTooltip",
          defaultMessage: "Download the data in table format"
        }),
        toolTipPosition: "left"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.data.formattedCSVButtonLabel",
        defaultMessage: "Formatted CSV"
      })), /*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: "rawCsv",
        onClick: this.exportFormattedAsRawCsv,
        toolTipContent: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.data.rawCSVButtonTooltip",
          defaultMessage: "Download the data as provided, for example, dates as timestamps"
        }),
        toolTipPosition: "left"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.data.rawCSVButtonLabel",
        defaultMessage: "Raw CSV"
      }))];
      return /*#__PURE__*/React.createElement(EuiPopover, {
        id: "inspectorDownloadData",
        button: button,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        panelPaddingSize: "none",
        repositionOnScroll: true
      }, /*#__PURE__*/React.createElement(EuiContextMenuPanel, {
        className: "eui-textNoWrap",
        items: items
      }));
    }
  }, {
    key: "render",
    value: function render() {
      return this.props.isFormatted ? this.renderFormattedDownloads() : this.renderUnformattedDownload();
    }
  }]);

  return DataDownloadOptions;
}(Component);

_defineProperty(DataDownloadOptions, "propTypes", {
  title: PropTypes.string.isRequired,
  csvSeparator: PropTypes.string.isRequired,
  quoteValues: PropTypes.bool.isRequired,
  isFormatted: PropTypes.bool,
  columns: PropTypes.array,
  rows: PropTypes.array
});

export { DataDownloadOptions };