function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { getDashboardConfig } from './dashboard_config';
import { navigateToDefaultApp as _navigateToDefaultApp } from './navigate_to_default_app';
import { createLegacyUrlForwardApp } from './forward_app';
import { injectHeaderStyle } from './utils/inject_header_style';
import { navigateToLegacyKibanaUrl as _navigateToLegacyKibanaUrl } from './forward_app/navigate_to_legacy_kibana_url';
export var KibanaLegacyPlugin = /*#__PURE__*/function () {
  function KibanaLegacyPlugin(initializerContext) {
    _classCallCheck(this, KibanaLegacyPlugin);

    this.initializerContext = initializerContext;

    _defineProperty(this, "forwardDefinitions", []);

    _defineProperty(this, "currentAppId", void 0);

    _defineProperty(this, "currentAppIdSubscription", void 0);
  }

  _createClass(KibanaLegacyPlugin, [{
    key: "setup",
    value: function setup(core) {
      var _this = this;

      core.application.register(createLegacyUrlForwardApp(core, this.forwardDefinitions));
      return {
        /**
         * Forwards URLs within the legacy `kibana` app to a new platform application.
         *
         * @param legacyAppId The name of the old app to forward URLs from
         * @param newAppId The name of the new app that handles the URLs now
         * @param rewritePath Function to rewrite the legacy sub path of the app to the new path in the core app.
         *        If none is provided, it will just strip the prefix of the legacyAppId away
         *
         * path into the new path
         *
         * Example usage:
         * ```
         * kibanaLegacy.forwardApp(
         *   'old',
         *   'new',
         *   path => {
         *     const [, id] = /old/item\/(.*)$/.exec(path) || [];
         *     if (!id) {
         *       return '#/home';
         *     }
         *     return '#/items/${id}';
         *  }
         * );
         * ```
         * This will cause the following redirects:
         *
         * * app/kibana#/old/ -> app/new#/home
         * * app/kibana#/old/item/123 -> app/new#/items/123
         *
         */
        forwardApp: function forwardApp(legacyAppId, newAppId, rewritePath) {
          _this.forwardDefinitions.push({
            legacyAppId: legacyAppId,
            newAppId: newAppId,
            rewritePath: rewritePath || function (path) {
              return "#".concat(path.replace("/".concat(legacyAppId), '') || '/');
            }
          });
        }
      };
    }
  }, {
    key: "start",
    value: function start(_ref) {
      var _this2 = this;

      var application = _ref.application,
          basePath = _ref.http.basePath,
          uiSettings = _ref.uiSettings;
      this.currentAppIdSubscription = application.currentAppId$.subscribe(function (currentAppId) {
        _this2.currentAppId = currentAppId;
      });
      injectHeaderStyle(uiSettings);
      return {
        /**
         * Used to power dashboard mode. Should be removed when dashboard mode is removed eventually.
         * @deprecated
         */
        dashboardConfig: getDashboardConfig(!application.capabilities.dashboard.showWriteControls),

        /**
         * Navigates to the app defined as kibana.defaultAppId.
         * This takes redirects into account and uses the right mechanism to navigate.
         */
        navigateToDefaultApp: function navigateToDefaultApp() {
          var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
            overwriteHash: true
          },
              overwriteHash = _ref2.overwriteHash;

          _navigateToDefaultApp(_this2.initializerContext.config.get().defaultAppId, _this2.forwardDefinitions, application, basePath, _this2.currentAppId, overwriteHash);
        },

        /**
         * Resolves the provided hash using the registered forwards and navigates to the target app.
         * If a navigation happened, `{ navigated: true }` will be returned.
         * If no matching forward is found, `{ navigated: false }` will be returned.
         * @param hash
         */
        navigateToLegacyKibanaUrl: function navigateToLegacyKibanaUrl(hash) {
          return _navigateToLegacyKibanaUrl(hash, _this2.forwardDefinitions, basePath, application);
        },

        /**
         * Loads the font-awesome icon font. Should be removed once the last consumer has migrated to EUI
         * @deprecated
         */
        loadFontAwesome: function () {
          var _loadFontAwesome = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
            return regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return import('./font_awesome');

                  case 2:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee);
          }));

          function loadFontAwesome() {
            return _loadFontAwesome.apply(this, arguments);
          }

          return loadFontAwesome;
        }(),

        /**
         * @deprecated
         * Just exported for wiring up with legacy platform, should not be used.
         */
        getForwards: function getForwards() {
          return _this2.forwardDefinitions;
        },

        /**
         * @deprecated
         * Just exported for wiring up with dashboard mode, should not be used.
         */
        config: this.initializerContext.config.get()
      };
    }
  }, {
    key: "stop",
    value: function stop() {
      if (this.currentAppIdSubscription) {
        this.currentAppIdSubscription.unsubscribe();
      }
    }
  }]);

  return KibanaLegacyPlugin;
}();