function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { ManagementSection } from './utils';
import { IngestSection, DataSection, InsightsAndAlertingSection, SecuritySection, KibanaSection, StackSection } from './components/management_sections';
import { createGetterSetter } from '../../kibana_utils/public';

var _createGetterSetter = createGetterSetter('SectionsServiceStartPrivate'),
    _createGetterSetter2 = _slicedToArray(_createGetterSetter, 2),
    getSectionsServiceStartPrivate = _createGetterSetter2[0],
    setSectionsServiceStartPrivate = _createGetterSetter2[1];

export { getSectionsServiceStartPrivate };
export var ManagementSectionsService = /*#__PURE__*/function () {
  function ManagementSectionsService() {
    var _this = this;

    _classCallCheck(this, ManagementSectionsService);

    _defineProperty(this, "definedSections", void 0);

    _defineProperty(this, "sections", new Map());

    _defineProperty(this, "getAllSections", function () {
      return _toConsumableArray(_this.sections.values());
    });

    _defineProperty(this, "registerSection", function (section) {
      if (_this.sections.has(section.id)) {
        throw Error("ManagementSection '".concat(section.id, "' already registered"));
      }

      var newSection = new ManagementSection(section);

      _this.sections.set(section.id, newSection);

      return newSection;
    });

    // Note on adding sections - sections can be defined in a plugin and exported as a contract
    // It is not necessary to define all sections here, although we've chose to do it for discovery reasons.
    this.definedSections = {
      ingest: this.registerSection(IngestSection),
      data: this.registerSection(DataSection),
      insightsAndAlerting: this.registerSection(InsightsAndAlertingSection),
      security: this.registerSection(SecuritySection),
      kibana: this.registerSection(KibanaSection),
      stack: this.registerSection(StackSection)
    };
  }

  _createClass(ManagementSectionsService, [{
    key: "setup",
    value: function setup() {
      return {
        register: this.registerSection,
        section: _objectSpread({}, this.definedSections)
      };
    }
  }, {
    key: "start",
    value: function start(_ref) {
      var _this2 = this;

      var capabilities = _ref.capabilities;
      this.getAllSections().forEach(function (section) {
        if (capabilities.management.hasOwnProperty(section.id)) {
          var sectionCapabilities = capabilities.management[section.id];
          section.apps.forEach(function (app) {
            if (sectionCapabilities.hasOwnProperty(app.id) && sectionCapabilities[app.id] !== true) {
              app.disable();
            }
          });
        }
      });
      setSectionsServiceStartPrivate({
        getSectionsEnabled: function getSectionsEnabled() {
          return _this2.getAllSections().filter(function (section) {
            return section.enabled;
          });
        }
      });
      return {};
    }
  }]);

  return ManagementSectionsService;
}();