/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventDataBatch;
import com.microsoft.azure.eventhubs.PayloadSizeExceededException;
import com.microsoft.azure.eventhubs.impl.EventDataImpl;
import java.nio.BufferOverflowException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.qpid.proton.message.Message;

final class EventDataBatchImpl
implements EventDataBatch {
    private final int maxMessageSize;
    private final String partitionKey;
    private final List<EventData> events;
    private final byte[] eventBytes;
    private int currentSize = 0;

    EventDataBatchImpl(int maxMessageSize, String partitionKey) {
        this.maxMessageSize = maxMessageSize;
        this.partitionKey = partitionKey;
        this.events = new LinkedList<EventData>();
        this.currentSize = maxMessageSize / 65536 * 1024;
        this.eventBytes = new byte[maxMessageSize];
    }

    @Override
    public final int getSize() {
        return this.events.size();
    }

    @Override
    public final boolean tryAdd(EventData eventData) throws PayloadSizeExceededException {
        int size;
        if (eventData == null) {
            throw new IllegalArgumentException("eventData cannot be null");
        }
        EventDataImpl eventDataImpl = (EventDataImpl)eventData;
        try {
            size = this.getSize(eventDataImpl, this.events.isEmpty());
        }
        catch (BufferOverflowException exception) {
            throw new PayloadSizeExceededException(String.format("Size of the payload exceeded Maximum message size: %s kb", this.maxMessageSize / 1024));
        }
        if (this.currentSize + size > this.maxMessageSize) {
            return false;
        }
        this.events.add(eventDataImpl);
        this.currentSize += size;
        return true;
    }

    public Iterator<EventData> iterator() {
        return this.events.iterator();
    }

    Iterable<EventData> getInternalIterable() {
        return this.events;
    }

    String getPartitionKey() {
        return this.partitionKey;
    }

    private int getSize(EventDataImpl eventData, boolean isFirst) {
        Message amqpMessage = this.partitionKey != null ? eventData.toAmqpMessage(this.partitionKey) : eventData.toAmqpMessage();
        int eventSize = amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        eventSize += 16;
        if (isFirst) {
            amqpMessage.setBody(null);
            amqpMessage.setApplicationProperties(null);
            amqpMessage.setProperties(null);
            amqpMessage.setDeliveryAnnotations(null);
            eventSize += amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        }
        return eventSize;
    }
}

