/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport.tls;

import java.io.Serializable;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.snmp4j.TransportStateReference;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.TLSTMUtil;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.TlsTrustManager;

public class TLSTMExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final LogAdapter logger = LogFactory.getLogger(TLSTMExtendedTrustManager.class);
    X509TrustManager trustManager;
    private boolean useClientMode;
    private TransportStateReference tmStateReference;
    private CounterSupport tlstmCounters;
    private TlsTmSecurityCallback<X509Certificate> securityCallback;

    public TLSTMExtendedTrustManager(CounterSupport tlstmCounters, TlsTmSecurityCallback<X509Certificate> securityCallback, X509TrustManager trustManager, boolean useClientMode, TransportStateReference tmStateReference) {
        this.tlstmCounters = tlstmCounters;
        this.securityCallback = securityCallback;
        this.trustManager = trustManager;
        this.useClientMode = useClientMode;
        this.tmStateReference = tmStateReference;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (!this.checkClientTrustedIntern(x509Certificates)) {
            try {
                this.trustManager.checkClientTrusted(x509Certificates, s);
            }
            catch (CertificateException cex) {
                this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
                this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
                logger.warn((Serializable)((Object)("Client certificate validation failed for '" + x509Certificates[0] + "'")));
                throw cex;
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        if (this.preCheckServerTrusted(x509Certificates)) {
            return;
        }
        try {
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }
        catch (CertificateException cex) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidServerCertificates));
            logger.warn((Serializable)((Object)("Server certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
        this.postCheckServerTrusted(x509Certificates);
    }

    private boolean isMatchingFingerprint(X509Certificate[] x509Certificates, OctetString fingerprint, boolean useClientMode) throws CertificateException {
        return TLSTMUtil.isMatchingFingerprint(x509Certificates, fingerprint, useClientMode, this.tlstmCounters, logger, this);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return TlsTrustManager.getAcceptedIssuers(this.trustManager, this.securityCallback);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        logger.debug((Serializable)((Object)"checkClientTrusted with socket"));
        if (!this.checkClientTrustedIntern(x509Certificates)) {
            try {
                if (this.trustManager instanceof X509ExtendedTrustManager) {
                    logger.debug((Serializable)((Object)"Extended checkClientTrusted with socket"));
                    ((X509ExtendedTrustManager)this.trustManager).checkClientTrusted(x509Certificates, s, socket);
                } else {
                    this.trustManager.checkClientTrusted(x509Certificates, s);
                }
            }
            catch (CertificateException cex) {
                this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
                this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
                logger.warn((Serializable)((Object)("Client certificate validation failed for '" + x509Certificates[0] + "'")));
                throw cex;
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
        logger.debug((Serializable)((Object)"checkClientTrusted with socket"));
        if (this.preCheckServerTrusted(x509Certificates)) {
            return;
        }
        try {
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                logger.debug((Serializable)((Object)"extended checkClientTrusted with socket"));
                ((X509ExtendedTrustManager)this.trustManager).checkServerTrusted(x509Certificates, s, socket);
            } else {
                this.trustManager.checkServerTrusted(x509Certificates, s);
                this.postCheckServerTrusted(x509Certificates);
            }
        }
        catch (CertificateException cex) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidServerCertificates));
            logger.warn((Serializable)((Object)("Server certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
    }

    private void postCheckServerTrusted(X509Certificate[] x509Certificates) throws CertificateException {
        if (this.useClientMode && this.securityCallback != null) {
            this.securityCallback.isServerCertificateAccepted(x509Certificates);
        }
    }

    private boolean preCheckServerTrusted(X509Certificate[] x509Certificates) throws CertificateException {
        X500Principal x500Principal;
        OctetString fingerprint;
        if (this.tmStateReference.getCertifiedIdentity() != null && TLSTMUtil.isMatchingFingerprint(x509Certificates, fingerprint = this.tmStateReference.getCertifiedIdentity().getServerFingerprint(), true, this.tlstmCounters, logger, this)) {
            return true;
        }
        Object entry = null;
        try {
            entry = TLSTMUtil.getSubjAltName(x509Certificates[0].getSubjectAlternativeNames(), 2);
        }
        catch (CertificateParsingException e) {
            logger.error((Serializable)((Object)("CertificateParsingException while verifying server certificate " + Arrays.asList(x509Certificates))));
        }
        if (entry == null && (x500Principal = x509Certificates[0].getSubjectX500Principal()) != null) {
            entry = x500Principal.getName();
        }
        if (entry != null) {
            String dNSName = ((String)entry).toLowerCase();
            String hostName = ((IpAddress)this.tmStateReference.getAddress()).getInetAddress().getCanonicalHostName();
            if (dNSName.length() > 0) {
                if (dNSName.charAt(0) == '*') {
                    int pos = hostName.indexOf(46);
                    hostName = hostName.substring(pos);
                    dNSName = dNSName.substring(1);
                }
                if (hostName.equalsIgnoreCase(dNSName)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Peer hostname " + hostName + " matches dNSName " + dNSName);
                    }
                    return true;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Peer hostname " + hostName + " did not match dNSName " + dNSName)));
            }
        }
        return false;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        logger.debug((Serializable)((Object)"checkClientTrusted with sslEngine"));
        boolean clientTrusted = this.checkClientTrustedIntern(x509Certificates);
        if (!clientTrusted) {
            try {
                if (this.trustManager instanceof X509ExtendedTrustManager) {
                    logger.debug((Serializable)((Object)"extended checkClientTrusted with sslEngine"));
                    ((X509ExtendedTrustManager)this.trustManager).checkClientTrusted(x509Certificates, s, sslEngine);
                } else {
                    this.trustManager.checkClientTrusted(x509Certificates, s);
                }
            }
            catch (CertificateException cex) {
                this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
                this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidClientCertificates));
                logger.warn((Serializable)((Object)("Client certificate validation failed for '" + x509Certificates[0] + "'")));
                throw cex;
            }
        }
    }

    private boolean checkClientTrustedIntern(X509Certificate[] x509Certificates) throws CertificateException {
        OctetString fingerprint;
        if (this.tmStateReference != null && this.tmStateReference.getCertifiedIdentity() != null && this.isMatchingFingerprint(x509Certificates, fingerprint = this.tmStateReference.getCertifiedIdentity().getClientFingerprint(), true)) {
            return true;
        }
        if (!this.useClientMode && this.securityCallback != null && this.securityCallback.isClientCertificateAccepted(x509Certificates[0])) {
            if (logger.isInfoEnabled()) {
                logger.info("Client is trusted with certificate '" + x509Certificates[0] + "'");
            }
            return true;
        }
        return false;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
        logger.debug((Serializable)((Object)"checkServerTrusted with sslEngine"));
        if (this.preCheckServerTrusted(x509Certificates)) {
            return;
        }
        try {
            if (this.trustManager instanceof X509ExtendedTrustManager) {
                logger.debug((Serializable)((Object)"extended checkServerTrusted with sslEngine"));
                ((X509ExtendedTrustManager)this.trustManager).checkServerTrusted(x509Certificates, s, sslEngine);
            } else {
                this.trustManager.checkServerTrusted(x509Certificates, s);
            }
        }
        catch (CertificateException cex) {
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionOpenErrors));
            this.tlstmCounters.fireIncrementCounter(new CounterEvent(this, SnmpConstants.snmpTlstmSessionInvalidServerCertificates));
            logger.warn((Serializable)((Object)("Server certificate validation failed for '" + x509Certificates[0] + "'")));
            throw cex;
        }
        this.postCheckServerTrusted(x509Certificates);
    }
}

