/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.indexing;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.CssFileModel;
import org.netbeans.modules.css.indexing.CssIndexModelSupport;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.indexing.api.CssIndexModel;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class CssIndexer
extends EmbeddingIndexer {
    private static final RequestProcessor RP = new RequestProcessor();
    private static final Logger LOGGER = Logger.getLogger(CssIndexer.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    public static final String CSS_CONTENT_KEY = "cssContent";
    public static final String IMPORTS_KEY = "imports";
    public static final String IDS_KEY = "ids";
    public static final String CLASSES_KEY = "classes";
    public static final String HTML_ELEMENTS_KEY = "htmlElements";
    public static final String COLORS_KEY = "colors";
    public static final char VIRTUAL_ELEMENT_MARKER = '!';
    private static final Map<FileObject, AtomicLong> importsHashCodes = new HashMap<FileObject, AtomicLong>();
    private static Map<FileObject, AtomicLong> computedImportsHashCodes = new HashMap<FileObject, AtomicLong>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        try {
            if (LOG) {
                FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
                LOGGER.log(Level.FINE, "indexing {0}", fo.getPath());
            }
            CssParserResult result = (CssParserResult)parserResult;
            CssFileModel model = CssFileModel.create(result);
            IndexingSupport support = IndexingSupport.getInstance((Context)context);
            IndexDocument document = support.createDocument(indexable);
            this.storeEntries(model.getIds(), document, IDS_KEY);
            this.storeEntries(model.getClasses(), document, CLASSES_KEY);
            this.storeEntries(model.getHtmlElements(), document, HTML_ELEMENTS_KEY);
            this.storeEntries(model.getColors(), document, COLORS_KEY);
            int entriesHashCode = this.storeEntries(model.getImports(), document, IMPORTS_KEY);
            FileObject root = context.getRoot();
            Map<FileObject, AtomicLong> map = importsHashCodes;
            synchronized (map) {
                AtomicLong aggregatedHash = importsHashCodes.get(root);
                if (aggregatedHash == null) {
                    aggregatedHash = new AtomicLong(0L);
                    importsHashCodes.put(root, aggregatedHash);
                }
                aggregatedHash.set(aggregatedHash.get() * 79L + (long)entriesHashCode);
            }
            document.addPair(CSS_CONTENT_KEY, Boolean.TRUE.toString(), true, true);
            Collection<CssIndexModel> indexModels = CssIndexModelSupport.getModels(result);
            for (CssIndexModel indexModel : indexModels) {
                indexModel.storeToIndex(document);
            }
            support.addDocument(document);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static long getImportsHashCodeForRoots(Collection<FileObject> roots) {
        long hash = 5L;
        for (FileObject root : roots) {
            AtomicLong rootHash = computedImportsHashCodes.get(root);
            if (rootHash == null) continue;
            hash = hash * 51L + rootHash.longValue();
        }
        return hash;
    }

    private int storeEntries(Collection<Entry> entries, IndexDocument doc, String key) {
        if (!entries.isEmpty()) {
            TreeSet<String> entryStrings = new TreeSet<String>();
            for (Entry entry : entries) {
                if (entry.isVirtual()) {
                    entryStrings.add(entry.getName() + '!');
                    continue;
                }
                entryStrings.add(entry.getName());
            }
            for (String e : entryStrings) {
                doc.addPair(key, e, true, true);
            }
            return entryStrings.hashCode();
        }
        return 0;
    }

    private static void fireChange(FileObject fo) {
        RP.post(() -> CssIndexer.fireChangeImpl(fo));
    }

    private static void fireChangeImpl(FileObject fo) {
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p == null) {
            return;
        }
        try {
            CssIndex index = CssIndex.get(p);
            if (index != null) {
                index.notifyChange();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "css";
        public static final int VERSION = 5;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(snapshot)) {
                return new CssIndexer();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean scanStarted(Context context) {
            Map map = importsHashCodes;
            synchronized (map) {
                importsHashCodes.remove(context.getRoot());
            }
            return super.scanStarted(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scanFinished(Context context) {
            Map map = importsHashCodes;
            synchronized (map) {
                computedImportsHashCodes = new HashMap(importsHashCodes);
            }
            FileObject root = context.getRoot();
            if (root != null) {
                CssIndexer.fireChange(root);
            }
            super.scanFinished(context);
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 5;
        }

        private boolean isIndexable(Snapshot snapshot) {
            return "text/css".equals(snapshot.getMimeType());
        }
    }
}

