/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UIData;
import org.primefaces.component.datalist.DataList;
import org.primefaces.component.datalist.DataListRenderer;
import org.primefaces.util.WidgetBuilder;

public class DataListRenderer
extends org.primefaces.component.datalist.DataListRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    protected void encodeScript(FacesContext context, DataList list) throws IOException {
        String clientId = list.getClientId();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("DataList", list.resolveWidgetVar(), clientId);
        this.encodeClientBehaviors(context, list);
        wb.finish();
    }

    public void encodeMarkup(FacesContext context, DataList list) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = list.getClientId(context);
        String style = list.getStyle();
        String styleClass = list.getStyleClass();
        int first = list.getFirst();
        int rows = list.getRows() == 0 ? list.getRowCount() : list.getRows();
        int pageSize = first + rows;
        int rowCount = list.getRowCount();
        String varStatus = list.getVarStatus();
        Map requestMap = context.getExternalContext().getRequestMap();
        String listTag = list.getListTag();
        writer.startElement(listTag, (UIComponent)list);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (list.getItemType() != null) {
            writer.writeAttribute("type", (Object)list.getItemType(), null);
        }
        this.encodeFacet(context, list, "header");
        for (int i = first; i < rowCount; ++i) {
            if (varStatus != null) {
                requestMap.put(varStatus, new DataListRenderer.VarStatus(first, pageSize - 1, i == 0, i == rowCount - 1, i, i % 2 == 0, i % 2 == 1, 1));
            }
            list.setRowIndex(i);
            if (!list.isRowAvailable()) continue;
            writer.startElement("li", null);
            this.renderChildren(context, (UIComponent)list);
            writer.endElement("li");
        }
        list.setRowIndex(-1);
        if (varStatus != null) {
            requestMap.remove(varStatus);
        }
        this.encodeFacet(context, list, "footer");
        writer.endElement(listTag);
    }

    public void encodeFacet(FacesContext context, UIData data, String facet) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent component = data.getFacet(facet);
        if (component != null && component.isRendered()) {
            writer.startElement("li", null);
            writer.writeAttribute("data-role", (Object)"list-divider", null);
            writer.writeAttribute("role", (Object)"heading", null);
            component.encodeAll(context);
            writer.endElement("li");
        }
    }
}

