/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.api.ModuleSearchSupport;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.spi.GradleFiles;

public final class GradleBaseProject
implements Serializable,
ModuleSearchSupport {
    public static final String PRIVATE_TASK_GROUP = "<private>";
    String name;
    String group = "";
    String description;
    String version;
    String path;
    String status;
    String parentName;
    String displayName;
    File buildDir;
    File projectDir;
    File rootDir;
    String license;
    Set<String> plugins = Collections.emptySet();
    Set<File> gradleClassPath = Collections.emptySet();
    Set<File> buildClassPath = Collections.emptySet();
    Map<String, File> subProjects = Collections.emptyMap();
    Map<String, File> includedBuilds = Collections.emptyMap();
    Map<String, List<GradleTask>> tasksByGroup = new HashMap<String, List<GradleTask>>();
    Map<String, GradleTask> tasksByName = new HashMap<String, GradleTask>();
    Map<String, String> netBeansProperties = Collections.emptyMap();
    Map<File, GradleDependency.ModuleDependency> componentsByFile = new HashMap<File, GradleDependency.ModuleDependency>();
    Map<String, GradleConfiguration> configurations = new HashMap<String, GradleConfiguration>();
    Set<File> outputPaths = Collections.emptySet();
    transient Boolean resolved = null;

    GradleBaseProject() {
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getStatus() {
        return this.status;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public Set<File> getOutputPaths() {
        return this.outputPaths;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public Set<String> getPlugins() {
        return this.plugins;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public Set<File> getGradleClassPath() {
        return this.gradleClassPath;
    }

    public Set<File> getBuildClassPath() {
        return this.buildClassPath;
    }

    public Map<String, File> getIncludedBuilds() {
        return this.includedBuilds;
    }

    public boolean isRoot() {
        return this.projectDir.equals(this.rootDir);
    }

    public String getNetBeansProperty(String key) {
        return this.netBeansProperties.get(key);
    }

    public String getLicense() {
        return this.license != null ? this.license : "default";
    }

    public Map<String, File> getSubProjects() {
        return this.subProjects;
    }

    public Set<String> getTaskGroups() {
        return Collections.unmodifiableSet(this.tasksByGroup.keySet());
    }

    public List<GradleTask> getTasks(String group) {
        List<GradleTask> ret = this.tasksByGroup.get(group);
        return ret != null ? Collections.unmodifiableList(ret) : Collections.emptyList();
    }

    public List<GradleTask> getTasks() {
        return Collections.unmodifiableList(new ArrayList<GradleTask>(this.tasksByName.values()));
    }

    public Set<String> getTaskNames() {
        return Collections.unmodifiableSet(this.tasksByName.keySet());
    }

    public GradleTask getTaskByName(String name) {
        return this.tasksByName.get(name);
    }

    public Map<String, GradleConfiguration> getConfigurations() {
        return Collections.unmodifiableMap(this.configurations);
    }

    public Set<GradleDependency.ProjectDependency> getProjectDependencies() {
        HashSet<GradleDependency.ProjectDependency> ret = new HashSet<GradleDependency.ProjectDependency>();
        for (GradleConfiguration conf : this.configurations.values()) {
            ret.addAll(conf.getProjects());
        }
        return Collections.unmodifiableSet(ret);
    }

    public boolean hasPlugins(String ... plugins) {
        for (String plugin : plugins) {
            if (this.plugins.contains(plugin)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<GradleDependency.ModuleDependency> findModules(String group, String artifact, String version) {
        HashSet<GradleDependency.ModuleDependency> ret = new HashSet<GradleDependency.ModuleDependency>();
        for (GradleConfiguration conf : this.configurations.values()) {
            ret.addAll(conf.findModules(group, artifact, version));
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<GradleDependency.ModuleDependency> findModules(String gav) {
        String[] parts = GradleDependency.gavSplit(gav);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid gav filter: " + gav);
        }
        String groupId = parts[0].isEmpty() ? null : parts[0];
        String artifactId = parts[1].isEmpty() ? null : parts[1];
        String ver = parts[2].isEmpty() ? null : parts[2];
        return this.findModules(groupId, artifactId, ver);
    }

    public boolean isResolved() {
        if (this.resolved == null) {
            boolean b = true;
            for (GradleConfiguration value : this.configurations.values()) {
                if (!(b &= value.isResolved())) break;
            }
            this.resolved = b;
        }
        return this.resolved;
    }

    public boolean isRootOf(GradleBaseProject other) {
        if (other == null) {
            return false;
        }
        return this.isRoot() && !other.isRoot() && this.subProjects.containsKey(other.name) && this.projectDir.equals(other.rootDir);
    }

    public boolean isSibling(GradleBaseProject other) {
        if (other == null) {
            return false;
        }
        return !this.isRoot() && !other.isRoot() && this.rootDir.equals(other.rootDir) && !this.projectDir.equals(other.projectDir);
    }

    GradleConfiguration createConfiguration(String name) {
        GradleConfiguration conf = new GradleConfiguration(name);
        this.configurations.put(name, conf);
        return conf;
    }

    public static GradleBaseProject get(Project project) {
        NbGradleProject gp = NbGradleProject.get(project);
        return gp != null ? gp.projectLookup(GradleBaseProject.class) : null;
    }

    static GradleBaseProject getFallback(GradleFiles files) {
        Set<File> subProjects;
        GradleBaseProject ret = new GradleBaseProject();
        ret.name = files.getProjectDir().getName();
        ret.projectDir = files.getProjectDir();
        ret.buildDir = new File(files.getProjectDir(), "build");
        ret.rootDir = files.getRootDir();
        ret.version = "unspecified";
        StringBuilder path = new StringBuilder(":");
        if (!files.isRootProject()) {
            Path prjPath = files.getProjectDir().toPath();
            Path rootPath = files.getRootDir().toPath();
            String separator = "";
            Path relPath = rootPath.relativize(prjPath);
            for (int i = 0; i < relPath.getNameCount(); ++i) {
                path.append(separator);
                path.append(relPath.getName(i));
                separator = ":";
            }
        }
        ret.path = path.toString();
        ret.status = "release";
        ret.parentName = files.isRootProject() ? null : files.getRootDir().getName();
        HashMap<String, String> nbprops = new HashMap<String, String>();
        nbprops.put("augmented.build", "false");
        nbprops.put("compile.on.save", "false");
        ret.netBeansProperties = Collections.unmodifiableMap(nbprops);
        Map<String, File> subPrj = Collections.emptyMap();
        if (files.isRootProject() && files.getSettingsScript() != null && !(subProjects = GradleFiles.SettingsFile.getSubProjects(files.getSettingsScript())).isEmpty()) {
            subPrj = new HashMap();
            for (File sp : subProjects) {
                subPrj.put(sp.getName(), sp);
            }
        }
        ret.subProjects = Collections.unmodifiableMap(subPrj);
        HashSet<String> plugins = new HashSet<String>();
        File srcDir = new File(files.getProjectDir(), "src");
        if (srcDir.isDirectory()) {
            File[] sourceSets;
            HashSet setNames = new HashSet();
            for (File dir : sourceSets = srcDir.listFiles()) {
                if (!dir.isDirectory()) continue;
                if ("dist".equals(dir.getName())) {
                    plugins.add("distribution");
                }
                if (new File(dir, "java").isDirectory()) {
                    plugins.add("java");
                }
                if (new File(dir, "resources").isDirectory()) {
                    plugins.add("java");
                }
                if (new File(dir, "groovy").isDirectory()) {
                    plugins.add("java");
                    plugins.add("groovy");
                    plugins.add("groovy-base");
                }
                if (new File(dir, "scala").isDirectory()) {
                    plugins.add("java");
                    plugins.add("scala");
                    plugins.add("scala-base");
                }
                if (!new File(dir, "webapp").isDirectory()) continue;
                plugins.add("java");
                plugins.add("war");
            }
            if (plugins.contains("java")) {
                plugins.add("java-base");
                plugins.add("base");
            }
            ret.plugins = Collections.unmodifiableSet(plugins);
        }
        return ret;
    }

    public String toString() {
        return "GradleBaseProject{name=" + this.name + ", projectDir=" + this.projectDir + ", plugins=" + this.plugins + '}';
    }
}

