/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class Mappers {
    private static final String ANALYZER_PREFIX = "phpCodeAnalysis:";
    private static final LazyFixList EMPTY_LAZY_FIX_LIST = ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());

    private Mappers() {
    }

    public static Collection<? extends ErrorDescription> map(List<Result> results) {
        ArrayList<ErrorDescription> errorDescriptions = new ArrayList<ErrorDescription>(results.size());
        FileObject file = null;
        String filePath = null;
        int[] lineMap = null;
        for (Result result : results) {
            String currentFilePath = result.getFilePath();
            if (!currentFilePath.equals(filePath)) {
                filePath = currentFilePath;
                file = FileUtil.toFileObject((File)new File(currentFilePath));
                assert (file != null) : "File object not found for " + currentFilePath;
                lineMap = AnalysisUtils.computeLineMap(file, FileEncodingQuery.getEncoding((FileObject)file));
            }
            assert (file != null);
            assert (filePath != null);
            assert (lineMap != null);
            errorDescriptions.add(Mappers.map(result, file, lineMap));
        }
        return errorDescriptions;
    }

    private static ErrorDescription map(Result result, FileObject file, int[] lineMap) {
        int line = 2 * (Math.min(result.getLine(), lineMap.length / 2) - 1);
        return ErrorDescriptionFactory.createErrorDescription((String)(ANALYZER_PREFIX + result.getCategory()), (Severity)Severity.VERIFIER, (String)result.getCategory(), (CharSequence)result.getDescription(), (LazyFixList)EMPTY_LAZY_FIX_LIST, (FileObject)file, (int)lineMap[line], (int)lineMap[line + 1]);
    }
}

