/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.j2ee.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

public class SoapClientUtils {
    private static Map<String, String> xsdToJavaTypes = null;

    public static String toJavaType(String xsdType) {
        if (xsdToJavaTypes == null) {
            xsdToJavaTypes = new HashMap<String, String>();
            xsdToJavaTypes.put("string", "java.lang.String");
            xsdToJavaTypes.put("boolean", "java.lang.Boolean");
            xsdToJavaTypes.put("date", "java.sql.Date");
            xsdToJavaTypes.put("dateTime", "java.sql.Date");
            xsdToJavaTypes.put("time", "java.sql.Time");
            xsdToJavaTypes.put("token", "java.lang.String");
            xsdToJavaTypes.put("double", "java.lang.Double");
            xsdToJavaTypes.put("float", "java.lang.Float");
            xsdToJavaTypes.put("byte", "java.lang.Byte");
            xsdToJavaTypes.put("int", "java.lang.Integer");
            xsdToJavaTypes.put("long", "java.lang.Long");
            xsdToJavaTypes.put("short", "java.lang.Short");
            xsdToJavaTypes.put("unsignedByte", "java.lang.Byte");
            xsdToJavaTypes.put("unsignedInt", "java.lang.Integer");
            xsdToJavaTypes.put("unsignedLong", "java.lang.Long");
            xsdToJavaTypes.put("unsignedShort", "java.lang.Short");
            xsdToJavaTypes.put("nonNegativeInteger", "java.lang.Integer");
            xsdToJavaTypes.put("nonPositiveInteger", "java.lang.Integer");
            xsdToJavaTypes.put("negativeInteger", "java.lang.Integer");
            xsdToJavaTypes.put("positiveInteger", "java.lang.Integer");
        }
        return xsdToJavaTypes.get(xsdType);
    }

    public static Map<QName, String> getSoapHandlerParameters(WSDLModel model, WSPort wsPort, WSOperation wsOperation) {
        HashMap<QName, String> paramMap = new HashMap<QName, String>();
        QName portQName = new QName(wsPort.getNamespaceURI(), wsPort.getName());
        Binding binding = null;
        for (Binding b : model.getDefinitions().getBindings()) {
            if (!b.getType().getQName().equals(portQName)) continue;
            binding = b;
            break;
        }
        if (binding == null) {
            return paramMap;
        }
        List soapBindings = binding.getExtensibilityElements(SOAPBinding.class);
        if (soapBindings.isEmpty()) {
            return paramMap;
        }
        BindingOperation bindingOperation = null;
        for (BindingOperation bOp : binding.getBindingOperations()) {
            if (!((Operation)bOp.getOperation().get()).getName().equals(wsOperation.getOperationName())) continue;
            bindingOperation = bOp;
            break;
        }
        if (bindingOperation == null) {
            return paramMap;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        for (SOAPHeader header : bindingInput.getExtensibilityElements(SOAPHeader.class)) {
            Part part;
            if (header.getPartRef() == null || (part = (Part)header.getPartRef().get()) == null || part.getElement() == null) continue;
            GlobalElement element = (GlobalElement)part.getElement().get();
            paramMap.put(part.getElement().getQName(), SoapClientUtils.guessSimpleJavaType(element));
        }
        return paramMap;
    }

    public static String guessSimpleJavaType(GlobalElement element) {
        NamedComponentReference ref;
        LocalSimpleType lst;
        String xsdType = null;
        String javaType = Object.class.getName();
        if (element.getType() != null && element.getType().getEffectiveNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            xsdType = ((GlobalType)element.getType().get()).getName();
        } else if (element.getInlineType() instanceof LocalSimpleType && (lst = (LocalSimpleType)element.getInlineType()).getDefinition() instanceof SimpleTypeRestriction && (ref = ((SimpleTypeRestriction)lst.getDefinition()).getBase()).getEffectiveNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            xsdType = ((GlobalSimpleType)ref.get()).getName();
        }
        if (xsdType != null) {
            javaType = SoapClientUtils.toJavaType(xsdType);
        }
        return javaType;
    }
}

