/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.jtreg;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.netbeans.modules.java.openjdk.jtreg.Bundle;
import org.netbeans.modules.java.openjdk.jtreg.Tag;
import org.netbeans.modules.java.openjdk.jtreg.TagParser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public class ModulesHint {
    private static final Pattern EXPORTS = Pattern.compile("exports\\s+(([a-zA-Z0-9]+\\.)*[a-zA-Z0-9]+)(?<to>\\s+to)?");

    public static ErrorDescription computeWarning(HintContext ctx) {
        Pair<Fix, int[]> fix = ModulesHint.computeChange(ctx.getInfo());
        if (fix == null) {
            return null;
        }
        ErrorDescription idealED = ErrorDescriptionFactory.forName((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.ERR_ModulesHint(), (Fix[])new Fix[]{(Fix)fix.first()});
        return org.netbeans.spi.editor.hints.ErrorDescriptionFactory.createErrorDescription((Severity)idealED.getSeverity(), (String)idealED.getDescription(), (LazyFixList)idealED.getFixes(), (FileObject)ctx.getInfo().getFileObject(), (int)((int[])fix.second())[0], (int)((int[])fix.second())[1]);
    }

    static Pair<Fix, int[]> computeChange(CompilationInfo info) {
        Map<String, Set<String>> actual;
        TagParser.Result tags = TagParser.parseTags(info);
        if (!tags.getName2Tag().containsKey("test")) {
            return null;
        }
        Pair<Map<String, Set<String>>, Set<Project>> computeModulesAndPackagesAndProjects = ModulesHint.computeModulesAndPackages(info, tags);
        Map<String, Set<String>> projectDependencies = ModulesHint.projectDependencies((Set)computeModulesAndPackagesAndProjects.second());
        Map<String, Set<String>> expected = ModulesHint.normalize((Map)computeModulesAndPackagesAndProjects.first(), projectDependencies);
        if (Objects.equals(expected, actual = ModulesHint.normalize((Map)ModulesHint.readModulesAndPackages(tags).first(), projectDependencies))) {
            return null;
        }
        List<Tag> markTag = tags.getName2Tag().get("modules");
        if (markTag == null || markTag.isEmpty()) {
            markTag = tags.getName2Tag().get("test");
        }
        return Pair.of((Object)new FixImpl(info, new TreePath(info.getCompilationUnit()), expected).toEditorFix(), (Object)new int[]{markTag.get(0).getTagStart(), markTag.get(0).getTagEnd()});
    }

    private static Map<String, Set<String>> projectDependencies(Set<Project> projects) {
        HashMap<String, Set<Object>> project2DirectDependencies = new HashMap<String, Set<Object>>();
        LinkedList<Project> todoList = new LinkedList<Project>(projects);
        while (!todoList.isEmpty()) {
            Project prj = (Project)todoList.remove(0);
            String projectName = prj.getProjectDirectory().getNameExt();
            if (project2DirectDependencies.containsKey(projectName)) continue;
            SubprojectProvider subProject = (SubprojectProvider)prj.getLookup().lookup(SubprojectProvider.class);
            if (subProject == null) {
                project2DirectDependencies.put(projectName, Collections.emptySet());
                continue;
            }
            HashSet<String> deps = new HashSet<String>();
            for (Project dep : subProject.getSubprojects()) {
                if (Objects.equals(projectName, dep.getProjectDirectory().getNameExt())) continue;
                todoList.add(dep);
                deps.add(dep.getProjectDirectory().getNameExt());
            }
            project2DirectDependencies.put(projectName, deps);
        }
        try {
            List sortedProjects = Utilities.topologicalSort(project2DirectDependencies.keySet(), project2DirectDependencies);
            HashMap<String, Set<String>> project2AllDependencies = new HashMap<String, Set<String>>();
            Collections.reverse(sortedProjects);
            for (String prj : sortedProjects) {
                HashSet<String> dependencies = new HashSet<String>();
                for (String dep : (Set)project2DirectDependencies.get(prj)) {
                    dependencies.add(dep);
                    dependencies.addAll((Collection)project2AllDependencies.get(dep));
                }
                project2AllDependencies.put(prj, dependencies);
            }
            return project2AllDependencies;
        }
        catch (TopologicalSortException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyMap();
        }
    }

    private static Map<String, Set<String>> normalize(Map<String, Set<String>> modulesAndPackages, Map<String, Set<String>> projectDependencies) {
        for (Map.Entry<String, Set<String>> e : projectDependencies.entrySet()) {
            if (!modulesAndPackages.containsKey(e.getKey())) continue;
            for (String dep : e.getValue()) {
                Set<String> depPackages = modulesAndPackages.get(dep);
                if (depPackages == null || !depPackages.isEmpty()) continue;
                modulesAndPackages.remove(dep);
            }
        }
        Set<String> javaBasePackages = modulesAndPackages.get("java.base");
        if (javaBasePackages != null && javaBasePackages.isEmpty()) {
            modulesAndPackages.remove("java.base");
        }
        return modulesAndPackages;
    }

    static Pair<Map<String, Set<String>>, Set<Project>> computeModulesAndPackages(CompilationInfo info, TagParser.Result tags) {
        HashMap<String, Set<String>> module2UsedUnexportedPackages = new HashMap<String, Set<String>>();
        HashSet<TypeElement> seenClasses = new HashSet<TypeElement>();
        HashSet<Project> seenProjects = new HashSet<Project>();
        HashSet<CompilationUnitTree> seen = new HashSet<CompilationUnitTree>();
        ModulesHint.computeModulesAndPackages(info, info.getCompilationUnit(), module2UsedUnexportedPackages, seenClasses, seenProjects, seen);
        List<Tag> buildTags = tags.getName2Tag().get("build");
        if (buildTags != null) {
            for (Tag buildTag : buildTags) {
                String[] classNames;
                for (String className : classNames = buildTag.getValue().split("\\s+")) {
                    TreePath builtPath;
                    TypeElement built = info.getElements().getTypeElement(className);
                    if (built == null || (builtPath = info.getTrees().getPath(built)) == null) continue;
                    ModulesHint.computeModulesAndPackages(info, builtPath.getCompilationUnit(), module2UsedUnexportedPackages, seenClasses, seenProjects, seen);
                }
            }
        }
        return Pair.of(module2UsedUnexportedPackages, seenProjects);
    }

    static void computeModulesAndPackages(final CompilationInfo info, CompilationUnitTree cut, Map<String, Set<String>> module2UsedUnexportedPackages, final Set<TypeElement> seenClasses, Set<Project> seenProjects, Set<CompilationUnitTree> seen) {
        if (!seen.add(cut)) {
            return;
        }
        final HashSet classes = new HashSet();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void p) {
                TypeElement outermost;
                if (tree == null) {
                    return null;
                }
                Element el = info.getTrees().getElement(new TreePath(this.getCurrentPath(), tree));
                if (el != null && el.getKind() != ElementKind.PACKAGE && el.getKind() != ElementKind.OTHER && (outermost = info.getElementUtilities().outermostTypeElement(el)) != null && seenClasses.add(outermost)) {
                    classes.add(outermost);
                }
                return (Void)super.scan(tree, p);
            }
        }.scan((Tree)cut, (Void)null);
        HashMap<FileObject, HashSet<String>> module2Packages = new HashMap<FileObject, HashSet<String>>();
        for (TypeElement typeElement : classes) {
            FileObject file = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)info.getClasspathInfo());
            if (file == null) continue;
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            if (prj != null && FileUtil.isParentOf((FileObject)prj.getProjectDirectory(), (FileObject)file)) {
                FileObject prjDir = prj.getProjectDirectory();
                HashSet<String> currentModulePackages = (HashSet<String>)module2Packages.get(prjDir);
                if (currentModulePackages == null) {
                    currentModulePackages = new HashSet<String>();
                    module2Packages.put(prjDir, currentModulePackages);
                }
                currentModulePackages.add(info.getElements().getPackageOf(typeElement).getQualifiedName().toString());
                seenProjects.add(prj);
                continue;
            }
            TreePath tp = info.getTrees().getPath(typeElement);
            if (tp == null) continue;
            ModulesHint.computeModulesAndPackages(info, tp.getCompilationUnit(), module2UsedUnexportedPackages, seenClasses, seenProjects, seen);
        }
        for (Map.Entry entry : module2Packages.entrySet()) {
            FileObject moduleInfo = BuildUtils.getFileObject((FileObject)entry.getKey(), "share/classes/module-info.java");
            if (moduleInfo == null) continue;
            Set<String> exported = ModulesHint.readExports(moduleInfo);
            Iterator it = ((Set)entry.getValue()).iterator();
            while (it.hasNext()) {
                String pack = (String)it.next();
                if (!exported.contains(pack)) continue;
                it.remove();
            }
            String moduleName = ((FileObject)entry.getKey()).getNameExt();
            Set<String> currentUnexportedpackages = module2UsedUnexportedPackages.get(moduleName);
            if (currentUnexportedpackages == null) {
                currentUnexportedpackages = new HashSet<String>();
                module2UsedUnexportedPackages.put(moduleName, currentUnexportedpackages);
            }
            currentUnexportedpackages.addAll((Collection)entry.getValue());
        }
    }

    static Pair<Map<String, Set<String>>, int[]> readModulesAndPackages(TagParser.Result tags) {
        List<Tag> modulesTags = tags.getName2Tag().get("modules");
        if (modulesTags == null || modulesTags.isEmpty()) {
            return Pair.of(Collections.emptyMap(), (Object)new int[]{-1, -1});
        }
        Tag modules = modulesTags.get(0);
        String textModules = modules.getValue().replaceAll("\\s+", " ").trim();
        String[] parts = textModules.split("\\s");
        HashMap<String, HashSet<String>> module2UsedUnexportedPackages = new HashMap<String, HashSet<String>>();
        for (String part : parts) {
            String[] moduleAndPackage = part.split("/");
            HashSet<String> packages = (HashSet<String>)module2UsedUnexportedPackages.get(moduleAndPackage[0]);
            if (packages == null) {
                packages = new HashSet<String>();
                module2UsedUnexportedPackages.put(moduleAndPackage[0], packages);
            }
            if (moduleAndPackage.length <= 1) continue;
            packages.add(moduleAndPackage[1]);
        }
        return Pair.of(module2UsedUnexportedPackages, (Object)new int[]{modules.getStart(), modules.getEnd()});
    }

    private static Set<String> readExports(FileObject moduleInfo) {
        HashSet<String> exported = new HashSet<String>();
        try (InputStreamReader r = new InputStreamReader(moduleInfo.getInputStream());){
            int read;
            StringBuilder content = new StringBuilder();
            while ((read = ((Reader)r).read()) != -1) {
                content.append((char)read);
            }
            Matcher exportsMatcher = EXPORTS.matcher(content);
            while (exportsMatcher.find()) {
                if (exportsMatcher.group("to") != null) continue;
                String pack = exportsMatcher.group(1);
                exported.add(pack);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return exported;
    }

    private static final class FixImpl
    extends JavaFix {
        private final Map<String, Set<String>> expected;

        private FixImpl(CompilationInfo info, TreePath tp, Map<String, Set<String>> expected) {
            super(info, tp);
            this.expected = expected;
        }

        public String getText() {
            return Bundle.FIX_ModulesHint();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            ArrayList<String> records = new ArrayList<String>();
            for (Map.Entry<String, Set<String>> e : this.expected.entrySet()) {
                if (e.getValue().isEmpty()) {
                    records.add(e.getKey());
                    continue;
                }
                for (String pack : e.getValue()) {
                    records.add(e.getKey() + "/" + pack);
                }
            }
            Collections.sort(records);
            StringBuilder atModules = new StringBuilder();
            atModules.append(" * ");
            atModules.append("@modules ");
            boolean first = true;
            for (String r : records) {
                if (!first) {
                    atModules.append(" * ");
                    atModules.append("         ");
                }
                first = false;
                atModules.append(r).append("\n");
            }
            TagParser.Result tags = TagParser.parseTags((CompilationInfo)ctx.getWorkingCopy());
            int[] span = (int[])ModulesHint.readModulesAndPackages(tags).second();
            int start = -1;
            int end = -1;
            if (span[0] != -1) {
                start = span[0];
                end = span[1];
            } else {
                Map.Entry e;
                int currentIndex;
                TreeMap<Integer, Tag> end2Tag = new TreeMap<Integer, Tag>();
                for (List<Tag> tagsForName : tags.getName2Tag().values()) {
                    for (Tag tag : tagsForName) {
                        end2Tag.put(tag.getEnd(), tag);
                    }
                }
                int modulesIndex = TagParser.RECOMMENDED_TAGS_ORDER.indexOf("modules");
                Iterator iterator = end2Tag.entrySet().iterator();
                while (iterator.hasNext() && (currentIndex = TagParser.RECOMMENDED_TAGS_ORDER.indexOf(((Tag)(e = iterator.next()).getValue()).getName())) != -1 && currentIndex <= modulesIndex) {
                    start = end = ((Integer)e.getKey()).intValue();
                }
            }
            ctx.getWorkingCopy().rewriteInComment(start, end - start, records.isEmpty() ? "" : atModules.toString());
        }
    }
}

