/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.util.Exceptions;

public class Settings {
    private static final String KEY_BUILD_BEFORE_TESTS = "build-before-test";
    private static final String KEY_JTREG_LOCATION = "jtreg-location";
    private static final String KEY_USE_ANT_BUILD = "use-langtools-ant-build";
    private static final String KEY_ANT_BUILD_LOCATION = "langtools-ant-build-location";
    private static final String DEF_ANT_BUILD_LOCATION = "make/langtools/netbeans/langtools/build.xml";
    private final Project prj;

    public Settings(Project prj) {
        this.prj = prj;
    }

    private Preferences getPrivatePreferences() {
        return ProjectUtils.getPreferences((Project)this.prj, Settings.class, (boolean)false);
    }

    public RunBuild getRunBuildSetting() {
        try {
            return RunBuild.valueOf(this.getPrivatePreferences().get(KEY_BUILD_BEFORE_TESTS, RunBuild.ALWAYS.name()));
        }
        catch (IllegalArgumentException ex) {
            return RunBuild.ALWAYS;
        }
    }

    public void setRunBuildSetting(RunBuild value) {
        this.getPrivatePreferences().put(KEY_BUILD_BEFORE_TESTS, value.name());
    }

    public String getJTregLocation() {
        return this.getPrivatePreferences().get(KEY_JTREG_LOCATION, null);
    }

    public void setJTregLocation(String jtregLocation) {
        this.getPrivatePreferences().put(KEY_JTREG_LOCATION, jtregLocation);
    }

    public boolean isUseAntBuild() {
        return this.getPrivatePreferences().getBoolean(KEY_USE_ANT_BUILD, true);
    }

    public void setUseAntBuild(boolean useAntBuild) {
        this.getPrivatePreferences().putBoolean(KEY_USE_ANT_BUILD, useAntBuild);
    }

    public String getAntBuildLocation() {
        return this.getPrivatePreferences().get(KEY_ANT_BUILD_LOCATION, DEF_ANT_BUILD_LOCATION);
    }

    public void setAntBuildLocation(String antBuildLocation) {
        this.getPrivatePreferences().put(KEY_ANT_BUILD_LOCATION, antBuildLocation);
    }

    public void flush() {
        try {
            this.getPrivatePreferences().flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static enum RunBuild {
        ALWAYS,
        NEVER;

    }
}

