/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.base.semantic;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.editor.base.semantic.TreeShims;
import org.netbeans.modules.java.editor.base.semantic.Utilities;

public class UnusedDetector {
    private static Field signatureAccessField;
    private static final Set<String> SERIALIZABLE_SIGNATURES;
    private static final Set<ElementKind> LOCAL_VARIABLES;
    private static final ElementKind BINDING_VARIABLE;

    public static List<UnusedDescription> findUnused(CompilationInfo info) {
        List cached = (List)info.getCachedValue(UnusedDetector.class);
        if (cached != null) {
            return cached;
        }
        UnusedVisitor uv = new UnusedVisitor(info);
        uv.scan((Tree)info.getCompilationUnit(), null);
        ArrayList<UnusedDescription> result = new ArrayList<UnusedDescription>();
        for (Map.Entry e : uv.element2Declaration.entrySet()) {
            Element el = (Element)e.getKey();
            TreePath declaration = (TreePath)e.getValue();
            Set uses = uv.useTypes.getOrDefault(el, Collections.emptySet());
            boolean isPrivate = el.getModifiers().contains((Object)Modifier.PRIVATE);
            if (UnusedDetector.isLocalVariableClosure(el) || el.getKind().isField() && isPrivate) {
                if (UnusedDetector.isSerialSpecField(info, el)) continue;
                boolean isWritten = uses.contains((Object)UseTypes.WRITTEN);
                boolean isRead = uses.contains((Object)UseTypes.READ);
                if (!isWritten && !isRead) {
                    result.add(new UnusedDescription(el, declaration, UnusedReason.NOT_WRITTEN_READ));
                    continue;
                }
                if (!isWritten) {
                    result.add(new UnusedDescription(el, declaration, UnusedReason.NOT_WRITTEN));
                    continue;
                }
                if (isRead) continue;
                result.add(new UnusedDescription(el, declaration, UnusedReason.NOT_READ));
                continue;
            }
            if ((el.getKind() == ElementKind.CONSTRUCTOR || el.getKind() == ElementKind.METHOD) && isPrivate) {
                if (UnusedDetector.isSerializationMethod(info, (ExecutableElement)el) || uses.contains((Object)UseTypes.USED)) continue;
                result.add(new UnusedDescription(el, declaration, UnusedReason.NOT_USED));
                continue;
            }
            if (!el.getKind().isClass() && !el.getKind().isInterface() || !isPrivate || uses.contains((Object)UseTypes.USED)) continue;
            result.add(new UnusedDescription(el, declaration, UnusedReason.NOT_USED));
        }
        info.putCachedValue(UnusedDetector.class, result, CompilationInfo.CacheClearPolicy.ON_CHANGE);
        return result;
    }

    private static boolean isSerialSpecField(CompilationInfo info, Element el) {
        if (el.getModifiers().contains((Object)Modifier.FINAL) && el.getModifiers().contains((Object)Modifier.STATIC)) {
            if (!UnusedDetector.isInSerializableOrExternalizable(info, el)) {
                return false;
            }
            if (info.getTypes().getPrimitiveType(TypeKind.LONG).equals(el.asType()) && el.getSimpleName().toString().equals("serialVersionUID")) {
                return true;
            }
            if (el.getSimpleName().contentEquals("serialPersistentFields")) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInSerializableOrExternalizable(CompilationInfo info, Element e) {
        Element encl = e.getEnclosingElement();
        if (encl == null || !encl.getKind().isClass()) {
            return true;
        }
        TypeMirror m = encl.asType();
        if (m == null || m.getKind() != TypeKind.DECLARED) {
            return true;
        }
        TypeElement serEl = info.getElements().getTypeElement("java.io.Serializable");
        TypeElement extEl = info.getElements().getTypeElement("java.io.Externalizable");
        if (serEl == null || extEl == null) {
            return true;
        }
        if (info.getTypes().isSubtype(m, serEl.asType())) {
            return true;
        }
        return info.getTypes().isSubtype(m, extEl.asType());
    }

    private static String _getSignatureHack(ElementHandle<ExecutableElement> eh) {
        try {
            String[] signs;
            if (signatureAccessField == null) {
                try {
                    Field f = ElementHandle.class.getDeclaredField("signatures");
                    f.setAccessible(true);
                    signatureAccessField = f;
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    return "";
                }
            }
            if ((signs = (String[])signatureAccessField.get(eh)) == null || signs.length != 3) {
                return "";
            }
            return signs[1] + signs[2];
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return "";
        }
    }

    private static boolean isSerializationMethod(CompilationInfo info, ExecutableElement method) {
        if (!UnusedDetector.isInSerializableOrExternalizable(info, method)) {
            return false;
        }
        ElementHandle eh = ElementHandle.create((Element)method);
        String sign = UnusedDetector._getSignatureHack((ElementHandle<ExecutableElement>)eh);
        return SERIALIZABLE_SIGNATURES.contains(sign);
    }

    private static boolean isLocalVariableClosure(Element el) {
        return el.getKind() == ElementKind.PARAMETER || LOCAL_VARIABLES.contains((Object)el.getKind());
    }

    static {
        ElementKind bindingVariable;
        SERIALIZABLE_SIGNATURES = new HashSet<String>(Arrays.asList("writeObject(Ljava/io/ObjectOutputStream;)V", "readObject(Ljava/io/ObjectInputStream;)V", "readResolve()Ljava/lang/Object;", "writeReplace()Ljava/lang/Object;", "readObjectNoData()V"));
        LOCAL_VARIABLES = EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER);
        try {
            bindingVariable = ElementKind.valueOf("BINDING_VARIABLE");
            LOCAL_VARIABLES.add(bindingVariable);
        }
        catch (IllegalArgumentException ex) {
            bindingVariable = null;
        }
        BINDING_VARIABLE = bindingVariable;
    }

    private static final class UnusedVisitor
    extends ErrorAwareTreePathScanner<Void, Void> {
        private final Map<Element, Set<UseTypes>> useTypes = new HashMap<Element, Set<UseTypes>>();
        private final Map<Element, TreePath> element2Declaration = new HashMap<Element, TreePath>();
        private final CompilationInfo info;
        private ExecutableElement recursionDetector;

        public UnusedVisitor(CompilationInfo info) {
            this.info = info;
        }

        public Void visitIdentifier(IdentifierTree node, Void p) {
            this.handleUse();
            return (Void)super.visitIdentifier(node, (Object)p);
        }

        public Void visitMemberSelect(MemberSelectTree node, Void p) {
            this.handleUse();
            return (Void)super.visitMemberSelect(node, (Object)p);
        }

        public Void visitMemberReference(MemberReferenceTree node, Void p) {
            this.handleUse();
            return (Void)super.visitMemberReference(node, (Object)p);
        }

        public Void visitNewClass(NewClassTree node, Void p) {
            this.handleUse();
            return (Void)super.visitNewClass(node, (Object)p);
        }

        private void handleUse() {
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el == null) {
                return;
            }
            boolean isPrivate = el.getModifiers().contains((Object)Modifier.PRIVATE);
            if (UnusedDetector.isLocalVariableClosure(el) || el.getKind().isField() && isPrivate) {
                TreePath effectiveUse = this.getCurrentPath();
                boolean isWrite = false;
                boolean isRead = false;
                block5: while (true) {
                    TreePath parent = effectiveUse.getParentPath();
                    switch (parent.getLeaf().getKind()) {
                        case ASSIGNMENT: {
                            AssignmentTree at = (AssignmentTree)parent.getLeaf();
                            if (at.getVariable() == effectiveUse.getLeaf()) {
                                isWrite = true;
                                break block5;
                            }
                            if (at.getExpression() == effectiveUse.getLeaf()) {
                                isRead = true;
                            }
                            break block5;
                        }
                        case AND_ASSIGNMENT: 
                        case DIVIDE_ASSIGNMENT: 
                        case LEFT_SHIFT_ASSIGNMENT: 
                        case MINUS_ASSIGNMENT: 
                        case MULTIPLY_ASSIGNMENT: 
                        case OR_ASSIGNMENT: 
                        case PLUS_ASSIGNMENT: 
                        case REMAINDER_ASSIGNMENT: 
                        case RIGHT_SHIFT_ASSIGNMENT: 
                        case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                        case XOR_ASSIGNMENT: {
                            CompoundAssignmentTree cat = (CompoundAssignmentTree)parent.getLeaf();
                            if (cat.getVariable() == effectiveUse.getLeaf()) {
                                effectiveUse = parent;
                                continue block5;
                            }
                            isRead = true;
                            break block5;
                        }
                        case EXPRESSION_STATEMENT: {
                            break block5;
                        }
                        default: {
                            isRead = true;
                            break block5;
                        }
                    }
                    break;
                }
                if (isWrite) {
                    this.addUse(el, UseTypes.WRITTEN);
                }
                if (isRead) {
                    this.addUse(el, UseTypes.READ);
                }
            } else if (isPrivate && (el.getKind() != ElementKind.METHOD || this.recursionDetector != el)) {
                this.addUse(el, UseTypes.USED);
            }
        }

        private void addUse(Element el, UseTypes type) {
            this.useTypes.computeIfAbsent(el, x -> EnumSet.noneOf(UseTypes.class)).add(type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void visitClass(ClassTree node, Void p) {
            ExecutableElement prevRecursionDetector = this.recursionDetector;
            try {
                this.recursionDetector = null;
                this.handleDeclaration(this.getCurrentPath());
                Void void_ = (Void)super.visitClass(node, (Object)p);
                return void_;
            }
            finally {
                this.recursionDetector = prevRecursionDetector;
            }
        }

        public Void visitVariable(VariableTree node, Void p) {
            this.handleDeclaration(this.getCurrentPath());
            return (Void)super.visitVariable(node, (Object)p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void visitMethod(MethodTree node, Void p) {
            ExecutableElement prevRecursionDetector = this.recursionDetector;
            try {
                Element el = this.info.getTrees().getElement(this.getCurrentPath());
                this.recursionDetector = el != null && el.getKind() == ElementKind.METHOD ? (ExecutableElement)el : null;
                this.handleDeclaration(this.getCurrentPath());
                Void void_ = (Void)super.visitMethod(node, (Object)p);
                return void_;
            }
            finally {
                this.recursionDetector = prevRecursionDetector;
            }
        }

        public Void scan(Tree tree, Void p) {
            if (tree != null && "BINDING_PATTERN".equals(tree.getKind().name())) {
                this.handleDeclaration(new TreePath(this.getCurrentPath(), tree));
            }
            return (Void)super.scan(tree, (Object)p);
        }

        private void handleDeclaration(TreePath path) {
            VariableTree vt;
            Element el = this.info.getTrees().getElement(path);
            if (el == null) {
                return;
            }
            this.element2Declaration.put(el, path);
            if (el.getKind() == ElementKind.PARAMETER) {
                this.addUse(el, UseTypes.WRITTEN);
                boolean read = true;
                Tree parent = path.getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.METHOD) {
                    MethodTree method = (MethodTree)parent;
                    Set<Modifier> mods = method.getModifiers().getFlags();
                    if (method.getParameters().contains(path.getLeaf()) && mods.contains((Object)Modifier.PRIVATE) && !mods.contains((Object)Modifier.ABSTRACT) && !mods.contains((Object)Modifier.NATIVE)) {
                        read = false;
                    }
                }
                if (read) {
                    this.addUse(el, UseTypes.READ);
                }
            } else if (el.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                this.addUse(el, UseTypes.READ);
                this.addUse(el, UseTypes.WRITTEN);
            } else if (el.getKind() == BINDING_VARIABLE) {
                this.addUse(el, UseTypes.WRITTEN);
            } else if (el.getKind() == ElementKind.LOCAL_VARIABLE) {
                Tree parent = path.getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.ENHANCED_FOR_LOOP && ((EnhancedForLoopTree)parent).getVariable() == path.getLeaf()) {
                    this.addUse(el, UseTypes.WRITTEN);
                }
            } else if (TreeShims.isRecordComponent(Utilities.toRecordComponent(el).getKind())) {
                this.addUse(el, UseTypes.READ);
                this.addUse(el, UseTypes.WRITTEN);
            } else if (el.getKind().isField()) {
                this.addUse(el, UseTypes.WRITTEN);
            } else if (el.getKind() == ElementKind.CONSTRUCTOR && el.getModifiers().contains((Object)Modifier.PRIVATE) && ((ExecutableElement)el).getParameters().isEmpty()) {
                TypeElement encl = (TypeElement)el.getEnclosingElement();
                TypeElement jlObject = this.info.getElements().getTypeElement("java.lang.Object");
                boolean utility = !encl.getModifiers().contains((Object)Modifier.ABSTRACT) && encl.getInterfaces().isEmpty() && (jlObject == null || this.info.getTypes().isSameType(encl.getSuperclass(), jlObject.asType()));
                for (Element element : el.getEnclosingElement().getEnclosedElements()) {
                    if (element.getKind() == ElementKind.CONSTRUCTOR && !element.equals(el)) {
                        utility = false;
                        break;
                    }
                    if (!element.getKind().isField() && element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    utility = false;
                    break;
                }
                if (utility) {
                    this.addUse(el, UseTypes.USED);
                }
            }
            if (path.getLeaf().getKind() == Tree.Kind.VARIABLE && (vt = (VariableTree)path.getLeaf()).getInitializer() != null) {
                this.addUse(el, UseTypes.WRITTEN);
            }
        }
    }

    private static enum UseTypes {
        READ,
        WRITTEN,
        USED;

    }

    public static enum UnusedReason {
        NOT_WRITTEN_READ("neither read or written to"),
        NOT_WRITTEN("never written to"),
        NOT_READ("never read"),
        NOT_USED("never used");

        private final String text;

        private UnusedReason(String text) {
            this.text = text;
        }
    }

    public static class UnusedDescription {
        public final Element unusedElement;
        public final TreePath unusedElementPath;
        public final UnusedReason reason;

        public UnusedDescription(Element unusedElement, TreePath unusedElementPath, UnusedReason reason) {
            this.unusedElement = unusedElement;
            this.unusedElementPath = unusedElementPath;
            this.reason = reason;
        }
    }
}

