/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.pagecontentmodel;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public class PageContentItem {
    private Image icon;
    private String fromAction;
    private String fromOutcome;
    private String name;
    private List<Action> actions;
    private Image bufferedIcon = null;
    private static final Image UNKONWN_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/navigation/graph/resources/question.png");
    private static final Logger LOG = Logger.getLogger(PageContentItem.class.toString());

    public Action[] getActions() {
        return new Action[0];
    }

    public PageContentItem(String name, String fromAction, String fromOutcome, Image icon) {
        this.name = name;
        this.fromAction = fromAction;
        this.fromOutcome = fromOutcome;
        this.icon = icon;
    }

    public PageContentItem(String name, String fromOutcome, Image icon) {
        this.name = name;
        this.fromOutcome = fromOutcome;
        this.icon = icon;
    }

    public Image getIcon() {
        return this.icon;
    }

    public String getFromAction() {
        return this.fromAction;
    }

    public void setFromAction(String fromAction) {
        this.fromAction = fromAction;
    }

    public String getFromOutcome() {
        return this.fromOutcome;
    }

    public void setFromOutcome(String fromOutcome) {
        this.fromOutcome = fromOutcome;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "PageBean[" + this.getName() + ", fromOutcome=" + this.getFromOutcome() + ", fromAction=" + this.getFromAction() + "," + this.getIcon() + "]";
    }

    public Image getBufferedIcon() {
        if (this.bufferedIcon == null) {
            this.bufferedIcon = this.toBufferedImage(this.getIcon());
        }
        return this.bufferedIcon;
    }

    private Image toBufferedImage(Image img) {
        if (img == null) {
            LOG.fine("Page Content Item does not have Image: " + this.toString());
            img = UNKONWN_ICON;
        }
        new ImageIcon(img);
        BufferedImage rep = this.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = rep.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return rep;
    }

    private BufferedImage createBufferedImage(int width, int height) {
        if (Utilities.getOperatingSystem() == 4096) {
            return new BufferedImage(width, height, 3);
        }
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(3);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        return null;
    }
}

