/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.nodes;

import java.awt.Image;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.Action;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.javaee.wildfly.nodes.actions.RefreshModulesAction;
import org.netbeans.modules.javaee.wildfly.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.javaee.wildfly.nodes.actions.Refreshable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class WildflyItemNode
extends AbstractNode {
    private ModuleType moduleType;

    public WildflyItemNode(Children children, String name) {
        super(children);
        this.setDisplayName(name);
        if (this.getChildren() instanceof Refreshable) {
            this.getCookieSet().add((Node.Cookie)new RefreshModulesCookieImpl((Refreshable)this.getChildren()));
        }
    }

    public WildflyItemNode(Children children, String name, ModuleType moduleType) {
        this(children, name);
        this.moduleType = moduleType;
    }

    public Image getIcon(int type) {
        if (ModuleType.WAR.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.WAR_FOLDER);
        }
        if (ModuleType.EAR.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.EAR_FOLDER);
        }
        if (ModuleType.EJB.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.EJB_FOLDER);
        }
        return this.getIconDelegate().getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        if (ModuleType.WAR.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.WAR_OPENED_FOLDER);
        }
        if (ModuleType.EAR.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.EAR_OPENED_FOLDER);
        }
        if (ModuleType.EJB.equals(this.moduleType)) {
            return UISupport.getIcon((UISupport.ServerIcon)UISupport.ServerIcon.EJB_OPENED_FOLDER);
        }
        return this.getIconDelegate().getOpenedIcon(type);
    }

    private Node getIconDelegate() {
        return DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
    }

    public Action[] getActions(boolean context) {
        if (this.getChildren() instanceof Refreshable) {
            return new SystemAction[]{SystemAction.get(RefreshModulesAction.class)};
        }
        return new SystemAction[0];
    }

    private static class RefreshModulesCookieImpl
    implements RefreshModulesCookie {
        Refreshable children;

        public RefreshModulesCookieImpl(Refreshable children) {
            this.children = children;
        }

        @Override
        public void refresh() {
            this.children.updateKeys();
        }
    }
}

