/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderKitConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String DEFAULT_RENDER_KIT_CLASS = "com.sun.faces.renderkit.RenderKitImpl";
    private static final String RENDERKIT = "render-kit";
    private static final String RENDERKIT_ID = "render-kit-id";
    private static final String RENDERKIT_CLASS = "render-kit-class";
    private static final String RENDERER = "renderer";
    private static final String RENDERER_FAMILY = "component-family";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String RENDERER_CLASS = "renderer-class";

    @Override
    public void process(Document[] documents) throws Exception {
        for (int i = 0; i < documents.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing render-kit elements for document: ''{0}''", documents[i].getDocumentURI()));
            }
            String namespace = documents[i].getDocumentElement().getNamespaceURI();
            NodeList renderkits = documents[i].getDocumentElement().getElementsByTagNameNS(namespace, RENDERKIT);
            if (renderkits == null || renderkits.getLength() <= 0) continue;
            this.addRenderKits(renderkits, namespace);
        }
        this.invokeNext(documents);
    }

    private void addRenderKits(NodeList renderKits, String namespace) throws XPathExpressionException {
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        int size = renderKits.getLength();
        for (int i = 0; i < size; ++i) {
            Node renderKit = renderKits.item(i);
            NodeList children = ((Element)renderKit).getElementsByTagNameNS(namespace, "*");
            String rkId = null;
            String rkClass = null;
            ArrayList<Node> renderers = new ArrayList<Node>(children.getLength());
            int csize = children.getLength();
            for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                if (RENDERKIT_ID.equals(n.getLocalName())) {
                    rkId = this.getNodeText(n);
                    continue;
                }
                if (RENDERKIT_CLASS.equals(n.getLocalName())) {
                    rkClass = this.getNodeText(n);
                    continue;
                }
                if (!RENDERER.equals(n.getLocalName())) continue;
                renderers.add(n);
            }
            rkId = rkId == null ? "HTML_BASIC" : rkId;
            rkClass = rkClass == null ? DEFAULT_RENDER_KIT_CLASS : rkClass;
            RenderKit rk = rkf.getRenderKit(null, rkId);
            if (rk == null) {
                rk = (RenderKit)this.createInstance(rkClass, RenderKit.class, null, renderKit);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKitFactory.addRenderKit({0}, {1})", rkId, rkClass));
                }
                rkf.addRenderKit(rkId, rk);
            }
            if (rk == null) continue;
            this.addRenderers(rk, renderers, namespace);
        }
    }

    private void addRenderers(RenderKit renderKit, List<Node> renderers, String namespace) throws XPathExpressionException {
        for (Node renderer : renderers) {
            Renderer r;
            NodeList children = ((Element)renderer).getElementsByTagNameNS(namespace, "*");
            String rendererFamily = null;
            String rendererType = null;
            String rendererClass = null;
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node n = children.item(i);
                if (RENDERER_FAMILY.equals(n.getLocalName())) {
                    rendererFamily = this.getNodeText(n);
                    continue;
                }
                if (RENDERER_TYPE.equals(n.getLocalName())) {
                    rendererType = this.getNodeText(n);
                    continue;
                }
                if (!RENDERER_CLASS.equals(n.getLocalName())) continue;
                rendererClass = this.getNodeText(n);
            }
            if (rendererFamily == null || rendererType == null || rendererClass == null || (r = (Renderer)this.createInstance(rendererClass, Renderer.class, null, renderer)) == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling RenderKit.addRenderer({0},{1}, {2}) for RenderKit ''{3}''", rendererFamily, rendererType, rendererClass, renderKit.getClass()));
            }
            renderKit.addRenderer(rendererFamily, rendererType, r);
        }
    }
}

