/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;

public class LazyTypeCompletionItem
extends SpringXMLConfigCompletionItem
implements LazyCompletionItem {
    private ElementHandle<TypeElement> eh;
    private JavaSource javaSource;
    private String name;
    private SpringXMLConfigCompletionItem delegate;
    private String simpleName;
    private String pkgName;
    private int prefWidth = -1;
    private String sortText;

    public static LazyTypeCompletionItem create(int substitutionOffset, ElementHandle<TypeElement> eh, JavaSource javaSource) {
        return new LazyTypeCompletionItem(substitutionOffset, eh, javaSource);
    }

    private LazyTypeCompletionItem(int substitutionOffset, ElementHandle<TypeElement> eh, JavaSource javaSource) {
        super(substitutionOffset);
        this.eh = eh;
        this.javaSource = javaSource;
        this.name = eh.getQualifiedName();
        int idx = this.name.lastIndexOf(46);
        this.simpleName = idx > -1 ? this.name.substring(idx + 1) : this.name;
        this.pkgName = idx > -1 ? this.name.substring(0, idx) : "";
        this.sortText = this.simpleName + SpringXMLConfigCompletionItem.getImportanceLevel(this.pkgName) + "#" + this.pkgName;
    }

    public boolean accept() {
        if (this.eh != null) {
            try {
                this.javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        if (LazyTypeCompletionItem.this.eh != null) {
                            TypeElement e = (TypeElement)LazyTypeCompletionItem.this.eh.resolve((CompilationInfo)cc);
                            if (e != null && LazyTypeCompletionItem.isAccessibleClass(e)) {
                                LazyTypeCompletionItem.this.delegate = SpringXMLConfigCompletionItem.createTypeItem(LazyTypeCompletionItem.this.substitutionOffset, e, (ElementHandle<TypeElement>)LazyTypeCompletionItem.this.eh, cc.getElements().isDeprecated(e), true);
                            }
                            LazyTypeCompletionItem.this.eh = null;
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return this.delegate != null;
    }

    private static boolean isAccessibleClass(TypeElement te) {
        NestingKind nestingKind = te.getNestingKind();
        return nestingKind == NestingKind.TOP_LEVEL || nestingKind == NestingKind.MEMBER && te.getModifiers().contains((Object)Modifier.STATIC);
    }

    public int getSortPriority() {
        return 200;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    public CharSequence getInsertPrefix() {
        return this.simpleName;
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.delegate != null) {
            return this.delegate.createDocumentationTask();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.delegate != null) {
            return this.delegate.createToolTipTask();
        }
        return null;
    }

    @Override
    public void defaultAction(JTextComponent component) {
        if (this.delegate != null) {
            this.delegate.defaultAction(component);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        if (this.delegate != null) {
            this.delegate.processKeyEvent(evt);
        }
    }

    @Override
    public int getPreferredWidth(Graphics g, Font defaultFont) {
        if (this.prefWidth < 0) {
            this.prefWidth = CompletionUtilities.getPreferredWidth((String)(this.simpleName + " (" + this.pkgName + ")"), null, (Graphics)g, (Font)defaultFont);
        }
        return this.prefWidth;
    }

    @Override
    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        if (this.delegate != null) {
            this.delegate.render(g, defaultFont, defaultColor, backgroundColor, width, height, selected);
        }
    }
}

