/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.tax.beans.Lib;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;

public class TreeAttributeCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = 7976099790445909386L;
    private volatile boolean askingDialog = false;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel valueLabel;
    private JTextField valueField;

    public TreeAttributeCustomizer() {
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlName"));
        this.valueLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlValue"));
    }

    protected final TreeAttribute getAttribute() {
        return (TreeAttribute)this.getTreeObject();
    }

    @Override
    protected final void safePropertyChange(PropertyChangeEvent pche) {
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("name")) {
            this.updateNameComponent();
        } else if (pche.getPropertyName().equals("value")) {
            this.updateValueComponent();
        }
    }

    protected final void updateAttributeName() {
        if (this.askingDialog) {
            return;
        }
        try {
            String attrName = this.nameField.getText();
            boolean toSet = true;
            TreeElement ownerElement = this.getAttribute().getOwnerElement();
            if (ownerElement != null) {
                TreeAttribute oldAttribute = ownerElement.getAttribute(attrName);
                if (this.getAttribute() != oldAttribute && oldAttribute != null) {
                    this.askingDialog = true;
                    toSet = Lib.confirmAction(Util.THIS.getString("MSG_replace_attribute", attrName));
                    this.askingDialog = false;
                }
            }
            if (toSet) {
                this.getAttribute().setQName(attrName);
            } else {
                this.updateNameComponent();
            }
        }
        catch (TreeException exc) {
            this.updateNameComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateNameComponent() {
        this.nameField.setText(this.getAttribute().getQName());
    }

    protected final void updateAttributeValue() {
        try {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\nTreeAttributeCustomizer::updateAttributeValue: valueField.getText() = " + this.valueField.getText());
            }
            this.getAttribute().setValue(this.valueField.getText());
        }
        catch (TreeException ex) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("                       ::updateAttributeValue: ex = " + ex + "\n");
            }
            this.updateValueComponent();
            TAXUtil.notifyTreeException(ex);
        }
    }

    protected final void updateValueComponent() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeAttributeCustomizer::updateValueComponent: getAttribute().getValue() = " + this.getAttribute().getValue());
        }
        this.valueField.setText(this.getAttribute().getValue());
    }

    @Override
    protected void initComponentValues() {
        this.updateNameComponent();
        this.updateValueComponent();
    }

    @Override
    protected final void updateReadOnlyStatus(boolean editable) {
        this.nameField.setEditable(editable);
        this.valueField.setEditable(editable);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.valueLabel = new JLabel();
        this.valueField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText(Util.THIS.getString("PROP_xmlName"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setColumns(20);
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeAttributeCustomizer.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TreeAttributeCustomizer.this.nameFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TreeAttributeCustomizer.this.nameFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.nameField, gridBagConstraints);
        this.valueLabel.setText(Util.THIS.getString("PROP_xmlValue"));
        this.valueLabel.setLabelFor(this.valueField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        this.valueField.setColumns(20);
        this.valueField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeAttributeCustomizer.this.valueFieldActionPerformed(evt);
            }
        });
        this.valueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TreeAttributeCustomizer.this.valueFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TreeAttributeCustomizer.this.valueFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.valueField, gridBagConstraints);
    }

    private void valueFieldFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.valueField.selectAll();
        }
    }

    private void nameFieldFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.nameField.selectAll();
        }
    }

    private void valueFieldFocusLost(FocusEvent evt) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttributeCustomizer::valueFieldFocusLost");
        }
        this.updateAttributeValue();
    }

    private void nameFieldFocusLost(FocusEvent evt) {
        this.updateAttributeName();
    }

    private void valueFieldActionPerformed(ActionEvent evt) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttributeCustomizer::valueFieldActionPerformed");
        }
        this.updateAttributeValue();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.updateAttributeName();
    }
}

