/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.serializer;

import java.io.IOException;
import org.apache.ws.commons.util.Base64;
import org.apache.xmlrpc.serializer.TypeSerializerImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ByteArraySerializer
extends TypeSerializerImpl {
    public static final String BASE_64_TAG = "base64";

    public void write(ContentHandler pHandler, Object pObject) throws SAXException {
        pHandler.startElement("", "value", "value", ZERO_ATTRIBUTES);
        pHandler.startElement("", BASE_64_TAG, BASE_64_TAG, ZERO_ATTRIBUTES);
        byte[] buffer = (byte[])pObject;
        if (buffer.length > 0) {
            char[] charBuffer = new char[buffer.length >= 1024 ? 1024 : (buffer.length + 3) / 4 * 4];
            Base64.SAXEncoder encoder = new Base64.SAXEncoder(charBuffer, 0, null, pHandler);
            try {
                encoder.write(buffer, 0, buffer.length);
                encoder.flush();
            }
            catch (Base64.SAXIOException e) {
                throw e.getSAXException();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        pHandler.endElement("", BASE_64_TAG, BASE_64_TAG);
        pHandler.endElement("", "value", "value");
    }
}

