/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.processtreekiller.UnixProcess;
import org.netbeans.processtreekiller.UnixSystem;

abstract class ProcfsUnixSystem<P extends UnixProcess<P>>
extends UnixSystem<P> {
    private static final Logger LOGGER = Logger.getLogger(ProcfsUnixSystem.class.getName());

    ProcfsUnixSystem() {
        File[] localProcesses = new File("/proc").listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (localProcesses == null) {
            LOGGER.info("No /proc");
            return;
        }
        for (File p : localProcesses) {
            int pid;
            try {
                pid = Integer.parseInt(p.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            try {
                this.processes.put(pid, this.createProcess(pid));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected abstract P createProcess(int var1) throws IOException;
}

