/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.web.portlet.handler.AbstractHandlerMapping;

public abstract class AbstractMapBasedHandlerMapping<K>
extends AbstractHandlerMapping {
    private boolean lazyInitHandlers = false;
    private final Map<K, Object> handlerMap = new HashMap<K, Object>();

    public void setLazyInitHandlers(boolean lazyInitHandlers) {
        this.lazyInitHandlers = lazyInitHandlers;
    }

    @Override
    protected Object getHandlerInternal(PortletRequest request) throws Exception {
        K lookupKey = this.getLookupKey(request);
        Object handler = this.handlerMap.get(lookupKey);
        if (handler != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Key [" + lookupKey + "] -> handler [" + handler + "]"));
        }
        if (handler instanceof Map) {
            Map predicateMap = (Map)handler;
            LinkedList<PortletRequestMappingPredicate> filtered = new LinkedList<PortletRequestMappingPredicate>();
            for (PortletRequestMappingPredicate predicate : predicateMap.keySet()) {
                if (!predicate.match(request)) continue;
                filtered.add(predicate);
            }
            if (filtered.isEmpty()) {
                return null;
            }
            Collections.sort(filtered);
            PortletRequestMappingPredicate predicate = (PortletRequestMappingPredicate)filtered.get(0);
            predicate.validate(request);
            return predicateMap.get(predicate);
        }
        return handler;
    }

    protected abstract K getLookupKey(PortletRequest var1) throws Exception;

    protected void registerHandlers(Map<K, ?> handlerMap) throws BeansException {
        Assert.notNull(handlerMap, (String)"Handler Map must not be null");
        for (Map.Entry<K, ?> entry : handlerMap.entrySet()) {
            this.registerHandler(entry.getKey(), entry.getValue());
        }
    }

    protected void registerHandler(K lookupKey, Object handler) throws BeansException, IllegalStateException {
        this.registerHandler(lookupKey, handler, null);
    }

    protected void registerHandler(K lookupKey, Object handler, PortletRequestMappingPredicate predicate) throws BeansException, IllegalStateException {
        Object mappedHandler;
        Assert.notNull(lookupKey, (String)"Lookup key must not be null");
        Assert.notNull((Object)handler, (String)"Handler object must not be null");
        Object resolvedHandler = handler;
        if (!this.lazyInitHandlers && handler instanceof String) {
            String handlerName = (String)handler;
            if (this.getApplicationContext().isSingleton(handlerName)) {
                resolvedHandler = this.getApplicationContext().getBean(handlerName);
            }
        }
        if ((mappedHandler = this.handlerMap.get(lookupKey)) != null && !(mappedHandler instanceof Map)) {
            if (mappedHandler != resolvedHandler) {
                throw new IllegalStateException("Cannot map handler [" + handler + "] to key [" + lookupKey + "]: There's already handler [" + mappedHandler + "] mapped.");
            }
        } else {
            if (predicate != null) {
                LinkedHashMap<PortletRequestMappingPredicate, Object> predicateMap = (LinkedHashMap<PortletRequestMappingPredicate, Object>)mappedHandler;
                if (predicateMap == null) {
                    predicateMap = new LinkedHashMap<PortletRequestMappingPredicate, Object>();
                    this.handlerMap.put(lookupKey, predicateMap);
                }
                predicateMap.put(predicate, resolvedHandler);
            } else {
                this.handlerMap.put(lookupKey, resolvedHandler);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Mapped key [" + lookupKey + "] onto handler [" + resolvedHandler + "]"));
            }
        }
    }

    protected static interface PortletRequestMappingPredicate
    extends Comparable<PortletRequestMappingPredicate> {
        public boolean match(PortletRequest var1);

        public void validate(PortletRequest var1) throws PortletException;
    }
}

