/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.spi.java.queries.AnnotationProcessingQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class AnnotationProcessingQueryImpl
implements AnnotationProcessingQueryImplementation {
    private static final SpecificationVersion JDK_5 = new SpecificationVersion("1.5");
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final String annotationProcessingEnabledProperty;
    private final String annotationProcessingEnabledInEditorProperty;
    private final String runAllAnnotationProcessorsProperty;
    private final String annotationProcessorsProperty;
    private final Set<String> properties;
    private final String sourceOutputProperty;
    private final String processorOptionsProperty;
    private Reference<AnnotationProcessingQuery.Result> cache;
    private static final Set<String> TRUE = new HashSet<String>(Arrays.asList("true", "on", "1"));

    public AnnotationProcessingQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, String annotationProcessingEnabledProperty, String annotationProcessingEnabledInEditorProperty, String runAllAnnotationProcessorsProperty, String annotationProcessorsProperty, String sourceOutputProperty, String processorOptionsProperty) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.annotationProcessingEnabledProperty = annotationProcessingEnabledProperty;
        this.annotationProcessingEnabledInEditorProperty = annotationProcessingEnabledInEditorProperty;
        this.runAllAnnotationProcessorsProperty = runAllAnnotationProcessorsProperty;
        this.annotationProcessorsProperty = annotationProcessorsProperty;
        this.properties = new HashSet<String>(Arrays.asList(annotationProcessingEnabledProperty, annotationProcessingEnabledInEditorProperty, runAllAnnotationProcessorsProperty, annotationProcessorsProperty, sourceOutputProperty, processorOptionsProperty));
        this.sourceOutputProperty = sourceOutputProperty;
        this.processorOptionsProperty = processorOptionsProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnnotationProcessingQuery.Result getAnnotationProcessingOptions(FileObject file) {
        AnnotationProcessingQuery.Result current;
        AnnotationProcessingQueryImpl annotationProcessingQueryImpl = this;
        synchronized (annotationProcessingQueryImpl) {
            AnnotationProcessingQuery.Result result = current = this.cache != null ? this.cache.get() : null;
            if (current != null) {
                return current;
            }
        }
        current = new ResultImpl(SourceLevelQuery.getSourceLevel2((FileObject)file));
        annotationProcessingQueryImpl = this;
        synchronized (annotationProcessingQueryImpl) {
            AnnotationProcessingQuery.Result updated;
            AnnotationProcessingQuery.Result result = updated = this.cache != null ? this.cache.get() : null;
            if (updated != null) {
                return updated;
            }
            this.cache = new WeakReference<AnnotationProcessingQuery.Result>(current);
            return current;
        }
    }

    private final class ResultImpl
    implements AnnotationProcessingQuery.Result,
    PropertyChangeListener,
    ChangeListener {
        private final SourceLevelQuery.Result slqResult;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public ResultImpl(SourceLevelQuery.Result slqResult) {
            Object object = this.slqResult = slqResult.supportsChanges() ? slqResult : null;
            if (this.slqResult != null) {
                this.slqResult.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.slqResult));
            }
            AnnotationProcessingQueryImpl.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)AnnotationProcessingQueryImpl.this.evaluator));
        }

        public Set<? extends AnnotationProcessingQuery.Trigger> annotationProcessingEnabled() {
            EnumSet<AnnotationProcessingQuery.Trigger> set = EnumSet.noneOf(AnnotationProcessingQuery.Trigger.class);
            if (this.checkSourceLevel()) {
                if (TRUE.contains(AnnotationProcessingQueryImpl.this.evaluator.getProperty(AnnotationProcessingQueryImpl.this.annotationProcessingEnabledProperty))) {
                    set.add(AnnotationProcessingQuery.Trigger.ON_SCAN);
                }
                if (TRUE.contains(AnnotationProcessingQueryImpl.this.evaluator.getProperty(AnnotationProcessingQueryImpl.this.annotationProcessingEnabledInEditorProperty))) {
                    set.add(AnnotationProcessingQuery.Trigger.IN_EDITOR);
                }
            }
            return set;
        }

        public Iterable<? extends String> annotationProcessorsToRun() {
            if (TRUE.contains(AnnotationProcessingQueryImpl.this.evaluator.getProperty(AnnotationProcessingQueryImpl.this.runAllAnnotationProcessorsProperty))) {
                return null;
            }
            String processors = AnnotationProcessingQueryImpl.this.evaluator.getProperty(AnnotationProcessingQueryImpl.this.annotationProcessorsProperty);
            if (processors == null) {
                processors = "";
            }
            return Arrays.asList(processors.split(","));
        }

        public URL sourceOutputDirectory() {
            String prop = AnnotationProcessingQueryImpl.this.evaluator.getProperty(AnnotationProcessingQueryImpl.this.sourceOutputProperty);
            if (prop != null) {
                File output = AnnotationProcessingQueryImpl.this.helper.resolveFile(prop);
                try {
                    return Utilities.toURI((File)output).toURL();
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(AnnotationProcessingQueryImpl.class.getName()).log(Level.FINE, null, ex);
                    return null;
                }
            }
            return null;
        }

        public Map<? extends String, ? extends String> processorOptions() {
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            String prop = AnnotationProcessingQueryImpl.this.evaluator.getProperty(AnnotationProcessingQueryImpl.this.processorOptionsProperty);
            if (prop != null) {
                for (String option : prop.split("\\s")) {
                    if (!option.startsWith("-A") || option.length() <= 2) continue;
                    int sepIndex = option.indexOf(61);
                    String key = null;
                    String value = null;
                    if (sepIndex == -1) {
                        key = option.substring(2);
                    } else if (sepIndex >= 3) {
                        key = option.substring(2, sepIndex);
                        value = sepIndex < option.length() - 1 ? option.substring(sepIndex + 1) : null;
                    }
                    options.put(key, value);
                }
            }
            return options;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || AnnotationProcessingQueryImpl.this.properties.contains(evt.getPropertyName())) {
                this.cs.fireChange();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.cs.fireChange();
        }

        private boolean checkSourceLevel() {
            if (this.slqResult == null) {
                return true;
            }
            String sl = this.slqResult.getSourceLevel();
            if (sl == null) {
                return true;
            }
            try {
                SpecificationVersion sourceLevel = new SpecificationVersion(sl);
                if (JDK_5.compareTo((Object)sourceLevel) < 0) {
                    return true;
                }
                return TRUE.contains(AnnotationProcessingQueryImpl.this.evaluator.getProperty(AnnotationProcessingQueryImpl.this.runAllAnnotationProcessorsProperty));
            }
            catch (NumberFormatException nfe) {
                return true;
            }
        }
    }
}

