/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class Utils {
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.web.project");
    public static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics.web.project";
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.web.project");
    private static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String SPECIFICATION_J2SE = "j2se";

    public static String createDefaultContext(String projectName) {
        return "/" + PropertyUtils.getUsablePropertyName((String)projectName);
    }

    public static void updateProperties(AntProjectHelper h, String path, EditableProperties ep) {
        EditableProperties properties = h.getProperties(path);
        properties.putAll((Map)ep);
        h.putProperties(path, properties);
    }

    public static boolean isParentOrEqual(File folder, File file) {
        if (folder != null || file != null) {
            folder = FileUtil.normalizeFile((File)folder);
            for (file = FileUtil.normalizeFile((File)file); file != null; file = file.getParentFile()) {
                if (!file.equals(folder)) continue;
                return true;
            }
        }
        return false;
    }

    public static JavaPlatform findJ2seJavaPlatform(String platformName) {
        return Utils.findJavaPlatform(platformName, SPECIFICATION_J2SE);
    }

    public static JavaPlatform findJavaPlatform(String platformName) {
        return Utils.findJavaPlatform(platformName, null);
    }

    public static String getDefaultDebugClassPath() {
        return "${build.classes.dir}:${javac.classpath}";
    }

    public static String correctDebugClassPath(String debugClassPath) {
        if (debugClassPath == null || debugClassPath.length() == 0) {
            return Utils.getDefaultDebugClassPath();
        }
        String buildEarWebDir = "${build.ear.web.dir}";
        String buildEarClassesDir = "${build.ear.classes.dir}";
        String buildEarPrefix = "${build.ear.";
        if (!debugClassPath.contains("${build.ear.")) {
            return debugClassPath;
        }
        StringBuilder buffer = new StringBuilder(debugClassPath.length());
        for (String token : PropertyUtils.tokenizePath((String)debugClassPath)) {
            if ("${build.ear.web.dir}".equals(token) || "${build.ear.classes.dir}".equals(token)) continue;
            if (buffer.length() > 0) {
                buffer.append(":");
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private static JavaPlatform findJavaPlatform(String platformName, String specFilter) {
        if (platformName != null) {
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                JavaPlatform platform = platforms[i];
                String antName = (String)platform.getProperties().get(PLATFORM_ANT_NAME);
                if (antName == null || !antName.equals(platformName) || specFilter != null && !specFilter.equalsIgnoreCase(platform.getSpecification().getName())) continue;
                return platform;
            }
        }
        return null;
    }

    static String getGeneratedJavaResource(String jspUri) {
        return Utils.getServletResourcePath(null, jspUri);
    }

    public static Color getErrorColor() {
        Color c = UIManager.getColor("nb.errorForeground");
        return c == null ? new Color(89, 79, 191) : c;
    }

    public static void logUI(ResourceBundle bundle, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        Parameters.notNull((CharSequence)"bundle", (Object)bundle);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(UI_LOGGER.getName());
        logRecord.setResourceBundle(bundle);
        if (params != null) {
            logRecord.setParameters(params);
        }
        UI_LOGGER.log(logRecord);
    }

    public static void logUsage(Class srcClass, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }

    @NonNull
    public static String getServletName(FileObject docBase, FileObject jsp) {
        String jspRelativePath = FileUtil.getRelativePath((FileObject)docBase, (FileObject)jsp);
        return Utils.getServletResourcePath(null, jspRelativePath);
    }

    @NonNull
    public static String getServletResourcePath(String moduleContextPath, String jspResourcePath) {
        return Utils.getServletPackageName(jspResourcePath).replace('.', '/') + '/' + Utils.getServletClassName(jspResourcePath) + ".java";
    }

    @NonNull
    private static String getServletPackageName(String jspUri) {
        String packageName;
        String jspBasePackageName = "org/apache/jsp";
        int iSep = jspUri.lastIndexOf(47);
        String string = packageName = iSep > 0 ? jspUri.substring(0, iSep) : "";
        if (packageName.length() == 0) {
            return jspBasePackageName;
        }
        return jspBasePackageName + "/" + packageName.substring(1);
    }

    @NonNull
    private static String getServletClassName(String jspUri) {
        int iSep = jspUri.lastIndexOf(47) + 1;
        String className = jspUri.substring(iSep);
        StringBuilder modClassName = new StringBuilder("");
        for (int i = 0; i < className.length(); ++i) {
            char c = className.charAt(i);
            if (c == '.') {
                modClassName.append('_');
                continue;
            }
            modClassName.append(c);
        }
        return modClassName.toString();
    }

    public static URL getRootURL(File root, String offset) throws MalformedURLException {
        URL url = FileUtil.urlForArchiveOrDir((File)root);
        if (offset != null) {
            assert (offset.endsWith("/"));
            url = new URL(url.toExternalForm() + offset);
        }
        return url;
    }

    public static LibraryChooser.Filter getFilter(WebProject p) {
        LibraryChooser.Filter filter = null;
        WebModule wm = WebModule.getWebModule((FileObject)p.getProjectDirectory());
        if (wm != null && Profile.J2EE_13.equals(wm.getJ2eeProfile())) {
            filter = new LibraryChooser.Filter(){

                public boolean accept(Library library) {
                    if ("javascript".equals(library.getType())) {
                        return false;
                    }
                    try {
                        library.getContent("classpath");
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    return !library.getName().matches("jstl11|jaxrpc16|Spring|jaxws20|jaxb20|struts|jsf");
                }
            };
        }
        return filter;
    }

    public static boolean isLibraryDirectoryBased(ClassPathSupport.Item item) {
        assert (item.getType() == 1) : item;
        Library l = item.getLibrary();
        if (l == null) {
            return false;
        }
        List cp = l.getContent("classpath");
        return cp.size() > 0 && ((URL)cp.get(0)).toString().startsWith("file:");
    }
}

