/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.ParserContextBaseNode;
import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.ExportSpecifierNode;
import com.oracle.js.parser.ir.ImportNode;
import com.oracle.js.parser.ir.Module;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ParserContextModuleNode
extends ParserContextBaseNode {
    private final String name;
    private List<String> requestedModules = new ArrayList<String>();
    private List<Module.ImportEntry> importEntries = new ArrayList<Module.ImportEntry>();
    private List<Module.ExportEntry> localExportEntries = new ArrayList<Module.ExportEntry>();
    private List<Module.ExportEntry> indirectExportEntries = new ArrayList<Module.ExportEntry>();
    private List<Module.ExportEntry> starExportEntries = new ArrayList<Module.ExportEntry>();
    private Map<String, Module.ImportEntry> importedLocalNames = new HashMap<String, Module.ImportEntry>();
    private List<ImportNode> imports = new ArrayList<ImportNode>();
    private List<ExportNode> exports = new ArrayList<ExportNode>();

    ParserContextModuleNode(String name) {
        this.name = name;
    }

    public String getModuleName() {
        return this.name;
    }

    public void addImport(ImportNode importNode) {
        this.imports.add(importNode);
    }

    public void addExport(ExportNode exportNode) {
        this.exports.add(exportNode);
    }

    public void addModuleRequest(String moduleRequest) {
        this.requestedModules.add(moduleRequest);
    }

    public void addImportEntry(Module.ImportEntry importEntry) {
        this.importEntries.add(importEntry);
        this.importedLocalNames.put(importEntry.getLocalName(), importEntry);
    }

    public void addLocalExportEntry(Module.ExportEntry exportEntry) {
        this.localExportEntries.add(exportEntry);
    }

    public void addIndirectExportEntry(Module.ExportEntry exportEntry) {
        this.indirectExportEntries.add(exportEntry);
    }

    public void addStarExportEntry(Module.ExportEntry exportEntry) {
        this.starExportEntries.add(exportEntry);
    }

    public Module createModule() {
        for (ExportNode export : this.exports) {
            if (export.getExportClause() == null) continue;
            for (ExportSpecifierNode s : export.getExportClause().getExportSpecifiers()) {
                String localName = s.getIdentifier().getName();
                Module.ExportEntry ee = s.getExportIdentifier() != null ? Module.ExportEntry.exportSpecifier(s.getExportIdentifier().getName(), localName) : Module.ExportEntry.exportSpecifier(localName);
                if (export.getFrom() == null) {
                    Module.ImportEntry ie = this.importedLocalNames.get(localName);
                    if (ie == null) {
                        this.addLocalExportEntry(ee);
                        continue;
                    }
                    if (ie.getImportName().equals("*")) {
                        this.addLocalExportEntry(ee);
                        continue;
                    }
                    this.addIndirectExportEntry(Module.ExportEntry.exportIndirect(ee.getExportName(), ie.getModuleRequest(), ie.getImportName()));
                    continue;
                }
                this.addIndirectExportEntry(ee.withFrom(export.getFrom().getModuleSpecifier().getValue()));
            }
        }
        return new Module(this.requestedModules, this.importEntries, this.localExportEntries, this.indirectExportEntries, this.starExportEntries, this.imports, this.exports);
    }
}

