/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class CeilNode
extends MathOperation {
    public CeilNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected static int ceil(int a) {
        return a;
    }

    @Specialization(rewriteOn={SlowPathException.class})
    protected int ceilMightReturnInt(Object a) throws SlowPathException {
        int result;
        double d = this.toDouble(a);
        if (Double.isNaN(d) || JSRuntime.isNegativeZero(d) || d < -2.147483648E9 || d > 2.147483647E9) {
            throw JSNodeUtil.slowPathException();
        }
        int i = (int)d;
        int n = result = d > (double)i ? i + 1 : i;
        if (result == 0 && d < 0.0) {
            throw JSNodeUtil.slowPathException();
        }
        return result;
    }

    @Specialization
    protected double ceilReturnsDouble(Object a, @Cached(value="createBinaryProfile()") ConditionProfile isNaN, @Cached(value="createBinaryProfile()") ConditionProfile isNegativeZero, @Cached(value="createBinaryProfile()") ConditionProfile requiresNegativeZero, @Cached(value="createBinaryProfile()") ConditionProfile fitsSafeLong) {
        double d = this.toDouble(a);
        if (isNaN.profile(Double.isNaN(d))) {
            return Double.NaN;
        }
        if (isNegativeZero.profile(JSRuntime.isNegativeZero(d))) {
            return -0.0;
        }
        if (fitsSafeLong.profile(JSRuntime.isSafeInteger(d))) {
            long i = (long)d;
            long result = d > (double)i ? i + 1L : i;
            if (requiresNegativeZero.profile(result == 0L && d < 0.0)) {
                return -0.0;
            }
            return result;
        }
        return CeilNode.mathCeil(d);
    }

    @CompilerDirectives.TruffleBoundary
    private static double mathCeil(double d) {
        return Math.ceil(d);
    }
}

