/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CachedSetPropertyNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PropertyCacheNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.access.SuperPropertyReferenceNode;
import com.oracle.truffle.js.nodes.cast.JSToBigIntNode;
import com.oracle.truffle.js.nodes.cast.JSToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ArrayAllocationSite;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.SparseArray;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSSlowArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSSlowArray;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class WriteElementNode
extends JSTargetableNode {
    @Node.Child
    protected JavaScriptNode targetNode;
    @Node.Child
    protected JavaScriptNode indexNode;
    @Node.Child
    private ToArrayIndexNode toArrayIndexNode;
    @Node.Child
    protected JavaScriptNode valueNode;
    @Node.Child
    private WriteElementTypeCacheNode typeCacheNode;
    @Node.Child
    private RequireObjectCoercibleNode requireObjectCoercibleNode;
    final JSContext context;
    final boolean isStrict;
    final boolean writeOwn;
    @CompilerDirectives.CompilationFinal
    private byte indexState;
    private static final byte INDEX_INT = 1;
    private static final byte INDEX_OBJECT = 2;

    public static WriteElementNode create(JSContext context, boolean isStrict) {
        return WriteElementNode.create(null, null, null, context, isStrict, false);
    }

    public static WriteElementNode create(JSContext context, boolean isStrict, boolean writeOwn) {
        return WriteElementNode.create(null, null, null, context, isStrict, writeOwn);
    }

    public static WriteElementNode create(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSContext context, boolean isStrict) {
        return WriteElementNode.create(targetNode, indexNode, valueNode, context, isStrict, false);
    }

    private static WriteElementNode create(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSContext context, boolean isStrict, boolean writeOwn) {
        return new WriteElementNode(targetNode, indexNode, valueNode, context, isStrict, writeOwn);
    }

    protected WriteElementNode(JavaScriptNode targetNode, JavaScriptNode indexNode, JavaScriptNode valueNode, JSContext context, boolean isStrict, boolean writeOwn) {
        assert (!(indexNode instanceof JSToPropertyKeyNode.JSToPropertyKeyWrapperNode));
        this.targetNode = targetNode;
        this.indexNode = indexNode;
        this.valueNode = valueNode;
        this.context = context;
        this.isStrict = isStrict;
        this.writeOwn = writeOwn;
        this.requireObjectCoercibleNode = RequireObjectCoercibleNode.create();
    }

    protected final ToArrayIndexNode toArrayIndexNode() {
        if (this.toArrayIndexNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toArrayIndexNode = (ToArrayIndexNode)this.insert(ToArrayIndexNode.create());
        }
        return this.toArrayIndexNode;
    }

    protected final void requireObjectCoercible(Object target, int index) {
        try {
            this.requireObjectCoercibleNode.executeVoid(target);
        }
        catch (JSException e) {
            throw Errors.createTypeErrorCannotSetProperty(JSRuntime.safeToString(index), target, this);
        }
    }

    protected final void requireObjectCoercible(Object target, Object index) {
        try {
            this.requireObjectCoercibleNode.executeVoid(target);
        }
        catch (JSException e) {
            throw Errors.createTypeErrorCannotSetProperty(JSRuntime.safeToString(index), target, this);
        }
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.WriteElementTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (this.materializationNeeded() && materializedTags.contains(JSTags.WriteElementTag.class)) {
            JavaScriptNode clonedTarget = this.targetNode == null || this.targetNode.hasSourceSection() ? this.targetNode : JSTaggedExecutionNode.createForInput(this.targetNode, this);
            JavaScriptNode clonedIndex = this.indexNode == null || this.indexNode.hasSourceSection() ? this.indexNode : JSTaggedExecutionNode.createForInput(this.indexNode, this);
            JavaScriptNode clonedValue = this.valueNode == null || this.valueNode.hasSourceSection() ? this.valueNode : JSTaggedExecutionNode.createForInput(this.valueNode, this);
            WriteElementNode cloned = this.createMaterialized(clonedTarget, clonedIndex, clonedValue);
            WriteElementNode.transferSourceSectionAndTags(this, cloned);
            return cloned;
        }
        return this;
    }

    private boolean materializationNeeded() {
        return this.targetNode != null && !this.targetNode.hasSourceSection() || this.indexNode != null && !this.indexNode.hasSourceSection() || this.valueNode != null && !this.valueNode.hasSourceSection();
    }

    protected WriteElementNode createMaterialized(JavaScriptNode newTarget, JavaScriptNode newIndex, JavaScriptNode newValue) {
        return WriteElementNode.create(newTarget, newIndex, newValue, this.getContext(), this.isStrict(), this.writeOwn());
    }

    @Override
    public Object evaluateTarget(VirtualFrame frame) {
        return this.targetNode.execute(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTarget(frame, target, WriteElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTargetInt(frame, target, WriteElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTargetDouble(frame, target, WriteElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public Object executeWithTarget(VirtualFrame frame, Object target) {
        return this.executeWithTarget(frame, target, target);
    }

    public Object executeWithTarget(VirtualFrame frame, Object target, Object receiver) {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.indexNode.execute(frame);
            this.requireObjectCoercible(target, index);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndex(frame, target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndex(frame, target, this.toArrayIndexNode().execute(index), receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.indexNode.executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                this.indexState = (byte)2;
                this.requireObjectCoercible(target, e.getResult());
                return this.executeWithTargetAndIndex(frame, target, this.toArrayIndexNode().execute(e.getResult()), receiver);
            }
            this.requireObjectCoercible(target, index);
            return this.executeWithTargetAndIndex(frame, target, index, receiver);
        }
        assert (is == 2);
        Object index = this.indexNode.execute(frame);
        this.requireObjectCoercible(target, index);
        return this.executeWithTargetAndIndex(frame, target, this.toArrayIndexNode().execute(index), receiver);
    }

    public int executeWithTargetInt(VirtualFrame frame, Object target, Object receiver) throws UnexpectedResultException {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.indexNode.execute(frame);
            this.requireObjectCoercible(target, index);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndexInt(frame, target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndexInt(frame, target, this.toArrayIndexNode().execute(index), receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.indexNode.executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                this.indexState = (byte)2;
                this.requireObjectCoercible(target, e.getResult());
                return this.executeWithTargetAndIndexInt(frame, target, this.toArrayIndexNode().execute(e.getResult()), receiver);
            }
            this.requireObjectCoercible(target, index);
            return this.executeWithTargetAndIndexInt(frame, target, index, receiver);
        }
        assert (is == 2);
        Object index = this.indexNode.execute(frame);
        this.requireObjectCoercible(target, index);
        return this.executeWithTargetAndIndexInt(frame, target, this.toArrayIndexNode().execute(index), receiver);
    }

    public double executeWithTargetDouble(VirtualFrame frame, Object target, Object receiver) throws UnexpectedResultException {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.indexNode.execute(frame);
            this.requireObjectCoercible(target, index);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndexDouble(frame, target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndexDouble(frame, target, this.toArrayIndexNode().execute(index), receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.indexNode.executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                this.indexState = (byte)2;
                this.requireObjectCoercible(target, e.getResult());
                return this.executeWithTargetAndIndexDouble(frame, target, this.toArrayIndexNode().execute(e.getResult()), receiver);
            }
            this.requireObjectCoercible(target, index);
            return this.executeWithTargetAndIndexDouble(frame, target, index, receiver);
        }
        assert (is == 2);
        Object index = this.indexNode.execute(frame);
        this.requireObjectCoercible(target, index);
        return this.executeWithTargetAndIndexDouble(frame, target, this.toArrayIndexNode().execute(index), receiver);
    }

    protected Object executeWithTargetAndIndex(VirtualFrame frame, Object target, Object index, Object receiver) {
        Object value = this.valueNode.execute(frame);
        this.executeWithTargetAndIndexAndValue(target, index, value, receiver);
        return value;
    }

    protected Object executeWithTargetAndIndex(VirtualFrame frame, Object target, int index, Object receiver) {
        Object value = this.valueNode.execute(frame);
        this.executeWithTargetAndIndexAndValue(target, index, value, receiver);
        return value;
    }

    protected int executeWithTargetAndIndexInt(VirtualFrame frame, Object target, Object index, Object receiver) throws UnexpectedResultException {
        try {
            int value = this.valueNode.executeInt(frame);
            this.executeWithTargetAndIndexAndValue(target, index, (Object)value, receiver);
            return value;
        }
        catch (UnexpectedResultException e) {
            this.executeWithTargetAndIndexAndValue(target, index, e.getResult(), receiver);
            throw e;
        }
    }

    protected int executeWithTargetAndIndexInt(VirtualFrame frame, Object target, int index, Object receiver) throws UnexpectedResultException {
        try {
            int value = this.valueNode.executeInt(frame);
            this.executeWithTargetAndIndexAndValue(target, index, (Object)value, receiver);
            return value;
        }
        catch (UnexpectedResultException e) {
            this.executeWithTargetAndIndexAndValue(target, index, e.getResult(), receiver);
            throw e;
        }
    }

    protected double executeWithTargetAndIndexDouble(VirtualFrame frame, Object target, Object index, Object receiver) throws UnexpectedResultException {
        try {
            double value = this.valueNode.executeDouble(frame);
            this.executeWithTargetAndIndexAndValue(target, index, (Object)value, receiver);
            return value;
        }
        catch (UnexpectedResultException e) {
            this.executeWithTargetAndIndexAndValue(target, index, e.getResult(), receiver);
            throw e;
        }
    }

    protected double executeWithTargetAndIndexDouble(VirtualFrame frame, Object target, int index, Object receiver) throws UnexpectedResultException {
        try {
            double value = this.valueNode.executeDouble(frame);
            this.executeWithTargetAndIndexAndValue(target, index, (Object)value, receiver);
            return value;
        }
        catch (UnexpectedResultException e) {
            this.executeWithTargetAndIndexAndValue(target, index, e.getResult(), receiver);
            throw e;
        }
    }

    public final void executeWithTargetAndIndexAndValue(Object target, Object index, Object value) {
        this.executeWithTargetAndIndexAndValue(target, index, value, target);
    }

    public final void executeWithTargetAndIndexAndValue(Object target, int index, Object value) {
        this.executeWithTargetAndIndexAndValue(target, index, value, target);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public final void executeWithTargetAndIndexAndValue(Object target, Object index, Object value, Object receiver) {
        WriteElementTypeCacheNode c = this.typeCacheNode;
        while (c != null) {
            boolean guard = c.guard(target);
            if (guard) {
                c.executeWithTargetAndIndexUnguarded(target, index, value, receiver, this);
                return;
            }
            c = c.typeCacheNext;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        WriteElementTypeCacheNode specialization = this.specialize(target);
        specialization.executeWithTargetAndIndexUnguarded(target, index, value, receiver, this);
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public final void executeWithTargetAndIndexAndValue(Object target, int index, Object value, Object receiver) {
        WriteElementTypeCacheNode c = this.typeCacheNode;
        while (c != null) {
            boolean guard = c.guard(target);
            if (guard) {
                c.executeWithTargetAndIndexUnguarded(target, index, value, receiver, this);
                return;
            }
            c = c.typeCacheNext;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        WriteElementTypeCacheNode specialization = this.specialize(target);
        specialization.executeWithTargetAndIndexUnguarded(target, index, value, receiver, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteElementTypeCacheNode specialize(Object target) {
        CompilerAsserts.neverPartOfCompilation();
        Lock lock = this.getLock();
        lock.lock();
        try {
            WriteElementTypeCacheNode currentHead;
            WriteElementTypeCacheNode c = currentHead = this.typeCacheNode;
            while (c != null) {
                if (c.guard(target)) {
                    WriteElementTypeCacheNode writeElementTypeCacheNode = c;
                    return writeElementTypeCacheNode;
                }
                c = c.typeCacheNext;
            }
            WriteElementTypeCacheNode newCacheNode = WriteElementNode.makeTypeCacheNode(target, currentHead);
            this.insert(newCacheNode);
            this.typeCacheNode = newCacheNode;
            if (currentHead != null) {
                this.reportPolymorphicSpecialize();
            }
            if (!newCacheNode.guard(target)) {
                throw Errors.shouldNotReachHere();
            }
            WriteElementTypeCacheNode writeElementTypeCacheNode = newCacheNode;
            return writeElementTypeCacheNode;
        }
        finally {
            lock.unlock();
        }
    }

    private static WriteElementTypeCacheNode makeTypeCacheNode(Object target, WriteElementTypeCacheNode next) {
        if (JSObject.isJSObject(target)) {
            return new JSObjectWriteElementTypeCacheNode(next);
        }
        if (JSRuntime.isString(target)) {
            return new StringWriteElementTypeCacheNode(target.getClass(), next);
        }
        if (target instanceof Boolean) {
            return new BooleanWriteElementTypeCacheNode(next);
        }
        if (target instanceof Number) {
            return new NumberWriteElementTypeCacheNode(target.getClass(), next);
        }
        if (target instanceof Symbol) {
            return new SymbolWriteElementTypeCacheNode(next);
        }
        if (target instanceof BigInt) {
            return new BigIntWriteElementTypeCacheNode(next);
        }
        if (target instanceof TruffleObject) {
            assert (JSRuntime.isForeignObject(target));
            return new TruffleObjectWriteElementTypeCacheNode(target.getClass(), next);
        }
        assert (JSRuntime.isJavaPrimitive(target));
        return new JavaObjectWriteElementTypeCacheNode(target.getClass(), next);
    }

    static ArrayWriteElementCacheNode makeArrayCacheNode(DynamicObject target, ScriptArray array, ArrayWriteElementCacheNode next) {
        if (JSSlowArray.isJSSlowArray(target) || JSSlowArgumentsObject.isJSSlowArgumentsObject(target)) {
            return new ExactArrayWriteElementCacheNode(array, next);
        }
        if (array.isLengthNotWritable() || !array.isExtensible()) {
            return new ExactArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof LazyRegexResultArray) {
            return new LazyRegexResultArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof AbstractConstantArray) {
            return new ConstantArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof HolesIntArray) {
            return new HolesIntArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof HolesDoubleArray) {
            return new HolesDoubleArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof HolesJSObjectArray) {
            return new HolesJSObjectArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof HolesObjectArray) {
            return new HolesObjectArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof AbstractIntArray) {
            return new IntArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof AbstractDoubleArray) {
            return new DoubleArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof AbstractObjectArray) {
            return new ObjectArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof AbstractJSObjectArray) {
            return new JSObjectArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof AbstractWritableArray) {
            return new WritableArrayWriteElementCacheNode(array, next);
        }
        if (array instanceof TypedArray) {
            if (array instanceof TypedArray.AbstractUint32Array) {
                return new Uint32ArrayWriteElementCacheNode(array, next);
            }
            if (array instanceof TypedArray.AbstractUint8ClampedArray) {
                return new Uint8ClampedArrayWriteElementCacheNode(array, next);
            }
            if (array instanceof TypedArray.TypedIntArray) {
                return new TypedIntArrayWriteElementCacheNode(array, next);
            }
            if (array instanceof TypedArray.TypedFloatArray) {
                return new TypedFloatArrayWriteElementCacheNode(array, next);
            }
            if (array instanceof TypedArray.TypedBigIntArray) {
                return new TypedBigIntArrayWriteElementCacheNode(array, next);
            }
            throw Errors.shouldNotReachHere();
        }
        return new ExactArrayWriteElementCacheNode(array, next);
    }

    @Override
    public JavaScriptNode getTarget() {
        return this.targetNode;
    }

    public JavaScriptNode getElement() {
        return this.indexNode;
    }

    public JavaScriptNode getValue() {
        return this.valueNode;
    }

    public JSContext getContext() {
        return this.context;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public boolean writeOwn() {
        return this.writeOwn;
    }

    boolean isSuperProperty() {
        return this.targetNode instanceof SuperPropertyReferenceNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return WriteElementNode.create(WriteElementNode.cloneUninitialized(this.targetNode), WriteElementNode.cloneUninitialized(this.indexNode), WriteElementNode.cloneUninitialized(this.valueNode), this.getContext(), this.isStrict(), this.writeOwn());
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.valueNode.isResultAlwaysOfType(clazz);
    }

    public static WriteElementNode createCachedInterop(TruffleLanguage.LanguageReference<JavaScriptLanguage> languageRef) {
        return WriteElementNode.create(((JavaScriptLanguage)languageRef.get()).getJSContext(), true);
    }

    static class TruffleObjectWriteElementTypeCacheNode
    extends WriteElementTypeCacheNode {
        private final Class<? extends TruffleObject> targetClass;
        @Node.Child
        private InteropLibrary interop;
        @Node.Child
        private InteropLibrary keyInterop;
        @Node.Child
        private InteropLibrary setterInterop;
        @Node.Child
        private ExportValueNode exportKey;
        @Node.Child
        private ExportValueNode exportValue;

        TruffleObjectWriteElementTypeCacheNode(Class<? extends TruffleObject> targetClass, WriteElementTypeCacheNode next) {
            super(next);
            this.targetClass = targetClass;
            this.exportKey = ExportValueNode.create();
            this.exportValue = ExportValueNode.create();
            this.interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
            this.keyInterop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, Object index, Object value, Object receiver, WriteElementNode root) {
            TruffleObject truffleObject = this.targetClass.cast(target);
            if (this.interop.isNull((Object)truffleObject)) {
                throw Errors.createTypeErrorCannotSetProperty(index, truffleObject, this);
            }
            Object convertedKey = this.exportKey.execute(index);
            if (convertedKey instanceof Symbol) {
                return;
            }
            Object exportedValue = this.exportValue.execute(value);
            if (this.keyInterop.isString(convertedKey)) {
                try {
                    this.interop.writeMember((Object)truffleObject, this.keyInterop.asString(convertedKey), exportedValue);
                    return;
                }
                catch (UnknownIdentifierException e) {
                    if (!root.context.isOptionNashornCompatibilityMode() || !(convertedKey instanceof String)) return;
                    this.tryInvokeSetter(truffleObject, (String)convertedKey, exportedValue, root.context);
                    return;
                }
                catch (UnsupportedMessageException | UnsupportedTypeException e) {
                    throw Errors.createTypeErrorInteropException(truffleObject, (InteropException)e, "writeMember", this);
                }
            }
            if (!this.keyInterop.fitsInLong(convertedKey)) return;
            try {
                this.interop.writeArrayElement((Object)truffleObject, this.keyInterop.asLong(convertedKey), exportedValue);
                return;
            }
            catch (InvalidArrayIndexException e) {
                return;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e) {
                throw Errors.createTypeErrorInteropException(truffleObject, (InteropException)e, "writeArrayElement", this);
            }
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, int index, Object value, Object receiver, WriteElementNode root) {
            this.executeWithTargetAndIndexUnguarded(target, (Object)index, value, receiver, root);
        }

        @Override
        public boolean guard(Object target) {
            return this.targetClass.isInstance(target) && !JSObject.isJSObject(target);
        }

        private void tryInvokeSetter(TruffleObject thisObj, String key, Object value, JSContext context) {
            assert (context.isOptionNashornCompatibilityMode());
            TruffleLanguage.Env env = context.getRealm().getEnv();
            if (env.isHostObject((Object)thisObj)) {
                String setterKey = PropertyCacheNode.getAccessorKey("set", key);
                if (setterKey == null) {
                    return;
                }
                if (this.setterInterop == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setterInterop = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(3));
                }
                if (!this.setterInterop.isMemberInvocable((Object)thisObj, setterKey)) {
                    return;
                }
                try {
                    this.setterInterop.invokeMember((Object)thisObj, setterKey, new Object[]{value});
                }
                catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class BigIntWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        BigIntWriteElementTypeCacheNode(WriteElementTypeCacheNode next) {
            super(next);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, Object index, Object value, Object receiver, WriteElementNode root) {
            BigInt bigInt = (BigInt)target;
            JSObject.setWithReceiver(JSBigInt.create(root.context, bigInt), this.toPropertyKey(index), value, target, root.isStrict, this.classProfile);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, int index, Object value, Object receiver, WriteElementNode root) {
            BigInt bigInt = (BigInt)target;
            JSObject.setWithReceiver(JSBigInt.create(root.context, bigInt), index, value, target, root.isStrict, this.classProfile);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof BigInt;
        }
    }

    private static class SymbolWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        SymbolWriteElementTypeCacheNode(WriteElementTypeCacheNode next) {
            super(next);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, Object index, Object value, Object receiver, WriteElementNode root) {
            if (root.isStrict) {
                throw Errors.createTypeError("cannot set element on Symbol in strict mode", this);
            }
            Symbol symbol = (Symbol)target;
            JSObject.setWithReceiver(JSSymbol.create(root.context, symbol), this.toPropertyKey(index), value, receiver, root.isStrict, this.classProfile);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, int index, Object value, Object receiver, WriteElementNode root) {
            if (root.isStrict) {
                throw Errors.createTypeError("cannot set element on Symbol in strict mode", this);
            }
            Symbol symbol = (Symbol)target;
            JSObject.setWithReceiver(JSSymbol.create(root.context, symbol), index, value, receiver, root.isStrict, this.classProfile);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof Symbol;
        }
    }

    private static class BooleanWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        BooleanWriteElementTypeCacheNode(WriteElementTypeCacheNode next) {
            super(next);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, Object index, Object value, Object receiver, WriteElementNode root) {
            Boolean bool = (Boolean)target;
            JSObject.setWithReceiver(JSBoolean.create(root.context, bool), this.toPropertyKey(index), value, target, root.isStrict, this.classProfile);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, int index, Object value, Object receiver, WriteElementNode root) {
            Boolean bool = (Boolean)target;
            JSObject.setWithReceiver(JSBoolean.create(root.context, bool), index, value, target, root.isStrict, this.classProfile);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof Boolean;
        }
    }

    private static class NumberWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        private final Class<?> numberClass;

        NumberWriteElementTypeCacheNode(Class<?> numberClass, WriteElementTypeCacheNode next) {
            super(next);
            this.numberClass = numberClass;
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, Object index, Object value, Object receiver, WriteElementNode root) {
            Number number = (Number)target;
            JSObject.setWithReceiver(JSNumber.create(root.context, number), this.toPropertyKey(index), value, target, root.isStrict, this.classProfile);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, int index, Object value, Object receiver, WriteElementNode root) {
            Number number = (Number)target;
            JSObject.setWithReceiver(JSNumber.create(root.context, number), index, value, target, root.isStrict, this.classProfile);
        }

        @Override
        public boolean guard(Object target) {
            return this.numberClass.isInstance(target);
        }
    }

    private static class StringWriteElementTypeCacheNode
    extends ToPropertyKeyCachedWriteElementTypeCacheNode {
        private final Class<?> stringClass;
        private final BranchProfile intIndexBranch = BranchProfile.create();
        private final BranchProfile stringIndexBranch = BranchProfile.create();
        private final ConditionProfile isImmutable = ConditionProfile.createBinaryProfile();

        StringWriteElementTypeCacheNode(Class<?> stringClass, WriteElementTypeCacheNode next) {
            super(next);
            this.stringClass = stringClass;
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, Object index, Object value, Object receiver, WriteElementNode root) {
            CharSequence charSequence = (CharSequence)this.stringClass.cast(target);
            if (index instanceof Integer) {
                this.intIndexBranch.enter();
                int intIndex = (Integer)index;
                if (this.isImmutable.profile(intIndex >= 0 && intIndex < JSRuntime.length(charSequence))) {
                    if (root.isStrict) {
                        throw Errors.createTypeErrorNotWritableProperty(Boundaries.stringValueOf(index), charSequence, this);
                    }
                    return;
                }
            }
            this.stringIndexBranch.enter();
            JSObject.setWithReceiver(JSString.create(root.context, charSequence), this.toPropertyKey(index), value, target, root.isStrict, this.classProfile);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, int index, Object value, Object receiver, WriteElementNode root) {
            CharSequence charSequence = (CharSequence)this.stringClass.cast(target);
            if (this.isImmutable.profile(index >= 0 && index < JSRuntime.length(charSequence))) {
                if (root.isStrict) {
                    throw Errors.createTypeErrorNotWritableProperty(Boundaries.stringValueOf(index), charSequence, this);
                }
                return;
            }
            JSObject.setWithReceiver(JSString.create(root.context, charSequence), index, value, target, root.isStrict, this.classProfile);
        }

        @Override
        public boolean guard(Object target) {
            return this.stringClass.isInstance(target);
        }
    }

    private static abstract class ToPropertyKeyCachedWriteElementTypeCacheNode
    extends WriteElementTypeCacheNode {
        @Node.Child
        private JSToPropertyKeyNode indexToPropertyKeyNode;
        protected final JSClassProfile classProfile = JSClassProfile.create();

        ToPropertyKeyCachedWriteElementTypeCacheNode(WriteElementTypeCacheNode next) {
            super(next);
        }

        protected final Object toPropertyKey(Object index) {
            if (this.indexToPropertyKeyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexToPropertyKeyNode = (JSToPropertyKeyNode)this.insert(JSToPropertyKeyNode.create());
            }
            return this.indexToPropertyKeyNode.execute(index);
        }
    }

    private static class TypedFloatArrayWriteElementCacheNode
    extends ArrayClassGuardCachedArrayWriteElementCacheNode {
        private final ConditionProfile inBoundsProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private JSToDoubleNode toDoubleNode = JSToDoubleNode.create();

        TypedFloatArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            TypedArray.TypedFloatArray typedArray = (TypedArray.TypedFloatArray)this.cast(array);
            double dValue = this.toDouble(value);
            this.checkDetachedArrayBuffer(target, root);
            if (this.inBoundsProfile.profile(typedArray.hasElement(target, index, arrayCondition))) {
                typedArray.setDouble(target, (int)index, dValue, arrayCondition);
            }
            return true;
        }

        private double toDouble(Object value) {
            return this.toDoubleNode.executeDouble(value);
        }
    }

    private static class Uint32ArrayWriteElementCacheNode
    extends AbstractTypedIntArrayWriteElementCacheNode {
        private final ConditionProfile toIntProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private JSToNumberNode toNumberNode;

        Uint32ArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected int toInt(Object value) {
            if (this.toIntProfile.profile(value instanceof Integer)) {
                return (Integer)value;
            }
            return (int)JSRuntime.toUInt32(this.toNumber(value));
        }

        private Number toNumber(Object value) {
            if (this.toNumberNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toNumberNode = (JSToNumberNode)this.insert(JSToNumberNode.create());
            }
            return this.toNumberNode.executeNumber(value);
        }
    }

    private static class Uint8ClampedArrayWriteElementCacheNode
    extends AbstractTypedIntArrayWriteElementCacheNode {
        private final ConditionProfile toIntProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private JSToDoubleNode toDoubleNode;

        Uint8ClampedArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected int toInt(Object value) {
            if (this.toIntProfile.profile(value instanceof Integer)) {
                return (Integer)value;
            }
            double doubleValue = this.toDouble(value);
            return TypedArray.Uint8ClampedArray.toInt(doubleValue);
        }

        private double toDouble(Object value) {
            if (this.toDoubleNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toDoubleNode = (JSToDoubleNode)this.insert(JSToDoubleNode.create());
            }
            return this.toDoubleNode.executeDouble(value);
        }
    }

    private static class TypedBigIntArrayWriteElementCacheNode
    extends ArrayClassGuardCachedArrayWriteElementCacheNode {
        @Node.Child
        private JSToBigIntNode toBigIntNode;
        private final ConditionProfile inBoundsProfile = ConditionProfile.createBinaryProfile();

        TypedBigIntArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
            this.toBigIntNode = JSToBigIntNode.create();
        }

        @Override
        protected final boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            TypedArray.TypedBigIntArray typedArray = (TypedArray.TypedBigIntArray)this.cast(array);
            BigInt biValue = this.toBigIntNode.executeBigInteger(value);
            this.checkDetachedArrayBuffer(target, root);
            if (this.inBoundsProfile.profile(typedArray.hasElement(target, index, arrayCondition))) {
                typedArray.setBigInt(target, (int)index, biValue, arrayCondition);
            }
            return true;
        }
    }

    private static class TypedIntArrayWriteElementCacheNode
    extends AbstractTypedIntArrayWriteElementCacheNode {
        @Node.Child
        private JSToInt32Node toIntNode = JSToInt32Node.create();

        TypedIntArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected int toInt(Object value) {
            return this.toIntNode.executeInt(value);
        }
    }

    private static abstract class AbstractTypedIntArrayWriteElementCacheNode
    extends ArrayClassGuardCachedArrayWriteElementCacheNode {
        private final ConditionProfile inBoundsProfile = ConditionProfile.createBinaryProfile();

        AbstractTypedIntArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected final boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            TypedArray.TypedIntArray typedArray = (TypedArray.TypedIntArray)this.cast(array);
            int iValue = this.toInt(value);
            this.checkDetachedArrayBuffer(target, root);
            if (this.inBoundsProfile.profile(typedArray.hasElement(target, index, arrayCondition))) {
                typedArray.setInt(target, (int)index, iValue, arrayCondition);
            }
            return true;
        }

        protected abstract int toInt(Object var1);
    }

    private static class HolesObjectArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final ConditionProfile inBoundsFastCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsFastHoleCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedCondition = ConditionProfile.createBinaryProfile();
        private final ScriptArray.ProfileHolder profile = AbstractWritableArray.createSetSupportedProfile();

        HolesObjectArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
            assert (arrayType.getClass() == HolesObjectArray.class);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            HolesObjectArray objectArray = (HolesObjectArray)array;
            if (this.holesArrayNeedsSlowSet(target, objectArray, index, arrayCondition, root)) {
                return false;
            }
            if (this.inBoundsFastCondition.profile(objectArray.isInBoundsFast(target, index, arrayCondition))) {
                assert (!HolesObjectArray.isHoleValue(value));
                if (this.inBoundsFastHoleCondition.profile(objectArray.isHoleFast(target, (int)index, arrayCondition))) {
                    objectArray.setInBoundsFastHole(target, (int)index, value, arrayCondition);
                } else {
                    objectArray.setInBoundsFastNonHole(target, (int)index, value, arrayCondition);
                }
                return true;
            }
            if (this.inBoundsCondition.profile(objectArray.isInBounds(target, (int)index, arrayCondition))) {
                assert (!HolesObjectArray.isHoleValue(value));
                objectArray.setInBounds(target, (int)index, value, arrayCondition, this.profile);
                return true;
            }
            if (this.supportedCondition.profile(objectArray.isSupported(target, index, arrayCondition))) {
                assert (!HolesObjectArray.isHoleValue(value));
                objectArray.setSupported(target, (int)index, value, arrayCondition);
                return true;
            }
            assert (objectArray.isSparse(target, index, arrayCondition));
            return this.setArrayAndWrite(objectArray.toSparse(target, index, value), target, index, value, arrayCondition, root);
        }
    }

    private static class HolesJSObjectArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final ConditionProfile objectType = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsFastCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsFastHoleCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedContainsHolesCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedNotContainsHolesCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile hasExplicitHolesProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile containsHolesProfile = ConditionProfile.createBinaryProfile();
        private final ScriptArray.ProfileHolder profile = AbstractWritableArray.createSetSupportedProfile();

        HolesJSObjectArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
            assert (arrayType.getClass() == HolesJSObjectArray.class);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            HolesJSObjectArray holesArray = (HolesJSObjectArray)this.cast(array);
            if (this.objectType.profile(JSObject.isDynamicObject(value))) {
                return this.executeWithJSObjectValueInner(target, holesArray, index, (DynamicObject)value, arrayCondition, root);
            }
            return this.setArrayAndWrite(holesArray.toObject(target, index, value, arrayCondition), target, index, value, arrayCondition, root);
        }

        private boolean executeWithJSObjectValueInner(DynamicObject target, HolesJSObjectArray jsobjectArray, long index, DynamicObject value, boolean arrayCondition, WriteElementNode root) {
            DynamicArray toArrayType;
            if (this.holesArrayNeedsSlowSet(target, jsobjectArray, index, arrayCondition, root)) {
                return false;
            }
            boolean containsHoles = this.containsHolesProfile.profile(this.containsHoles(target, jsobjectArray, index, arrayCondition));
            if (containsHoles && this.inBoundsFastCondition.profile(jsobjectArray.isInBoundsFast(target, index, arrayCondition))) {
                assert (!HolesJSObjectArray.isHoleValue(value));
                if (this.inBoundsFastHoleCondition.profile(jsobjectArray.isHoleFast(target, (int)index, arrayCondition))) {
                    jsobjectArray.setInBoundsFastHole(target, (int)index, value, arrayCondition);
                } else {
                    jsobjectArray.setInBoundsFastNonHole(target, (int)index, value, arrayCondition);
                }
                return true;
            }
            if (containsHoles && this.inBoundsCondition.profile(jsobjectArray.isInBounds(target, (int)index, arrayCondition))) {
                assert (!HolesJSObjectArray.isHoleValue(value));
                jsobjectArray.setInBounds(target, (int)index, value, arrayCondition, this.profile);
                return true;
            }
            if (containsHoles && this.supportedContainsHolesCondition.profile(jsobjectArray.isSupported(target, index, arrayCondition))) {
                assert (!HolesJSObjectArray.isHoleValue(value));
                jsobjectArray.setSupported(target, (int)index, value, arrayCondition, this.profile);
                return true;
            }
            if (!containsHoles && this.supportedNotContainsHolesCondition.profile(jsobjectArray.isSupported(target, index, arrayCondition))) {
                toArrayType = jsobjectArray.toNonHoles(target, index, value, arrayCondition);
            } else {
                assert (jsobjectArray.isSparse(target, index, arrayCondition));
                toArrayType = jsobjectArray.toSparse(target, index, value);
            }
            return this.setArrayAndWrite(toArrayType, target, index, value, arrayCondition, root);
        }

        private boolean containsHoles(DynamicObject target, HolesJSObjectArray holesJSObjectArray, long index, boolean condition) {
            return this.hasExplicitHolesProfile.profile(JSArray.arrayGetHoleCount(target, condition) > 0) || !holesJSObjectArray.isInBoundsFast(target, index, condition);
        }
    }

    private static class HolesDoubleArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final BranchProfile doubleValueBranch = BranchProfile.create();
        private final BranchProfile intValueBranch = BranchProfile.create();
        private final BranchProfile toObjectBranch = BranchProfile.create();
        private final ConditionProfile inBoundsFastCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsFastHoleCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedContainsHolesCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedNotContainsHolesCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile hasExplicitHolesProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile containsHolesProfile = ConditionProfile.createBinaryProfile();
        private final ScriptArray.ProfileHolder profile = AbstractWritableArray.createSetSupportedProfile();

        HolesDoubleArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            double doubleValue;
            HolesDoubleArray holesDoubleArray = (HolesDoubleArray)this.cast(array);
            if (value instanceof Double) {
                this.doubleValueBranch.enter();
                doubleValue = (Double)value;
            } else if (value instanceof Integer) {
                this.intValueBranch.enter();
                doubleValue = ((Integer)value).intValue();
            } else {
                this.toObjectBranch.enter();
                return this.setArrayAndWrite(holesDoubleArray.toObject(target, index, value, arrayCondition), target, index, value, arrayCondition, root);
            }
            return this.executeWithDoubleValueInner(target, holesDoubleArray, index, doubleValue, arrayCondition, root);
        }

        private boolean executeWithDoubleValueInner(DynamicObject target, HolesDoubleArray holesDoubleArray, long index, double doubleValue, boolean arrayCondition, WriteElementNode root) {
            DynamicArray toArrayType;
            if (this.holesArrayNeedsSlowSet(target, holesDoubleArray, index, arrayCondition, root)) {
                return false;
            }
            int iIndex = (int)index;
            boolean containsHoles = this.containsHolesProfile.profile(this.containsHoles(target, holesDoubleArray, index, arrayCondition));
            if (containsHoles && this.inBoundsFastCondition.profile(holesDoubleArray.isInBoundsFast(target, index, arrayCondition) && !HolesDoubleArray.isHoleValue(doubleValue))) {
                if (this.inBoundsFastHoleCondition.profile(holesDoubleArray.isHoleFast(target, iIndex, arrayCondition))) {
                    holesDoubleArray.setInBoundsFastHole(target, iIndex, doubleValue, arrayCondition);
                } else {
                    holesDoubleArray.setInBoundsFastNonHole(target, iIndex, doubleValue, arrayCondition);
                }
                return true;
            }
            if (containsHoles && this.inBoundsCondition.profile(holesDoubleArray.isInBounds(target, iIndex, arrayCondition) && !HolesDoubleArray.isHoleValue(doubleValue))) {
                holesDoubleArray.setInBounds(target, iIndex, doubleValue, arrayCondition, this.profile);
                return true;
            }
            if (containsHoles && this.supportedContainsHolesCondition.profile(holesDoubleArray.isSupported(target, index, arrayCondition) && !HolesDoubleArray.isHoleValue(doubleValue))) {
                holesDoubleArray.setSupported(target, iIndex, doubleValue, arrayCondition, this.profile);
                return true;
            }
            if (!containsHoles && this.supportedNotContainsHolesCondition.profile(holesDoubleArray.isSupported(target, index, arrayCondition))) {
                toArrayType = holesDoubleArray.toNonHoles(target, index, doubleValue, arrayCondition);
            } else {
                assert (holesDoubleArray.isSparse(target, index, arrayCondition));
                toArrayType = holesDoubleArray.toSparse(target, index, doubleValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, doubleValue, arrayCondition, root);
        }

        private boolean containsHoles(DynamicObject target, HolesDoubleArray holesDoubleArray, long index, boolean condition) {
            return this.hasExplicitHolesProfile.profile(JSArray.arrayGetHoleCount(target, condition) > 0) || !holesDoubleArray.isInBoundsFast(target, index, condition);
        }
    }

    private static class HolesIntArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final BranchProfile intValueBranch = BranchProfile.create();
        private final BranchProfile toDoubleBranch = BranchProfile.create();
        private final BranchProfile toObjectBranch = BranchProfile.create();
        private final ConditionProfile inBoundsFastCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsFastHoleCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedContainsHolesCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedNotContainsHolesCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile hasExplicitHolesProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile containsHolesProfile = ConditionProfile.createBinaryProfile();
        private final ScriptArray.ProfileHolder profile = AbstractWritableArray.createSetSupportedProfile();

        HolesIntArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            HolesIntArray holesIntArray = (HolesIntArray)this.cast(array);
            if (value instanceof Integer) {
                this.intValueBranch.enter();
                int intValue = (Integer)value;
                return this.executeWithIntValueInner(target, holesIntArray, index, intValue, arrayCondition, root);
            }
            if (value instanceof Double) {
                this.toDoubleBranch.enter();
                double doubleValue = (Double)value;
                return this.setArrayAndWrite(holesIntArray.toDouble(target, index, doubleValue, arrayCondition), target, index, doubleValue, arrayCondition, root);
            }
            this.toObjectBranch.enter();
            return this.setArrayAndWrite(holesIntArray.toObject(target, index, value, arrayCondition), target, index, value, arrayCondition, root);
        }

        private boolean executeWithIntValueInner(DynamicObject target, HolesIntArray holesIntArray, long index, int intValue, boolean arrayCondition, WriteElementNode root) {
            DynamicArray toArrayType;
            if (this.holesArrayNeedsSlowSet(target, holesIntArray, index, arrayCondition, root)) {
                return false;
            }
            int iIndex = (int)index;
            boolean containsHoles = this.containsHolesProfile.profile(this.containsHoles(target, holesIntArray, index, arrayCondition));
            if (containsHoles && this.inBoundsFastCondition.profile(holesIntArray.isInBoundsFast(target, index, arrayCondition) && !HolesIntArray.isHoleValue(intValue))) {
                if (this.inBoundsFastHoleCondition.profile(holesIntArray.isHoleFast(target, iIndex, arrayCondition))) {
                    holesIntArray.setInBoundsFastHole(target, iIndex, intValue, arrayCondition);
                } else {
                    holesIntArray.setInBoundsFastNonHole(target, iIndex, intValue, arrayCondition);
                }
                return true;
            }
            if (containsHoles && this.inBoundsCondition.profile(holesIntArray.isInBounds(target, iIndex, arrayCondition) && !HolesIntArray.isHoleValue(intValue))) {
                holesIntArray.setInBounds(target, iIndex, intValue, arrayCondition, this.profile);
                return true;
            }
            if (containsHoles && this.supportedContainsHolesCondition.profile(holesIntArray.isSupported(target, index, arrayCondition) && !HolesIntArray.isHoleValue(intValue))) {
                holesIntArray.setSupported(target, iIndex, intValue, arrayCondition, this.profile);
                return true;
            }
            if (!containsHoles && this.supportedNotContainsHolesCondition.profile(holesIntArray.isSupported(target, index, arrayCondition))) {
                toArrayType = holesIntArray.toNonHoles(target, index, intValue, arrayCondition);
            } else {
                assert (holesIntArray.isSparse(target, index, arrayCondition));
                toArrayType = holesIntArray.toSparse(target, index, intValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, intValue, arrayCondition, root);
        }

        private boolean containsHoles(DynamicObject target, HolesIntArray holesIntArray, long index, boolean condition) {
            return this.hasExplicitHolesProfile.profile(JSArray.arrayGetHoleCount(target, condition) > 0) || !holesIntArray.isInBoundsFast(target, index, condition);
        }
    }

    private static class JSObjectArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final ConditionProfile objectType = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsFastCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedContiguousCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedHolesCondition = ConditionProfile.createBinaryProfile();
        private final ScriptArray.ProfileHolder profile = AbstractWritableArray.createSetSupportedProfile();

        JSObjectArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            AbstractJSObjectArray jsobjectArray = (AbstractJSObjectArray)this.cast(array);
            if (this.objectType.profile(JSObject.isDynamicObject(value))) {
                DynamicObject jsobjectValue = (DynamicObject)value;
                return this.executeWithJSObjectValueInner(target, jsobjectArray, index, jsobjectValue, arrayCondition, root);
            }
            return this.setArrayAndWrite(jsobjectArray.toObject(target, index, value, arrayCondition), target, index, value, arrayCondition, root);
        }

        private boolean executeWithJSObjectValueInner(DynamicObject target, AbstractJSObjectArray jsobjectArray, long index, DynamicObject jsobjectValue, boolean arrayCondition, WriteElementNode root) {
            DynamicArray toArrayType;
            assert (!(jsobjectArray instanceof HolesJSObjectArray));
            int iIndex = (int)index;
            if (this.nonHolesArrayNeedsSlowSet(target, jsobjectArray, index, arrayCondition, root)) {
                return false;
            }
            if (this.inBoundsFastCondition.profile(jsobjectArray.isInBoundsFast(target, index, arrayCondition))) {
                jsobjectArray.setInBoundsFast(target, iIndex, jsobjectValue, arrayCondition);
                return true;
            }
            if (this.inBoundsCondition.profile(jsobjectArray.isInBounds(target, iIndex, arrayCondition))) {
                jsobjectArray.setInBounds(target, iIndex, jsobjectValue, arrayCondition, this.profile);
                return true;
            }
            if (this.supportedCondition.profile(jsobjectArray.isSupported(target, index, arrayCondition))) {
                jsobjectArray.setSupported(target, iIndex, jsobjectValue, arrayCondition, this.profile);
                return true;
            }
            if (this.supportedContiguousCondition.profile(!(jsobjectArray instanceof AbstractContiguousJSObjectArray) && jsobjectArray.isSupportedContiguous(target, index, arrayCondition))) {
                toArrayType = jsobjectArray.toContiguous(target, index, jsobjectValue, arrayCondition);
            } else if (this.supportedHolesCondition.profile(jsobjectArray.isSupportedHoles(target, index, arrayCondition))) {
                toArrayType = jsobjectArray.toHoles(target, index, jsobjectValue, arrayCondition);
            } else {
                assert (jsobjectArray.isSparse(target, index, arrayCondition));
                toArrayType = jsobjectArray.toSparse(target, index, jsobjectValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, jsobjectValue, arrayCondition, root);
        }
    }

    private static class ObjectArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final ConditionProfile inBoundsFastCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedContiguousCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedHolesCondition = ConditionProfile.createBinaryProfile();
        private final ScriptArray.ProfileHolder profile = AbstractWritableArray.createSetSupportedProfile();

        ObjectArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            DynamicArray toArrayType;
            AbstractObjectArray objectArray = (AbstractObjectArray)this.cast(array);
            assert (!(objectArray instanceof HolesObjectArray));
            if (this.nonHolesArrayNeedsSlowSet(target, objectArray, index, arrayCondition, root)) {
                return false;
            }
            int iIndex = (int)index;
            if (this.inBoundsFastCondition.profile(objectArray.isInBoundsFast(target, index, arrayCondition))) {
                objectArray.setInBoundsFast(target, iIndex, value, arrayCondition);
                return true;
            }
            if (this.inBoundsCondition.profile(objectArray.isInBounds(target, iIndex, arrayCondition))) {
                objectArray.setInBounds(target, iIndex, value, arrayCondition, this.profile);
                return true;
            }
            if (this.supportedCondition.profile(objectArray.isSupported(target, index, arrayCondition))) {
                objectArray.setSupported(target, iIndex, value, arrayCondition);
                return true;
            }
            if (this.supportedContiguousCondition.profile(!(objectArray instanceof AbstractContiguousObjectArray) && objectArray.isSupportedContiguous(target, index, arrayCondition))) {
                toArrayType = objectArray.toContiguous(target, index, value, arrayCondition);
            } else if (this.supportedHolesCondition.profile(objectArray.isSupportedHoles(target, index, arrayCondition))) {
                toArrayType = objectArray.toHoles(target, index, value, arrayCondition);
            } else {
                assert (objectArray.isSparse(target, index, arrayCondition));
                toArrayType = objectArray.toSparse(target, index, value);
            }
            return this.setArrayAndWrite(toArrayType, target, index, value, arrayCondition, root);
        }
    }

    private static class DoubleArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final BranchProfile intValueBranch = BranchProfile.create();
        private final BranchProfile doubleValueBranch = BranchProfile.create();
        private final BranchProfile toObjectBranch = BranchProfile.create();
        private final ConditionProfile inBoundsFastCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedContiguousCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedHolesCondition = ConditionProfile.createBinaryProfile();
        private final ScriptArray.ProfileHolder profile = AbstractWritableArray.createSetSupportedProfile();

        DoubleArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            double doubleValue;
            AbstractDoubleArray doubleArray = (AbstractDoubleArray)this.cast(array);
            if (value instanceof Double) {
                this.doubleValueBranch.enter();
                doubleValue = (Double)value;
            } else if (value instanceof Integer) {
                this.intValueBranch.enter();
                doubleValue = ((Integer)value).intValue();
            } else {
                this.toObjectBranch.enter();
                return this.setArrayAndWrite(doubleArray.toObject(target, index, value, arrayCondition), target, index, value, arrayCondition, root);
            }
            return this.executeWithDoubleValueInner(target, doubleArray, index, doubleValue, arrayCondition, root);
        }

        private boolean executeWithDoubleValueInner(DynamicObject target, AbstractDoubleArray doubleArray, long index, double doubleValue, boolean arrayCondition, WriteElementNode root) {
            DynamicArray toArrayType;
            assert (!(doubleArray instanceof HolesDoubleArray));
            if (this.nonHolesArrayNeedsSlowSet(target, doubleArray, index, arrayCondition, root)) {
                return false;
            }
            int iIndex = (int)index;
            if (this.inBoundsFastCondition.profile(doubleArray.isInBoundsFast(target, index, arrayCondition))) {
                doubleArray.setInBoundsFast(target, iIndex, doubleValue, arrayCondition);
                return true;
            }
            if (this.inBoundsCondition.profile(doubleArray.isInBounds(target, iIndex, arrayCondition))) {
                doubleArray.setInBounds(target, iIndex, doubleValue, arrayCondition, this.profile);
                return true;
            }
            if (this.supportedCondition.profile(doubleArray.isSupported(target, index, arrayCondition))) {
                doubleArray.setSupported(target, iIndex, doubleValue, arrayCondition, this.profile);
                return true;
            }
            if (this.supportedContiguousCondition.profile(!(doubleArray instanceof AbstractContiguousDoubleArray) && doubleArray.isSupportedContiguous(target, index, arrayCondition))) {
                toArrayType = doubleArray.toContiguous(target, index, doubleValue, arrayCondition);
            } else if (this.supportedHolesCondition.profile(doubleArray.isSupportedHoles(target, index, arrayCondition))) {
                toArrayType = doubleArray.toHoles(target, index, doubleValue, arrayCondition);
            } else {
                assert (doubleArray.isSparse(target, index, arrayCondition));
                toArrayType = doubleArray.toSparse(target, index, doubleValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, doubleValue, arrayCondition, root);
        }
    }

    private static class IntArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final BranchProfile intValueBranch = BranchProfile.create();
        private final BranchProfile toDoubleBranch = BranchProfile.create();
        private final BranchProfile toObjectBranch = BranchProfile.create();
        private final ConditionProfile inBoundsFastCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile inBoundsCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedNonZeroCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedZeroCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedContiguousCondition = ConditionProfile.createBinaryProfile();
        private final ConditionProfile supportedHolesCondition = ConditionProfile.createBinaryProfile();
        private final ScriptArray.ProfileHolder profile = AbstractWritableArray.createSetSupportedProfile();

        IntArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            AbstractIntArray intArray = (AbstractIntArray)this.cast(array);
            if (value instanceof Integer) {
                this.intValueBranch.enter();
                return this.executeWithIntValueInner(target, intArray, index, (Integer)value, arrayCondition, root);
            }
            if (value instanceof Double) {
                this.toDoubleBranch.enter();
                double doubleValue = (Double)value;
                return this.setArrayAndWrite(intArray.toDouble(target, index, doubleValue, arrayCondition), target, index, doubleValue, arrayCondition, root);
            }
            this.toObjectBranch.enter();
            return this.setArrayAndWrite(intArray.toObject(target, index, value, arrayCondition), target, index, value, arrayCondition, root);
        }

        private boolean executeWithIntValueInner(DynamicObject target, AbstractIntArray intArray, long index, int intValue, boolean arrayCondition, WriteElementNode root) {
            ScriptArray toArrayType;
            assert (!(intArray instanceof HolesIntArray));
            if (this.nonHolesArrayNeedsSlowSet(target, intArray, index, arrayCondition, root)) {
                return false;
            }
            int iIndex = (int)index;
            if (this.inBoundsFastCondition.profile(intArray.isInBoundsFast(target, index, arrayCondition) && !IntArrayWriteElementCacheNode.mightTransferToNonContiguous(intArray, index))) {
                intArray.setInBoundsFast(target, iIndex, intValue, arrayCondition);
                return true;
            }
            if (this.inBoundsCondition.profile(intArray.isInBounds(target, iIndex, arrayCondition) && !IntArrayWriteElementCacheNode.mightTransferToNonContiguous(intArray, index))) {
                intArray.setInBounds(target, iIndex, intValue, arrayCondition, this.profile);
                return true;
            }
            if (this.supportedNonZeroCondition.profile(intArray.isSupported(target, index, arrayCondition) && !IntArrayWriteElementCacheNode.mightTransferToNonContiguous(intArray, index))) {
                intArray.setSupported(target, iIndex, intValue, arrayCondition, this.profile);
                return true;
            }
            if (this.supportedZeroCondition.profile(IntArrayWriteElementCacheNode.mightTransferToNonContiguous(intArray, index) && intArray.isSupported(target, index, arrayCondition))) {
                toArrayType = intArray.toNonContiguous(target, iIndex, intValue, arrayCondition, this.profile);
            } else if (this.supportedContiguousCondition.profile(!(intArray instanceof AbstractContiguousIntArray) && intArray.isSupportedContiguous(target, index, arrayCondition))) {
                toArrayType = intArray.toContiguous(target, index, intValue, arrayCondition);
            } else if (this.supportedHolesCondition.profile(intArray.isSupportedHoles(target, index, arrayCondition))) {
                toArrayType = intArray.toHoles(target, index, intValue, arrayCondition);
            } else {
                assert (intArray.isSparse(target, index, arrayCondition));
                toArrayType = intArray.toSparse(target, index, intValue);
            }
            return this.setArrayAndWrite(toArrayType, target, index, intValue, arrayCondition, root);
        }

        private static boolean mightTransferToNonContiguous(AbstractIntArray intArray, long index) {
            return intArray instanceof ContiguousIntArray && index == 0L;
        }
    }

    private static class WritableArrayWriteElementCacheNode
    extends ArrayClassGuardCachedArrayWriteElementCacheNode {
        private final ConditionProfile inBoundsProfile = ConditionProfile.createBinaryProfile();

        WritableArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            AbstractWritableArray writableArray = (AbstractWritableArray)this.cast(array);
            if (this.inBoundsProfile.profile(writableArray.isInBoundsFast(target, index, arrayCondition))) {
                JSAbstractArray.arraySetArrayType(target, writableArray.setElement(target, index, value, root.isStrict, arrayCondition));
                return true;
            }
            return false;
        }
    }

    private static class ConstantArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final ConditionProfile inBoundsProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile inBoundsIntBranch = BranchProfile.create();
        private final BranchProfile inBoundsDoubleBranch = BranchProfile.create();
        private final BranchProfile inBoundsJSObjectBranch = BranchProfile.create();
        private final BranchProfile inBoundsObjectBranch = BranchProfile.create();
        private final ScriptArray.ProfileHolder createWritableProfile = AbstractConstantArray.createCreateWritableProfile();

        ConstantArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            AbstractConstantArray constantArray = (AbstractConstantArray)this.cast(array);
            if (this.inBoundsProfile.profile(index >= 0L && index < Integer.MAX_VALUE)) {
                AbstractWritableArray newArray;
                if (value instanceof Integer) {
                    this.inBoundsIntBranch.enter();
                    newArray = constantArray.createWriteableInt(target, index, (Integer)value, arrayCondition, this.createWritableProfile);
                } else if (value instanceof Double) {
                    this.inBoundsDoubleBranch.enter();
                    newArray = constantArray.createWriteableDouble(target, index, (Double)value, arrayCondition, this.createWritableProfile);
                } else if (JSObject.isDynamicObject(value)) {
                    this.inBoundsJSObjectBranch.enter();
                    newArray = constantArray.createWriteableJSObject(target, index, (DynamicObject)value, arrayCondition, this.createWritableProfile);
                } else {
                    this.inBoundsObjectBranch.enter();
                    newArray = constantArray.createWriteableObject(target, index, value, arrayCondition, this.createWritableProfile);
                }
                return this.setArrayAndWrite(newArray, target, index, value, arrayCondition, root);
            }
            JSAbstractArray.arraySetArrayType(target, SparseArray.makeSparseArray(target, array).setElement(target, index, value, root.isStrict, arrayCondition));
            return true;
        }
    }

    private static class LazyRegexResultArrayWriteElementCacheNode
    extends RecursiveCachedArrayWriteElementCacheNode {
        private final ConditionProfile inBoundsProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private TRegexUtil.TRegexMaterializeResultNode materializeResultNode = TRegexUtil.TRegexMaterializeResultNode.create();

        LazyRegexResultArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            LazyRegexResultArray lazyRegexResultArray = (LazyRegexResultArray)this.cast(array);
            ScriptArray newArray = lazyRegexResultArray.createWritable(this.materializeResultNode, target, index, value, arrayCondition);
            if (this.inBoundsProfile.profile(index >= 0L && index < Integer.MAX_VALUE)) {
                return this.setArrayAndWrite(newArray, target, index, value, arrayCondition, root);
            }
            JSAbstractArray.arraySetArrayType(target, SparseArray.makeSparseArray(target, newArray).setElement(target, index, value, root.isStrict, arrayCondition));
            return true;
        }
    }

    private static class ExactArrayWriteElementCacheNode
    extends ArrayClassGuardCachedArrayWriteElementCacheNode {
        ExactArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        @Override
        protected boolean executeSetArray(DynamicObject target, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            return false;
        }
    }

    private static abstract class RecursiveCachedArrayWriteElementCacheNode
    extends ArrayClassGuardCachedArrayWriteElementCacheNode {
        @Node.Child
        private ArrayWriteElementCacheNode recursiveWrite;
        private final BranchProfile needPrototypeBranch = BranchProfile.create();

        RecursiveCachedArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayType, arrayCacheNext);
        }

        protected final boolean setArrayAndWrite(ScriptArray newArray, DynamicObject target, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            JSAbstractArray.arraySetArrayType(target, newArray);
            return this.executeRecursive(target, newArray, index, value, arrayCondition, root);
        }

        protected final boolean nonHolesArrayNeedsSlowSet(DynamicObject target, AbstractWritableArray arrayType, long index, boolean arrayCondition, WriteElementNode root) {
            assert (!arrayType.isHolesType());
            if (!root.context.getArrayPrototypeNoElementsAssumption().isValid() && !root.writeOwn && !arrayType.hasElement(target, index, arrayCondition) && JSObject.hasProperty(target, index)) {
                this.needPrototypeBranch.enter();
                return true;
            }
            return false;
        }

        protected final boolean holesArrayNeedsSlowSet(DynamicObject target, AbstractWritableArray arrayType, long index, boolean arrayCondition, WriteElementNode root) {
            assert (arrayType.isHolesType());
            if ((!root.context.getArrayPrototypeNoElementsAssumption().isValid() && !root.writeOwn || !root.context.getFastArrayAssumption().isValid() && JSSlowArray.isJSSlowArray(target) || !root.context.getFastArgumentsObjectAssumption().isValid() && JSSlowArgumentsObject.isJSSlowArgumentsObject(target)) && !arrayType.hasElement(target, index, arrayCondition) && JSObject.hasProperty(target, index)) {
                this.needPrototypeBranch.enter();
                return true;
            }
            return false;
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private boolean executeRecursive(DynamicObject targetObject, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            ArrayWriteElementCacheNode c = this.recursiveWrite;
            while (c != null) {
                boolean guard = c.guard(targetObject, array);
                if (guard) {
                    return c.executeSetArray(targetObject, array, index, value, arrayCondition, root);
                }
                c = c.arrayCacheNext;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ArrayWriteElementCacheNode specialization = this.specialize(targetObject, array);
            return specialization.executeSetArray(targetObject, array, index, value, arrayCondition, root);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayWriteElementCacheNode specialize(DynamicObject target, ScriptArray array) {
            CompilerAsserts.neverPartOfCompilation();
            Lock lock = this.getLock();
            lock.lock();
            try {
                ArrayWriteElementCacheNode currentHead;
                ArrayWriteElementCacheNode c = currentHead = this.recursiveWrite;
                while (c != null) {
                    if (c.guard(target, array)) {
                        ArrayWriteElementCacheNode arrayWriteElementCacheNode = c;
                        return arrayWriteElementCacheNode;
                    }
                    c = c.arrayCacheNext;
                }
                ArrayWriteElementCacheNode newCacheNode = WriteElementNode.makeArrayCacheNode(target, array, currentHead);
                this.insert(newCacheNode);
                this.recursiveWrite = newCacheNode;
                if (currentHead != null) {
                    this.reportPolymorphicSpecialize();
                }
                if (!newCacheNode.guard(target, array)) {
                    throw Errors.shouldNotReachHere();
                }
                ArrayWriteElementCacheNode arrayWriteElementCacheNode = newCacheNode;
                return arrayWriteElementCacheNode;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static abstract class ArrayClassGuardCachedArrayWriteElementCacheNode
    extends ArrayWriteElementCacheNode {
        private final ScriptArray arrayType;

        ArrayClassGuardCachedArrayWriteElementCacheNode(ScriptArray arrayType, ArrayWriteElementCacheNode arrayCacheNext) {
            super(arrayCacheNext);
            this.arrayType = arrayType;
        }

        @Override
        protected final boolean guard(Object target, ScriptArray array) {
            return this.arrayType.isInstance(array);
        }

        protected final ScriptArray cast(ScriptArray array) {
            return this.arrayType.cast(array);
        }

        protected final ScriptArray getArrayType() {
            return this.arrayType;
        }

        protected void checkDetachedArrayBuffer(DynamicObject target, WriteElementNode root) {
            if (JSArrayBufferView.hasDetachedBuffer(target, root.context)) {
                throw Errors.createTypeErrorDetachedBuffer();
            }
        }
    }

    static abstract class ArrayWriteElementCacheNode
    extends JavaScriptBaseNode {
        @Node.Child
        ArrayWriteElementCacheNode arrayCacheNext;

        ArrayWriteElementCacheNode(ArrayWriteElementCacheNode next) {
            this.arrayCacheNext = next;
        }

        protected abstract boolean executeSetArray(DynamicObject var1, ScriptArray var2, long var3, Object var5, boolean var6, WriteElementNode var7);

        protected abstract boolean guard(Object var1, ScriptArray var2);
    }

    private static class JavaObjectWriteElementTypeCacheNode
    extends WriteElementTypeCacheNode {
        protected final Class<?> targetClass;

        JavaObjectWriteElementTypeCacheNode(Class<?> targetClass, WriteElementTypeCacheNode next) {
            super(next);
            this.targetClass = targetClass;
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, Object index, Object value, Object receiver, WriteElementNode root) {
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, int index, Object value, Object receiver, WriteElementNode root) {
        }

        @Override
        public final boolean guard(Object target) {
            return this.targetClass.isInstance(target);
        }
    }

    private static class JSObjectWriteElementTypeCacheNode
    extends WriteElementTypeCacheNode {
        @Node.Child
        private IsArrayNode isArrayNode;
        @Node.Child
        private ToArrayIndexNode toArrayIndexNode;
        @Node.Child
        private ArrayWriteElementCacheNode arrayWriteElementNode;
        @Node.Child
        private IsJSObjectNode isObjectNode;
        private final ConditionProfile intOrStringIndexProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile arrayProfile = ConditionProfile.createBinaryProfile();
        private final JSClassProfile jsclassProfile = JSClassProfile.create();
        @Node.Child
        private CachedSetPropertyNode setPropertyCachedNode;

        JSObjectWriteElementTypeCacheNode(WriteElementTypeCacheNode next) {
            super(next);
            this.isArrayNode = IsArrayNode.createIsFastOrTypedArray();
            this.isObjectNode = IsJSObjectNode.createIncludeNullUndefined();
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, Object index, Object value, Object receiver, WriteElementNode root) {
            DynamicObject targetObject = JSObject.castJSObject(target);
            boolean arrayCondition = this.isArrayNode.execute(targetObject);
            if (this.arrayProfile.profile(arrayCondition)) {
                ScriptArray array = JSObject.getArray(targetObject, arrayCondition);
                Object objIndex = this.toArrayIndex(index);
                if (this.intOrStringIndexProfile.profile(objIndex instanceof Long)) {
                    long longIndex = (Long)objIndex;
                    if (!this.executeSetArray(targetObject, array, longIndex, value, arrayCondition, root)) {
                        this.setPropertyGenericEvaluatedIndex(targetObject, longIndex, value, receiver, root);
                    }
                } else {
                    this.setPropertyGenericEvaluatedStringOrSymbol(targetObject, objIndex, value, receiver, root);
                }
            } else {
                this.setPropertyGeneric(targetObject, index, value, receiver, root);
            }
        }

        private Object toArrayIndex(Object index) {
            if (this.toArrayIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toArrayIndexNode = (ToArrayIndexNode)this.insert(ToArrayIndexNode.create());
            }
            return this.toArrayIndexNode.execute(index);
        }

        @Override
        protected void executeWithTargetAndIndexUnguarded(Object target, int index, Object value, Object receiver, WriteElementNode root) {
            DynamicObject targetObject = JSObject.castJSObject(target);
            boolean arrayCondition = this.isArrayNode.execute(targetObject);
            if (this.arrayProfile.profile(arrayCondition)) {
                ScriptArray array = JSObject.getArray(targetObject, arrayCondition);
                if (this.intOrStringIndexProfile.profile(index >= 0)) {
                    if (!this.executeSetArray(targetObject, array, index, value, arrayCondition, root)) {
                        this.setPropertyGenericEvaluatedIndex(targetObject, index, value, receiver, root);
                    }
                } else {
                    this.setPropertyGenericEvaluatedStringOrSymbol(targetObject, Boundaries.stringValueOf(index), value, receiver, root);
                }
            } else {
                this.setPropertyGeneric(targetObject, index, value, receiver, root);
            }
        }

        private void setPropertyGenericEvaluatedIndex(DynamicObject targetObject, long index, Object value, Object receiver, WriteElementNode root) {
            JSObject.setWithReceiver(targetObject, index, value, receiver, root.isStrict, this.jsclassProfile);
        }

        private void setPropertyGenericEvaluatedStringOrSymbol(DynamicObject targetObject, Object key, Object value, Object receiver, WriteElementNode root) {
            JSObject.setWithReceiver(targetObject, key, value, receiver, root.isStrict, this.jsclassProfile);
        }

        private void setPropertyGeneric(DynamicObject targetObject, Object index, Object value, Object receiver, WriteElementNode root) {
            this.setCachedProperty(targetObject, index, value, receiver, root);
        }

        private void setCachedProperty(DynamicObject targetObject, Object index, Object value, Object receiver, WriteElementNode root) {
            if (this.setPropertyCachedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setPropertyCachedNode = (CachedSetPropertyNode)this.insert(CachedSetPropertyNode.create(root.context, root.isStrict, root.writeOwn, root.isSuperProperty()));
            }
            this.setPropertyCachedNode.execute(targetObject, index, value, receiver);
        }

        @Override
        public boolean guard(Object target) {
            return this.isObjectNode.executeBoolean(target);
        }

        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        private boolean executeSetArray(DynamicObject targetObject, ScriptArray array, long index, Object value, boolean arrayCondition, WriteElementNode root) {
            ArrayWriteElementCacheNode c = this.arrayWriteElementNode;
            while (c != null) {
                boolean guard = c.guard(targetObject, array);
                if (guard) {
                    return c.executeSetArray(targetObject, array, index, value, arrayCondition, root);
                }
                c = c.arrayCacheNext;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ArrayWriteElementCacheNode specialization = this.specialize(targetObject, array);
            return specialization.executeSetArray(targetObject, array, index, value, arrayCondition, root);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayWriteElementCacheNode specialize(DynamicObject target, ScriptArray array) {
            CompilerAsserts.neverPartOfCompilation();
            Lock lock = this.getLock();
            lock.lock();
            try {
                ArrayWriteElementCacheNode currentHead;
                ArrayWriteElementCacheNode c = currentHead = this.arrayWriteElementNode;
                while (c != null) {
                    if (c.guard(target, array)) {
                        ArrayWriteElementCacheNode arrayWriteElementCacheNode = c;
                        return arrayWriteElementCacheNode;
                    }
                    c = c.arrayCacheNext;
                }
                currentHead = JSObjectWriteElementTypeCacheNode.purgeStaleCacheEntries(currentHead, target);
                ArrayWriteElementCacheNode newCacheNode = WriteElementNode.makeArrayCacheNode(target, array, currentHead);
                this.insert(newCacheNode);
                this.arrayWriteElementNode = newCacheNode;
                if (currentHead != null) {
                    this.reportPolymorphicSpecialize();
                }
                if (!newCacheNode.guard(target, array)) {
                    throw Errors.shouldNotReachHere();
                }
                ArrayWriteElementCacheNode arrayWriteElementCacheNode = newCacheNode;
                return arrayWriteElementCacheNode;
            }
            finally {
                lock.unlock();
            }
        }

        private static ArrayWriteElementCacheNode purgeStaleCacheEntries(ArrayWriteElementCacheNode head, DynamicObject target) {
            ArrayAllocationSite allocationSite;
            if (JSTruffleOptions.TrackArrayAllocationSites && head != null && JSArray.isJSArray(target) && (allocationSite = JSAbstractArray.arrayGetAllocationSite(target)) != null && allocationSite.getInitialArrayType() != null) {
                ArrayWriteElementCacheNode c = head;
                ArrayWriteElementCacheNode prev = null;
                while (c != null) {
                    if (c instanceof ConstantArrayWriteElementCacheNode) {
                        ConstantArrayWriteElementCacheNode existingNode = (ConstantArrayWriteElementCacheNode)c;
                        ScriptArray initialArrayType = allocationSite.getInitialArrayType();
                        if (!(initialArrayType instanceof ConstantEmptyArray) && existingNode.getArrayType() instanceof ConstantEmptyArray) {
                            if (JSTruffleOptions.TraceArrayTransitions) {
                                System.out.println("purging " + (Object)((Object)existingNode) + ": " + existingNode.getArrayType() + " => " + JSAbstractArray.arrayGetArrayType(target));
                            }
                            if (prev == null) {
                                return existingNode.arrayCacheNext;
                            }
                            prev.arrayCacheNext = existingNode.arrayCacheNext;
                            return head;
                        }
                    }
                    prev = c;
                    c = c.arrayCacheNext;
                }
            }
            return head;
        }
    }

    static abstract class WriteElementTypeCacheNode
    extends JavaScriptBaseNode {
        @Node.Child
        WriteElementTypeCacheNode typeCacheNext;

        protected WriteElementTypeCacheNode(WriteElementTypeCacheNode next) {
            this.typeCacheNext = next;
        }

        protected abstract void executeWithTargetAndIndexUnguarded(Object var1, Object var2, Object var3, Object var4, WriteElementNode var5);

        protected abstract void executeWithTargetAndIndexUnguarded(Object var1, int var2, Object var3, Object var4, WriteElementNode var5);

        public abstract boolean guard(Object var1);
    }
}

