/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.cast.JSToLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToLengthNode.class)
public final class JSToLengthNodeGen
extends JSToLengthNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private DoubleData double_cache;
    @Node.Child
    private JSToNumberNode object_toNumberNode_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile object_needSafeBranch_;

    private JSToLengthNodeGen() {
    }

    @Override
    public long executeLong(Object arg0Value) {
        DynamicObject arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            return this.doInt(arg0Value_2);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0) >>> 4, arg0Value)) {
            double arg0Value_3 = JSTypesGen.asImplicitDouble((state & 0xF0) >>> 4, arg0Value);
            DoubleData s2_ = this.double_cache;
            if (s2_ != null) {
                return this.doDouble(arg0Value_3, s2_.needPositiveInfinityBranch_, s2_.needNaNBranch_, s2_.needSafeBranch_);
            }
        }
        if ((state & 4) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isUndefined(arg0Value_ = (DynamicObject)arg0Value)) {
            return this.doUndefined(arg0Value_);
        }
        if ((state & 8) != 0) {
            return this.doObject(arg0Value, this.object_toNumberNode_, this.object_needSafeBranch_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            DynamicObject arg0Value_;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                long l = this.doInt(arg0Value_2);
                return l;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_3 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                DoubleData s2_ = new DoubleData();
                s2_.needPositiveInfinityBranch_ = BranchProfile.create();
                s2_.needNaNBranch_ = BranchProfile.create();
                s2_.needSafeBranch_ = BranchProfile.create();
                this.double_cache = s2_;
                state |= doubleCast0 << 4;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                long l = this.doDouble(arg0Value_3, s2_.needPositiveInfinityBranch_, s2_.needNaNBranch_, s2_.needSafeBranch_);
                return l;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isUndefined(arg0Value_ = (DynamicObject)arg0Value)) {
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                long l = this.doUndefined(arg0Value_);
                return l;
            }
            this.object_toNumberNode_ = (JSToNumberNode)super.insert((Node)JSToNumberNode.create());
            this.object_needSafeBranch_ = BranchProfile.create();
            this.state_ = state |= 8;
            lock.unlock();
            hasLock = false;
            long l = this.doObject(arg0Value, this.object_toNumberNode_, this.object_needSafeBranch_);
            return l;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0xF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xF & (state & 0xF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            DoubleData s2_ = this.double_cache;
            if (s2_ != null) {
                cached.add(Arrays.asList(s2_.needPositiveInfinityBranch_, s2_.needNaNBranch_, s2_.needSafeBranch_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doObject";
        if ((state & 8) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Cloneable[]{this.object_toNumberNode_, this.object_needSafeBranch_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[4] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToLengthNode create() {
        return new JSToLengthNodeGen();
    }

    @GeneratedBy(value=JSToLengthNode.class)
    private static final class DoubleData {
        @CompilerDirectives.CompilationFinal
        BranchProfile needPositiveInfinityBranch_;
        @CompilerDirectives.CompilationFinal
        BranchProfile needNaNBranch_;
        @CompilerDirectives.CompilationFinal
        BranchProfile needSafeBranch_;

        DoubleData() {
        }
    }
}

