/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.function.BuiltinNodeFactory;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.Builtin;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;

public final class JSBuiltin
implements Builtin,
JSFunctionData.CallTargetInitializer {
    private final String name;
    private final String fullName;
    private final Object key;
    private final int length;
    private final byte attributeFlags;
    private final byte ecmaScriptVersion;
    private final boolean annexB;
    private final BuiltinNodeFactory functionNodeFactory;
    private final BuiltinNodeFactory constructorNodeFactory;
    private final BuiltinNodeFactory newTargetConstructorNodeFactory;

    public JSBuiltin(String containerName, Object key, int length, int attributeFlags, int ecmaScriptVersion, boolean annexB, BuiltinNodeFactory functionNodeFactory, BuiltinNodeFactory constructorNodeFactory, BuiltinNodeFactory newTargetConstructorFactory) {
        assert (JSBuiltin.isAllowedKey(key));
        assert ((byte)ecmaScriptVersion == ecmaScriptVersion && (byte)attributeFlags == attributeFlags);
        this.name = key instanceof Symbol ? ((Symbol)key).toFunctionNameString() : (String)key;
        this.fullName = containerName == null ? this.name : containerName + "." + this.name;
        this.key = key;
        this.length = length;
        this.ecmaScriptVersion = (byte)ecmaScriptVersion;
        this.attributeFlags = (byte)attributeFlags;
        this.annexB = annexB;
        this.functionNodeFactory = functionNodeFactory;
        this.constructorNodeFactory = constructorNodeFactory;
        this.newTargetConstructorNodeFactory = newTargetConstructorFactory;
    }

    public JSBuiltin(String containerName, String name, int length, int flags, BuiltinNodeFactory functionNodeFactory) {
        this(containerName, name, length, flags, 5, false, functionNodeFactory, null, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public boolean isConstructor() {
        return this.constructorNodeFactory != null;
    }

    public boolean hasSeparateConstructor() {
        return this.isConstructor() && this.constructorNodeFactory != this.functionNodeFactory;
    }

    public boolean hasNewTargetConstructor() {
        return this.isConstructor() && this.newTargetConstructorNodeFactory != null;
    }

    @Override
    public int getECMAScriptVersion() {
        return Math.max(5, this.ecmaScriptVersion);
    }

    @Override
    public boolean isAnnexB() {
        return this.annexB;
    }

    @Override
    public int getAttributeFlags() {
        return this.attributeFlags;
    }

    @Override
    public boolean isConfigurable() {
        return (this.attributeFlags & 2) == 0;
    }

    @Override
    public boolean isWritable() {
        return (this.attributeFlags & 4) == 0;
    }

    @Override
    public boolean isEnumerable() {
        return (this.attributeFlags & 1) == 0;
    }

    public static SourceSection getSourceSection() {
        return JSBuiltin.createSourceSection();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "JSBuiltin [name=" + this.name + ", length=" + this.length + "]";
    }

    private static boolean isAllowedKey(Object key) {
        String name;
        if (key instanceof Symbol) {
            return true;
        }
        return key instanceof String && (!(name = (String)key).isEmpty() && (!name.endsWith("_") || name.equals("get $_")) && !name.startsWith("_") || name.startsWith("__") && name.endsWith("__"));
    }

    @Override
    public JSFunctionData createFunctionData(JSContext context) {
        JSFunctionData cached = context.getBuiltinFunctionData(this);
        if (cached != null) {
            return cached;
        }
        JSFunctionData functionData = JSFunctionData.create(context, this.getLength(), this.getName(), this.isConstructor(), false, false, true);
        if (JSTruffleOptions.LazyFunctionData) {
            functionData.setLazyInit(this);
        } else {
            this.initializeEager(functionData);
        }
        context.putBuiltinFunctionData(this, functionData);
        return functionData;
    }

    JSBuiltinNode createNode(JSContext context, boolean construct, boolean newTarget) {
        JSBuiltinNode builtinNode = this.createNodeImpl(context, construct, newTarget);
        builtinNode.construct = construct;
        builtinNode.newTarget = newTarget;
        return builtinNode;
    }

    private JSBuiltinNode createNodeImpl(JSContext context, boolean construct, boolean newTarget) {
        if (newTarget && this.newTargetConstructorNodeFactory != null) {
            return this.newTargetConstructorNodeFactory.createNode(context, this);
        }
        if (construct && this.constructorNodeFactory != null) {
            return this.constructorNodeFactory.createNode(context, this);
        }
        return this.functionNodeFactory.createNode(context, this);
    }

    public static SourceSection createSourceSection() {
        return JSFunction.BUILTIN_SOURCE_SECTION;
    }

    private static void initializeFunctionData(JSFunctionData functionData, JSBuiltin builtin) {
        JSContext context = functionData.getContext();
        JSBuiltinNode functionRoot = JSBuiltinNode.createBuiltin(context, builtin, false, false);
        FrameDescriptor frameDescriptor = null;
        FunctionRootNode callRoot = FunctionRootNode.create(functionRoot, frameDescriptor, functionData, JSBuiltin.getSourceSection(), builtin.getFullName());
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)callRoot);
        callTarget = functionData.setRootTarget((CallTarget)callTarget);
        functionData.setCallTarget((CallTarget)callTarget);
    }

    private static void initializeFunctionDataCallTarget(JSFunctionData functionData, JSBuiltin builtin, JSFunctionData.Target target, CallTarget callTarget) {
        JSContext context = functionData.getContext();
        NodeFactory factory = NodeFactory.getDefaultInstance();
        FrameDescriptor frameDescriptor = null;
        if (target == JSFunctionData.Target.Construct) {
            JavaScriptRootNode constructRoot;
            if (builtin.hasSeparateConstructor()) {
                JSBuiltinNode constructNode = JSBuiltinNode.createBuiltin(context, builtin, true, false);
                constructRoot = FunctionRootNode.create(constructNode, frameDescriptor, functionData, JSBuiltin.getSourceSection(), builtin.getFullName());
            } else {
                constructRoot = factory.createConstructorRootNode(functionData, callTarget, false);
            }
            RootCallTarget constructTarget = Truffle.getRuntime().createCallTarget((RootNode)constructRoot);
            functionData.setConstructTarget((CallTarget)constructTarget);
        } else if (target == JSFunctionData.Target.ConstructNewTarget) {
            JavaScriptRootNode constructNewTargetRoot;
            if (builtin.hasNewTargetConstructor()) {
                JSBuiltinNode constructNewTargetNode = JSBuiltinNode.createBuiltin(context, builtin, true, true);
                constructNewTargetRoot = FunctionRootNode.create(constructNewTargetNode, frameDescriptor, functionData, JSBuiltin.getSourceSection(), builtin.getFullName());
            } else {
                CallTarget constructTarget = functionData.getConstructTarget();
                constructNewTargetRoot = factory.createDropNewTarget(functionData.getContext(), constructTarget);
            }
            functionData.setConstructNewTarget((CallTarget)Truffle.getRuntime().createCallTarget((RootNode)constructNewTargetRoot));
        }
    }

    @Override
    public void initializeRoot(JSFunctionData functionData) {
        JSBuiltin.initializeFunctionData(functionData, this);
    }

    @Override
    public void initializeCallTarget(JSFunctionData functionData, JSFunctionData.Target target, CallTarget callTarget) {
        JSBuiltin.initializeFunctionDataCallTarget(functionData, this, target, callTarget);
    }
}

