/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.intl.CreateOptionsObjectNode;
import com.oracle.truffle.js.nodes.intl.CreateOptionsObjectNodeGen;
import com.oracle.truffle.js.nodes.intl.DefaultNumberOptionNode;
import com.oracle.truffle.js.nodes.intl.GetNumberOptionNode;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializePluralRulesNodeGen;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.JSPluralRules;
import java.util.MissingResourceException;

public abstract class InitializePluralRulesNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CreateOptionsObjectNode createOptionsNode;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetNumberOptionNode getMinIntDigitsOption;
    @Node.Child
    GetNumberOptionNode getMinFracDigitsOption;
    @Node.Child
    GetNumberOptionNode getMaxFracDigitsOption;
    @Node.Child
    PropertyGetNode getMinSignificantDigitsOption;
    @Node.Child
    PropertyGetNode getMaxSignificantDigitsOption;
    @Node.Child
    DefaultNumberOptionNode getMnsdDNO;
    @Node.Child
    DefaultNumberOptionNode getMxsdDNO;
    @Node.Child
    GetStringOptionNode getTypeOption;

    protected InitializePluralRulesNode(JSContext context) {
        this.context = context;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context);
        this.createOptionsNode = CreateOptionsObjectNodeGen.create(context);
        this.getLocaleMatcherOption = GetStringOptionNode.create(context, "localeMatcher", new String[]{"lookup", "best fit"}, "best fit");
        this.getTypeOption = GetStringOptionNode.create(context, "type", new String[]{"cardinal", "ordinal"}, "cardinal");
        this.getMinIntDigitsOption = GetNumberOptionNode.create(context, "minimumIntegerDigits", 21);
        this.getMinSignificantDigitsOption = PropertyGetNode.create("minimumSignificantDigits", false, context);
        this.getMaxSignificantDigitsOption = PropertyGetNode.create("maximumSignificantDigits", false, context);
        this.getMinFracDigitsOption = GetNumberOptionNode.create(context, "minimumFractionDigits", 21);
        this.getMaxFracDigitsOption = GetNumberOptionNode.create(context, "maximumFractionDigits", 20);
        this.getMnsdDNO = DefaultNumberOptionNode.create(21, 1);
        this.getMxsdDNO = DefaultNumberOptionNode.create(21, 21);
    }

    public abstract DynamicObject executeInit(DynamicObject var1, Object var2, Object var3);

    public static InitializePluralRulesNode createInitalizePluralRulesNode(JSContext context) {
        return InitializePluralRulesNodeGen.create(context);
    }

    @Specialization
    public DynamicObject initializePluralRules(DynamicObject pluralRulesObj, Object localesArg, Object optionsArg) {
        try {
            JSPluralRules.InternalState state = JSPluralRules.getInternalState(pluralRulesObj);
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            DynamicObject options = this.createOptionsNode.execute(optionsArg);
            this.getLocaleMatcherOption.executeValue(options);
            String optType = this.getTypeOption.executeValue(options);
            state.setInitialized(true);
            state.setType(optType);
            JSNumberFormat.setLocaleAndNumberingSystem(this.context, state, locales);
            JSPluralRules.setupInternalPluralRulesAndNumberFormat(state);
            int mnfdDefault = 0;
            int mxfdDefault = 3;
            this.setPluralRulesDigitOptions(state, options, mnfdDefault, mxfdDefault);
        }
        catch (MissingResourceException e) {
            throw Errors.createICU4JDataError(e);
        }
        return pluralRulesObj;
    }

    private void setPluralRulesDigitOptions(JSPluralRules.InternalState state, DynamicObject options, int mnfdDefault, int mxfdDefault) {
        Number mnid = this.getMinIntDigitsOption.executeValue(options, 1, 1);
        Number mnfd = this.getMinFracDigitsOption.executeValue(options, 0, mnfdDefault);
        int mxfdActualDefault = Math.max(mnfd.intValue(), mxfdDefault);
        Number mxfd = this.getMaxFracDigitsOption.executeValue(options, mnfdDefault, mxfdActualDefault);
        state.setIntegerAndFractionsDigits(mnid.intValue(), mnfd.intValue(), mxfd.intValue());
        Object mnsd = this.getMinSignificantDigitsOption.getValue(options);
        Object mxsd = this.getMaxSignificantDigitsOption.getValue(options);
        if (!JSGuards.isUndefined(mnsd) || !JSGuards.isUndefined(mxsd)) {
            Number mnsdNumber = this.getMnsdDNO.executeValue(mnsd, 1);
            Number mxsdNumber = this.getMxsdDNO.executeValue(mxsd, mnsdNumber.intValue());
            state.setSignificantDigits(mnsdNumber.intValue(), mxsdNumber.intValue());
        }
    }
}

