/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.unary.IsConstructorNode;

@GeneratedBy(value=IsConstructorNode.class)
public final class IsConstructorNodeGen
extends IsConstructorNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;

    private IsConstructorNodeGen() {
    }

    @Override
    public boolean executeBoolean(Object arg0Value) {
        Object arg0Value_;
        int state = this.state_;
        if ((state & 3) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 1) != 0 && JSGuards.isJSFunction(arg0Value_)) {
                return IsConstructorNode.doJSFunction(arg0Value_);
            }
            if ((state & 2) != 0 && JSGuards.isJSProxy(arg0Value_)) {
                return IsConstructorNode.doJSProxy(arg0Value_);
            }
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitString((state & 0xF0) >>> 4, arg0Value)) {
            arg0Value_ = JSTypesGen.asImplicitString((state & 0xF0) >>> 4, arg0Value);
            return IsConstructorNode.doString((String)arg0Value_);
        }
        if ((state & 8) != 0 && !JSGuards.isJSFunction(arg0Value) && !JSGuards.isJSProxy(arg0Value)) {
            return IsConstructorNode.doOther(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private boolean executeAndSpecialize(Object arg0Value) {
        int stringCast0;
        int state = this.state_;
        if (JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if (JSGuards.isJSFunction(arg0Value_)) {
                this.state_ = state |= 1;
                return IsConstructorNode.doJSFunction(arg0Value_);
            }
            if (JSGuards.isJSProxy(arg0Value_)) {
                this.state_ = state |= 2;
                return IsConstructorNode.doJSProxy(arg0Value_);
            }
        }
        if ((stringCast0 = JSTypesGen.specializeImplicitString(arg0Value)) != 0) {
            String arg0Value_ = JSTypesGen.asImplicitString(stringCast0, arg0Value);
            state |= stringCast0 << 4;
            this.state_ = state |= 4;
            return IsConstructorNode.doString(arg0Value_);
        }
        if (!JSGuards.isJSFunction(arg0Value) && !JSGuards.isJSProxy(arg0Value)) {
            this.state_ = state |= 8;
            return IsConstructorNode.doOther(arg0Value);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0xF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xF & (state & 0xF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doJSFunction";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doJSProxy";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static IsConstructorNode create() {
        return new IsConstructorNodeGen();
    }

    public static IsConstructorNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=IsConstructorNode.class)
    private static final class Uncached
    extends IsConstructorNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean executeBoolean(Object arg0Value) {
            Object arg0Value_;
            if (JSTypes.isDynamicObject(arg0Value)) {
                arg0Value_ = (DynamicObject)arg0Value;
                if (JSGuards.isJSFunction(arg0Value_)) {
                    return IsConstructorNode.doJSFunction(arg0Value_);
                }
                if (JSGuards.isJSProxy(arg0Value_)) {
                    return IsConstructorNode.doJSProxy(arg0Value_);
                }
            }
            if (JSTypesGen.isImplicitString(arg0Value)) {
                arg0Value_ = JSTypesGen.asImplicitString(arg0Value);
                return IsConstructorNode.doString((String)arg0Value_);
            }
            if (!JSGuards.isJSFunction(arg0Value) && !JSGuards.isJSProxy(arg0Value)) {
                return IsConstructorNode.doOther(arg0Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

