/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.lexer;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.languages.CharInput;
import org.netbeans.modules.languages.lexer.InputBridge;
import org.netbeans.modules.languages.lexer.SLexer;
import org.netbeans.modules.languages.parser.Pattern;

class DelegatingInputBridge
extends CharInput {
    private InputBridge input;
    private Pattern start;
    private Pattern end;
    private int tokenType;
    private List<SLexer.Vojta> embeddings = new ArrayList<SLexer.Vojta>();

    DelegatingInputBridge(InputBridge input, Pattern start, Pattern end, int tokenType) {
        this.input = input;
        this.start = start;
        this.end = end;
        this.tokenType = tokenType;
    }

    @Override
    public char read() {
        this.readEmbeddings();
        return this.input.read();
    }

    @Override
    public void setIndex(int index) {
        this.input.setIndex(index);
    }

    @Override
    public int getIndex() {
        return this.input.getIndex();
    }

    @Override
    public char next() {
        this.readEmbeddings();
        return this.input.next();
    }

    @Override
    public boolean eof() {
        this.readEmbeddings();
        return this.input.eof();
    }

    @Override
    public String getString(int from, int to) {
        return this.input.getString(from, to);
    }

    public String toString() {
        return this.input.toString();
    }

    public List<SLexer.Vojta> getEmbeddings() {
        List<SLexer.Vojta> e = this.embeddings;
        this.embeddings = new ArrayList<SLexer.Vojta>();
        return e;
    }

    private void readEmbeddings() {
        int startIndex = this.input.getIndex();
        if (!this.input.eof() && this.start.next(this.input) != null) {
            int startSkipLength = this.input.getIndex() - startIndex;
            int endSkipLength = this.input.getIndex();
            while (!this.input.eof() && this.end.next(this.input) == null) {
                this.input.read();
                endSkipLength = this.input.getIndex();
            }
            endSkipLength = this.input.getIndex() - endSkipLength;
            this.embeddings.add(new SLexer.Vojta(this.tokenType, startIndex, this.input.getIndex(), new SLexer.TokenProperties(SLexer.INJECTED_CODE, startSkipLength, endSkipLength)));
        }
    }
}

