/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommand;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MICommandInjector;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIProxy;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIUserInteraction;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebuggerConfig;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebuggerEngineProvider;
import org.netbeans.modules.cpplite.debugger.CallStackModel;
import org.netbeans.modules.cpplite.debugger.Utils;
import org.netbeans.modules.cpplite.debugger.VariablesModel;
import org.netbeans.modules.cpplite.debugger.WatchesModel;
import org.netbeans.modules.cpplite.debugger.breakpoints.BreakpointModel;
import org.netbeans.modules.cpplite.debugger.breakpoints.CPPLiteBreakpoint;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public class CPPLiteDebugger
extends ActionsProviderSupport {
    private static final Logger logger = Logger.getLogger(CPPLiteDebugger.class.getName());
    private static RequestProcessor actionsRequestProcessor;
    private static RequestProcessor killRequestProcessor;
    private CPPLiteDebuggerConfig configuration;
    private CPPLiteDebuggerEngineProvider engineProvider;
    private ContextProvider contextProvider;
    private Process debuggee;
    private MIProxy proxy;
    private Object currentLine;
    private LinkedList callStackList = new LinkedList();
    private volatile boolean suspended = false;
    private final List<StateListener> stateListeners = new CopyOnWriteArrayList<StateListener>();
    private VariablesModel variablesModel;
    private WatchesModel watchesModel;
    private BreakpointModel breakpointModel;
    private static final Set<Object> actions;
    private static final Set<Object> actionsToDisable;
    private volatile boolean finished = false;
    private CallStackModel callStackModel;
    private String[] variables = new String[0];

    public CPPLiteDebugger(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.configuration = (CPPLiteDebuggerConfig)contextProvider.lookupFirst(null, CPPLiteDebuggerConfig.class);
        this.engineProvider = (CPPLiteDebuggerEngineProvider)((Object)contextProvider.lookupFirst(null, DebuggerEngineProvider.class));
        Iterator<Object> it = actions.iterator();
        while (it.hasNext()) {
            this.setEnabled(it.next(), true);
        }
    }

    void setDebuggee(Process debuggee) {
        this.debuggee = debuggee;
        CPPLiteInjector injector = new CPPLiteInjector(debuggee.getOutputStream());
        final CountDownLatch waitStarted = new CountDownLatch(1);
        this.proxy = new MIProxy(injector, "(gdb)", "UTF-8"){

            @Override
            protected void prompt() {
                waitStarted.countDown();
            }

            @Override
            protected void execAsyncOutput(MIRecord record) {
                if (record.token() == 0) {
                    block4 : switch (record.cls()) {
                        case "stopped": {
                            String reason;
                            switch (reason = record.results().getConstValue("reason", "")) {
                                case "exited-normally": {
                                    CPPLiteDebugger.this.finish();
                                    break block4;
                                }
                            }
                            Frame frame = new Frame((MITList)record.results().valueOf("frame"));
                            Line currentLine = frame.location();
                            Utils.markCurrent(new Line[]{currentLine});
                            Utils.showLine(new Line[]{currentLine});
                            CPPLiteDebugger.this.setSuspended(true);
                            CPPLiteDebugger.this.suspended();
                            break;
                        }
                        case "running": {
                            CPPLiteDebugger.this.setSuspended(false);
                            Utils.unmarkCurrent();
                            CPPLiteDebugger.this.running();
                            break;
                        }
                        default: {
                            System.err.println("Unknown class:" + record.cls());
                        }
                    }
                    return;
                }
                super.execAsyncOutput(record);
            }
        };
        new Thread(() -> {
            try (BufferedReader r = new BufferedReader(new InputStreamReader(debuggee.getInputStream()));){
                String line;
                while ((line = r.readLine()) != null) {
                    this.proxy.processLine(line);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }).start();
        try {
            waitStarted.await();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        for (Breakpoint b : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            File sourceFile;
            if (!(b instanceof CPPLiteBreakpoint)) continue;
            CPPLiteBreakpoint cpplineBreakpoint = (CPPLiteBreakpoint)b;
            Line l = cpplineBreakpoint.getLine();
            FileObject source = (FileObject)l.getLookup().lookup(FileObject.class);
            File file = sourceFile = source != null ? FileUtil.toFile((FileObject)source) : null;
            if (sourceFile == null) continue;
            this.proxy.send(new SimpleCommand("-break-insert " + sourceFile.getAbsolutePath() + ":" + (l.getLineNumber() + 1)));
        }
        this.proxy.send(new SimpleCommand("-exec-run"));
    }

    public Set getActions() {
        return actions;
    }

    public void doAction(Object action) {
        logger.log(Level.FINE, "CPPLiteDebugger.doAction({0}), is kill = {1}", new Object[]{action, action == ActionsManager.ACTION_KILL});
        if (action == ActionsManager.ACTION_KILL) {
            this.finish();
        } else if (action == ActionsManager.ACTION_CONTINUE) {
            this.proxy.send(new SimpleCommand("-exec-continue"));
        } else {
            if (action == ActionsManager.ACTION_START) {
                return;
            }
            if (action == ActionsManager.ACTION_STEP_INTO || action == ActionsManager.ACTION_STEP_OUT || action == ActionsManager.ACTION_STEP_OVER) {
                this.doStep(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        if (action == ActionsManager.ACTION_KILL) {
            Class<CPPLiteDebugger> clazz = CPPLiteDebugger.class;
            synchronized (CPPLiteDebugger.class) {
                if (killRequestProcessor == null) {
                    killRequestProcessor = new RequestProcessor("CPPLite debugger finish RP", 1);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                killRequestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CPPLiteDebugger.this.doAction(action);
                        }
                        finally {
                            actionPerformedNotifier.run();
                        }
                    }
                });
                return;
            }
        }
        this.setDebugActionsEnabled(false);
        Class<CPPLiteDebugger> clazz = CPPLiteDebugger.class;
        synchronized (CPPLiteDebugger.class) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("CPPLite debugger actions RP", 1);
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            actionsRequestProcessor.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        CPPLiteDebugger.this.doAction(action);
                    }
                    finally {
                        actionPerformedNotifier.run();
                        CPPLiteDebugger.this.setDebugActionsEnabled(true);
                    }
                }
            });
            return;
        }
    }

    private void setDebugActionsEnabled(boolean enabled) {
        for (Object action : actionsToDisable) {
            this.setEnabled(action, enabled);
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    private void setSuspended(boolean suspended) {
        this.suspended = suspended;
        this.fireStateChanged(suspended);
    }

    private void fireStateChanged(boolean suspended) {
        for (StateListener sl : this.stateListeners) {
            sl.suspended(suspended);
        }
    }

    private void fireFinished() {
        for (StateListener sl : this.stateListeners) {
            sl.finished();
        }
    }

    public void addStateListener(StateListener sl) {
        this.stateListeners.add(sl);
    }

    public void removeStateListener(StateListener sl) {
        this.stateListeners.remove(sl);
    }

    private void suspended() {
        this.proxy.send(new SimpleCommand("-stack-list-frames"){

            @Override
            protected void onDone(MIRecord record) {
                CPPLiteDebugger.this.callStackList.clear();
                for (MITListItem frame : record.results().valueOf("stack").asList()) {
                    CPPLiteDebugger.this.callStackList.add(new Frame((MITList)((MIResult)frame).value()));
                }
                CPPLiteDebugger.this.getCallStackModel().fireChanges();
            }
        });
        this.fireWatches();
        this.fireBreakpoints();
    }

    private void running() {
        this.callStackList.clear();
        this.getCallStackModel().fireChanges();
    }

    public Object getCurrentLine() {
        return this.currentLine;
    }

    public boolean isFinished() {
        return this.finished;
    }

    private void doStep(Object action) {
        if (action == ActionsManager.ACTION_STEP_OVER) {
            this.proxy.send(new SimpleCommand("-exec-next"));
        } else if (action == ActionsManager.ACTION_STEP_INTO) {
            this.proxy.send(new SimpleCommand("-exec-step"));
        }
    }

    private void finish() {
        logger.fine("CPPLiteDebugger.finish()");
        if (this.finished) {
            logger.fine("finish(): already finished.");
            return;
        }
        this.proxy.send(new SimpleCommand("-gdb-exit"));
        Utils.unmarkCurrent();
        this.engineProvider.getDestructor().killEngine();
        this.finished = true;
        this.fireFinished();
        logger.fine("finish() done, build finished.");
    }

    private CallStackModel getCallStackModel() {
        if (this.callStackModel == null) {
            this.callStackModel = (CallStackModel)this.contextProvider.lookupFirst("CallStackView", TreeModel.class);
        }
        return this.callStackModel;
    }

    Object[] getCallStack() {
        Object[] callStack = this.callStackList.toArray();
        return callStack;
    }

    synchronized void setVariablesModel(VariablesModel variablesModel) {
        this.variablesModel = variablesModel;
    }

    synchronized void setWatchesModel(WatchesModel watchesModel) {
        this.watchesModel = watchesModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireVariables() {
        CPPLiteDebugger cPPLiteDebugger = this;
        synchronized (cPPLiteDebugger) {
            if (this.variablesModel == null) {
                return;
            }
        }
        this.variablesModel.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWatches() {
        CPPLiteDebugger cPPLiteDebugger = this;
        synchronized (cPPLiteDebugger) {
            if (this.watchesModel == null) {
                return;
            }
        }
        this.watchesModel.fireChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBreakpoints() {
        CPPLiteDebugger cPPLiteDebugger = this;
        synchronized (cPPLiteDebugger) {
            if (this.breakpointModel == null) {
                List bpNodeModels = DebuggerManager.getDebuggerManager().lookup("BreakpointsView", NodeModel.class);
                for (NodeModel model : bpNodeModels) {
                    if (!(model instanceof BreakpointModel)) continue;
                    this.breakpointModel = (BreakpointModel)model;
                    break;
                }
            }
        }
        this.breakpointModel.fireChanges();
    }

    String evaluate(String expression) {
        String value = this.getVariableValue(expression);
        if (value != null) {
            return value;
        }
        final CountDownLatch done = new CountDownLatch(1);
        final String[] varName = new String[1];
        final String[] resultValue = new String[1];
        this.proxy.send(new SimpleCommand("-var-create - * " + expression){

            @Override
            protected void onDone(MIRecord record) {
                MITList results = record.results();
                varName[0] = results.valueOf("name").asConst().value();
                resultValue[0] = results.valueOf("value").asConst().value();
                done.countDown();
            }

            @Override
            protected void onError(MIRecord record) {
                resultValue[0] = record.toString();
                done.countDown();
            }
        });
        try {
            done.await();
        }
        catch (InterruptedException ex) {
            return resultValue[0];
        }
        if (varName[0] != null) {
            this.proxy.send(new SimpleCommand("-var-delete " + varName[0]));
        }
        return resultValue[0];
    }

    String[] getVariables() {
        return this.variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getVariableValue(String variableName) {
        CPPLiteDebugger cPPLiteDebugger = this;
        synchronized (cPPLiteDebugger) {
            return null;
        }
    }

    @NonNull
    public static Pair<CPPLiteDebugger, Process> startDebugging(final CPPLiteDebuggerConfig configuration) throws IOException {
        DebuggerInfo di = DebuggerInfo.create((String)"CPPLiteDebuggerInfo", (Object[])new Object[]{new SessionProvider(){

            public String getSessionName() {
                return configuration.getDisplayName();
            }

            public String getLocationName() {
                return "localhost";
            }

            public String getTypeID() {
                return "CPPLiteSession";
            }

            public Object[] getServices() {
                return new Object[0];
            }
        }, configuration});
        DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(di);
        final Pty pty = PtySupport.allocate((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        CPPLiteDebugger debugger = (CPPLiteDebugger)((Object)es[0].lookupFirst(null, CPPLiteDebugger.class));
        ArrayList<String> executable = new ArrayList<String>();
        executable.add("gdb");
        executable.add("--interpreter=mi");
        executable.add("--tty=" + pty.getSlaveName());
        executable.addAll(configuration.getExecutable());
        final Process debuggee = new ProcessBuilder(executable).start();
        new RequestProcessor(configuration.getDisplayName() + " (pty deallocator)").post(() -> {
            try {
                while (debuggee.isAlive()) {
                    try {
                        debuggee.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                try {
                    PtySupport.deallocate((Pty)pty);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        debugger.setDebuggee(debuggee);
        return Pair.of((Object)((Object)debugger), (Object)new Process(){

            @Override
            public OutputStream getOutputStream() {
                return pty.getOutputStream();
            }

            @Override
            public InputStream getInputStream() {
                return pty.getInputStream();
            }

            @Override
            public InputStream getErrorStream() {
                return pty.getErrorStream();
            }

            @Override
            public int waitFor() throws InterruptedException {
                return debuggee.waitFor();
            }

            @Override
            public int exitValue() {
                return debuggee.exitValue();
            }

            @Override
            public void destroy() {
                debuggee.destroy();
            }
        });
    }

    static {
        actions = new HashSet<Object>();
        actionsToDisable = new HashSet<Object>();
        actions.add(ActionsManager.ACTION_KILL);
        actions.add(ActionsManager.ACTION_CONTINUE);
        actions.add(ActionsManager.ACTION_START);
        actions.add(ActionsManager.ACTION_STEP_INTO);
        actions.add(ActionsManager.ACTION_STEP_OVER);
        actions.add(ActionsManager.ACTION_STEP_OUT);
        actionsToDisable.addAll(actions);
        actionsToDisable.remove(ActionsManager.ACTION_KILL);
    }

    public static class Frame {
        public final String shortFileName;
        public final String fullFileName;
        public final String functionName;
        public final int line;
        public final int level;

        public Frame(MITList frame) {
            if (frame == null || frame.valueOf("file") == null || frame.valueOf("file").asConst() == null) {
                System.err.println("!!!");
            }
            this.shortFileName = frame.valueOf("file").asConst().value();
            this.functionName = frame.valueOf("func").asConst().value();
            this.fullFileName = frame.valueOf("fullname").asConst().value();
            this.line = Integer.parseInt(frame.valueOf("line").asConst().value());
            this.level = frame.valueOf("level") != null ? Integer.parseInt(frame.valueOf("level").asConst().value()) : -1;
        }

        @CheckForNull
        public Line location() {
            FileObject file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.fullFileName)));
            if (file == null) {
                return null;
            }
            LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
            return lc.getLineSet().getOriginal(this.line - 1);
        }
    }

    private static class SimpleCommand
    extends MICommand {
        public SimpleCommand(String command) {
            super(0, command);
        }

        @Override
        protected void onDone(MIRecord record) {
        }

        @Override
        protected void onRunning(MIRecord record) {
        }

        @Override
        protected void onError(MIRecord record) {
        }

        @Override
        protected void onExit(MIRecord record) {
        }

        @Override
        protected void onStopped(MIRecord record) {
        }

        @Override
        protected void onOther(MIRecord record) {
        }

        @Override
        protected void onUserInteraction(MIUserInteraction ui) {
        }
    }

    public static interface StateListener {
        public void suspended(boolean var1);

        public void finished();
    }

    private static class CPPLiteInjector
    implements MICommandInjector {
        private final OutputStream out;

        public CPPLiteInjector(OutputStream out) {
            this.out = out;
        }

        @Override
        public void inject(String data) {
            try {
                this.out.write(data.getBytes());
                this.out.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void log(String data) {
            System.err.println(data);
        }
    }
}

