/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.common;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.jumpto.common.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public final class UiUtils {
    private UiUtils() {
        throw new IllegalStateException("No instance allowed.");
    }

    @NonNull
    public static DocumentFilter newUserInputFilter() {
        return new UserInputFilter();
    }

    @NonNull
    public static String htmlize(@NonNull CharSequence input) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static final class UserInputFilter
    extends DocumentFilter {
        private UserInputFilter() {
        }

        @Override
        public void insertString(@NonNull DocumentFilter.FilterBypass fb, int offset, @NonNull String string, @NullAllowed AttributeSet attr) throws BadLocationException {
            if (Utils.isValidInput(string)) {
                super.insertString(fb, offset, string, attr);
            } else {
                UserInputFilter.handleWrongInput();
            }
        }

        @Override
        public void replace(@NonNull DocumentFilter.FilterBypass fb, int offset, int length, @NullAllowed String text, @NullAllowed AttributeSet attrs) throws BadLocationException {
            if (text == null || Utils.isValidInput(text)) {
                super.replace(fb, offset, length, text, attrs);
            } else {
                UserInputFilter.handleWrongInput();
            }
        }

        private static void handleWrongInput() {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(UiUtils.class, (String)"TXT_IllegalContent"));
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

