/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.EventSetDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.RADComponent;

public class Event {
    private static String[] NO_HANDLERS = new String[0];
    private RADComponent component;
    private EventSetDescriptor eventSetDescriptor;
    private Method listenerMethod;
    private boolean inCEDL;
    private List<String> eventHandlers;

    Event(RADComponent component, EventSetDescriptor eventSetDescriptor, Method listenerMethod) {
        this.component = component;
        this.eventSetDescriptor = eventSetDescriptor;
        this.listenerMethod = listenerMethod;
    }

    public String getName() {
        return this.listenerMethod.getName();
    }

    public String getId() {
        return FormEvents.getEventIdName(this.listenerMethod);
    }

    public final RADComponent getComponent() {
        return this.component;
    }

    public final EventSetDescriptor getEventSetDescriptor() {
        return this.eventSetDescriptor;
    }

    public final Method getListenerMethod() {
        return this.listenerMethod;
    }

    public final String getEventParameterType() {
        Class<?>[] paramTypes;
        Class<?>[] classArray = paramTypes = this.listenerMethod != null ? this.listenerMethod.getParameterTypes() : null;
        if (paramTypes != null && paramTypes.length == 1) {
            return paramTypes[0].getCanonicalName();
        }
        return null;
    }

    public boolean hasEventHandlers() {
        return this.eventHandlers != null && this.eventHandlers.size() > 0;
    }

    public boolean hasEventHandler(String handler) {
        return this.eventHandlers != null ? this.eventHandlers.contains(handler) : false;
    }

    public String[] getEventHandlers() {
        if (this.eventHandlers == null || this.eventHandlers.isEmpty()) {
            return NO_HANDLERS;
        }
        String[] handlerNames = new String[this.eventHandlers.size()];
        this.eventHandlers.toArray(handlerNames);
        return handlerNames;
    }

    public final boolean isInCEDL() {
        return this.inCEDL;
    }

    void setInCEDL(boolean isIn) {
        this.inCEDL = isIn;
    }

    boolean addEventHandler(String handlerName) {
        if (this.eventHandlers == null) {
            this.eventHandlers = new ArrayList<String>(1);
        } else if (this.eventHandlers.contains(handlerName)) {
            return false;
        }
        this.eventHandlers.add(handlerName);
        return true;
    }

    boolean removeEventHandler(String handlerName) {
        return this.eventHandlers != null && this.eventHandlers.remove(handlerName);
    }

    boolean renameEventHandler(String oldHandlerName, String newHandlerName) {
        if (this.eventHandlers == null) {
            return false;
        }
        int index = this.eventHandlers.indexOf(oldHandlerName);
        if (index < 0 || this.eventHandlers.contains(newHandlerName)) {
            return false;
        }
        this.eventHandlers.set(index, newHandlerName);
        return true;
    }

    List getEventHandlerList() {
        return this.eventHandlers;
    }
}

