/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class JNLPUpdateManifestStartup
extends Task {
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String UTF_8 = "UTF-8";
    private static final String ATTR_CODEBASE = "Codebase";
    private static final String ATTR_PERMISSIONS = "Permissions";
    private static final String ATTR_APPLICATION_NAME = "Application-Name";
    private File jar;
    private File destJar;
    private String appName;
    private File masterJnlp;
    private final String permissions = "all-permissions";
    private final String codebase = "*";
    private SignJar signTask;
    private static final Pattern SF = Pattern.compile("META-INF/(.+)\\.SF");

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setDestJar(File destJar) {
        this.destJar = destJar;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setMasterJnlp(File masterJnlp) {
        this.masterJnlp = masterJnlp;
    }

    private SignJar getSignTask() {
        if (this.signTask == null) {
            this.signTask = (SignJar)this.getProject().createTask("signjar");
        }
        return this.signTask;
    }

    public void setAlias(String a) {
        this.getSignTask().setAlias(a);
    }

    public void setStorePass(String p) {
        this.getSignTask().setStorepass(p);
    }

    public void setKeystore(String k) {
        this.getSignTask().setKeystore(k);
    }

    public void setStoreType(String t) {
        this.getSignTask().setStoretype(t);
    }

    public void execute() throws BuildException {
        File tmpFile = null;
        try {
            if (JNLPUpdateManifestStartup.isSigned(this.jar) == null) {
                tmpFile = this.extendLibraryManifest(this.getProject(), this.jar, this.destJar, "*", "all-permissions", this.appName);
            }
        }
        catch (IOException | ManifestException ex) {
            this.getProject().log("Failed to extend libraries manifests: " + ex.getMessage(), 1);
        }
        if (tmpFile != null) {
            this.sign(tmpFile, this.destJar);
            JNLPUpdateManifestStartup.deleteTmpFile(tmpFile);
        } else {
            this.sign(this.jar, this.destJar);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extendLibraryManifest(Project prj, File sourceJar, File signedJar, String codebase, String permissions, String appName) throws IOException, ManifestException {
        File tmpFile;
        block27: {
            Manifest manifest = null;
            Copy cp = new Copy();
            tmpFile = new File(String.format("%s.tmp", signedJar.getAbsolutePath()));
            cp.setFile(sourceJar);
            cp.setTofile(tmpFile);
            cp.execute();
            boolean success = false;
            try {
                HashMap<String, String> extendedAttrs = new HashMap<String, String>();
                try (ZipFile zf = new ZipFile(sourceJar);){
                    Manifest.Section mainSection;
                    String attr;
                    ZipEntry manifestEntry = zf.getEntry(MANIFEST);
                    if (manifestEntry != null) {
                        try (InputStreamReader in = new InputStreamReader(zf.getInputStream(manifestEntry), Charset.forName(UTF_8));){
                            manifest = new Manifest((Reader)in);
                        }
                    } else {
                        manifest = new Manifest();
                    }
                    if ((attr = (mainSection = manifest.getMainSection()).getAttributeValue(ATTR_CODEBASE)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_CODEBASE, codebase));
                        extendedAttrs.put(ATTR_CODEBASE, codebase);
                    }
                    if ((attr = mainSection.getAttributeValue(ATTR_PERMISSIONS)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_PERMISSIONS, permissions));
                        extendedAttrs.put(ATTR_PERMISSIONS, permissions);
                    }
                    if ((attr = mainSection.getAttributeValue(ATTR_APPLICATION_NAME)) == null) {
                        mainSection.addAttributeAndCheck(new Manifest.Attribute(ATTR_APPLICATION_NAME, appName));
                        extendedAttrs.put(ATTR_APPLICATION_NAME, appName);
                    }
                    if (extendedAttrs.isEmpty()) break block27;
                    Enumeration zent = zf.getEntries();
                    try (ZipOutputStream out = new ZipOutputStream(tmpFile);){
                        ZipEntry masterJnlpEntry = new ZipEntry("JNLP-INF/APPLICATION.JNLP");
                        out.putNextEntry(masterJnlpEntry);
                        try (FileInputStream masterFis = new FileInputStream(this.masterJnlp.getAbsolutePath());){
                            JNLPUpdateManifestStartup.copy(masterFis, (OutputStream)out);
                        }
                        while (zent.hasMoreElements()) {
                            ZipEntry entry = (ZipEntry)zent.nextElement();
                            try (InputStream in = zf.getInputStream(entry);){
                                out.putNextEntry(entry);
                                if (MANIFEST.equals(entry.getName())) {
                                    PrintWriter manifestOut = new PrintWriter(new OutputStreamWriter((OutputStream)out, Charset.forName(UTF_8)));
                                    manifest.write(manifestOut);
                                    manifestOut.flush();
                                    continue;
                                }
                                JNLPUpdateManifestStartup.copy(in, (OutputStream)out);
                            }
                        }
                    }
                    success = true;
                    StringBuilder message = new StringBuilder("Updating library ").append(JNLPUpdateManifestStartup.safeRelativePath(prj.getBaseDir(), tmpFile)).append(" manifest");
                    for (Map.Entry e : extendedAttrs.entrySet()) {
                        message.append(String.format(" %s: %s,", e.getKey(), e.getValue()));
                    }
                    message.deleteCharAt(message.length() - 1);
                    prj.log(message.toString(), 3);
                }
            }
            finally {
                if (!success) {
                    Delete rm = new Delete();
                    rm.setFile(tmpFile);
                    rm.setQuiet(true);
                    rm.execute();
                    tmpFile = null;
                }
            }
        }
        return tmpFile;
    }

    private static void deleteTmpFile(File tmpFile) {
        Delete del = new Delete();
        del.setFile(tmpFile);
        del.execute();
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] BUFFER = new byte[4096];
        int len;
        while ((len = in.read(BUFFER)) != -1) {
            out.write(BUFFER, 0, len);
        }
        return;
    }

    private static String safeRelativePath(File from, File to) {
        try {
            return FileUtils.getRelativePath((File)from, (File)to);
        }
        catch (Exception ex) {
            return to.getAbsolutePath();
        }
    }

    private static String isSigned(File f) throws IOException {
        try (JarFile jar = new JarFile(f);){
            Enumeration<JarEntry> en = jar.entries();
            while (en.hasMoreElements()) {
                Matcher m = SF.matcher(en.nextElement().getName());
                if (!m.matches()) continue;
                String string = m.group(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private void sign(File from, File to) {
        if (!from.exists() && from.getParentFile().getName().equals("locale")) {
            this.log("Localization file " + from + " is referenced, but cannot be found. Skipping.", 1);
            return;
        }
        this.getSignTask().setJar(from);
        if (to != null) {
            to.getParentFile().mkdirs();
        }
        this.getSignTask().setSignedjar(to);
        this.getSignTask().setDigestAlg("SHA1");
        this.getSignTask().execute();
    }
}

