/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.markdown.core.block.NestableBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class CodeBlock
extends NestableBlock {
    private static final Pattern startPattern = Pattern.compile("(?: {4}|\\t)((?: {4}|\\t)*)(.*)");
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        return startPattern.matcher(line.substring(lineOffset)).matches();
    }

    protected int processLineContent(String line, int offset) {
        Matcher matcher;
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.CODE, new Attributes());
        }
        if (!(matcher = startPattern.matcher(line.substring(offset))).matches()) {
            this.setClosed(true);
            return offset;
        }
        String intent = matcher.group(1);
        String content = matcher.group(2);
        if (this.blockLineCount > 0) {
            this.builder.characters("\n");
        }
        if (intent != null) {
            this.builder.characters(intent.replace("\t", "    "));
        }
        this.builder.characters(content);
        ++this.blockLineCount;
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

