/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.RichCharSequence;
import java.util.ArrayList;
import java.util.List;

public interface BasedSequence
extends RichCharSequence<BasedSequence> {
    public static final BasedSequence NULL = new EmptyBasedSequence();
    public static final BasedSequence EMPTY = new EmptyBasedSequence();
    public static final BasedSequence EOL = CharSubSequence.of("\n");
    public static final BasedSequence SPACE = CharSubSequence.of(" ");
    public static final List<BasedSequence> EMPTY_LIST = new ArrayList<BasedSequence>();
    public static final BasedSequence[] EMPTY_ARRAY = new BasedSequence[0];
    public static final BasedSequence[] EMPTY_SEGMENTS = new BasedSequence[0];

    public Object getBase();

    public BasedSequence getBaseSequence();

    public int getStartOffset();

    public int getEndOffset();

    public int getIndexOffset(int var1);

    public Range getIndexRange(int var1, int var2);

    public Range getSourceRange();

    public BasedSequence baseSubSequence(int var1, int var2);

    public BasedSequence baseSubSequence(int var1);

    public String unescape();

    public String unescapeNoEntities();

    public BasedSequence unescape(ReplacedTextMapper var1);

    public BasedSequence normalizeEOL(ReplacedTextMapper var1);

    public BasedSequence normalizeEndWithEOL(ReplacedTextMapper var1);

    public boolean isContinuedBy(BasedSequence var1);

    public boolean isContinuationOf(BasedSequence var1);

    public BasedSequence spliceAtEnd(BasedSequence var1);

    public boolean containsAllOf(BasedSequence var1);

    public boolean containsSomeOf(BasedSequence var1);

    public BasedSequence prefixOf(BasedSequence var1);

    public BasedSequence suffixOf(BasedSequence var1);

    public BasedSequence intersect(BasedSequence var1);

    public static class EmptyBasedSequence
    extends BasedSequenceImpl {
        @Override
        public int length() {
            return 0;
        }

        @Override
        public char charAt(int index) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }

        @Override
        public int getIndexOffset(int index) {
            if (index == 0) {
                return 0;
            }
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }

        @Override
        public BasedSequence subSequence(int i, int i1) {
            if (i == 0 && i1 == 0) {
                return this;
            }
            throw new StringIndexOutOfBoundsException("EMPTY subSequence(" + i + "," + i1 + ") only subSequence(0, 0) is allowed");
        }

        @Override
        public BasedSequence baseSubSequence(int start, int end) {
            return this.subSequence(start, end);
        }

        @Override
        public BasedSequence getBaseSequence() {
            return NULL;
        }

        @Override
        public BasedSequence getBase() {
            return NULL;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return 0;
        }

        @Override
        public Range getSourceRange() {
            return Range.NULL;
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

