/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.openide.util.WeakListeners;

public class SmartSteppingFilterImpl
implements SmartSteppingFilter {
    private final HashSet<String> filter = new HashSet();
    private final ArrayList<String> exact = new ArrayList();
    private final ArrayList<String> start = new ArrayList();
    private final ArrayList<String> end = new ArrayList();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Properties options = Properties.getDefault().getProperties("debugger.options.JPDA");
    private final Properties classFiltersProperties = Properties.getDefault().getProperties("debugger").getProperties("sources").getProperties("class_filters");
    private final PropertyChangeListener exclusionPatternsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SmartSteppingFilterImpl.this.setExclusionPatterns();
        }
    };

    public SmartSteppingFilterImpl() {
        this.options.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.exclusionPatternsListener, (Object)this.options));
        this.classFiltersProperties.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.exclusionPatternsListener, (Object)this.classFiltersProperties));
        this.setExclusionPatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExclusionPatterns() {
        Set patterns = this.options.getBoolean("UseStepFilters", true) ? (Set)this.classFiltersProperties.getCollection("enabled", Collections.emptySet()) : Collections.emptySet();
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            this.filter.clear();
            this.exact.clear();
            this.start.clear();
            this.end.clear();
            this.filter.addAll(patterns);
            this.refreshFilters(patterns);
        }
        this.pcs.firePropertyChange("exclusionPatterns", null, patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExclusionPatterns(Set<String> patterns) {
        HashSet<String> reallyNew = new HashSet<String>(patterns);
        reallyNew.removeAll(this.filter);
        if (reallyNew.size() < 1) {
            return;
        }
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            this.filter.addAll(reallyNew);
            this.refreshFilters(reallyNew);
        }
        this.pcs.firePropertyChange("exclusionPatterns", null, reallyNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExclusionPatterns(Set<String> patterns) {
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            this.filter.removeAll(patterns);
            this.exact.clear();
            this.start.clear();
            this.end.clear();
            this.refreshFilters(this.filter);
        }
        this.pcs.firePropertyChange("exclusionPatterns", patterns, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExclusionPatterns() {
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            String[] ef = new String[this.filter.size()];
            return this.filter.toArray(ef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopHere(String className) {
        HashSet<String> hashSet = this.filter;
        synchronized (hashSet) {
            int i;
            int k = this.exact.size();
            for (i = 0; i < k; ++i) {
                if (!this.exact.get(i).equals(className)) continue;
                return false;
            }
            k = this.start.size();
            for (i = 0; i < k; ++i) {
                if (!className.startsWith(this.start.get(i))) continue;
                return false;
            }
            k = this.end.size();
            for (i = 0; i < k; ++i) {
                if (!className.endsWith(this.end.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private void refreshFilters(Set<String> newFilters) {
        for (String p : newFilters) {
            if (p.startsWith("*")) {
                this.end.add(p.substring(1));
                continue;
            }
            if (p.endsWith("*")) {
                this.start.add(p.substring(0, p.length() - 1));
                continue;
            }
            this.exact.add(p);
        }
    }
}

