/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.model.FxInclude;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class IncludeResolver
extends FxNodeVisitor.ModelTreeTraversal
implements ModelBuilderStep {
    private BuildEnvironment env;

    public IncludeResolver() {
    }

    IncludeResolver(BuildEnvironment env) {
        this.env = env;
    }

    @Override
    public void visitInclude(FxInclude decl) {
        String srcPath = decl.getSourcePath();
        FileObject targetFo = null;
        if ("".equals(srcPath)) {
            TextPositions pos = this.env.getTreeUtilities().positions(decl);
            this.env.addError(new ErrorMark(pos.getStart(), pos.getEnd() - pos.getStart(), "empty-include-source-path", Bundle.ERR_emptyIncludePath(), decl));
            this.env.getAccessor().makeBroken(decl);
            return;
        }
        if (srcPath.startsWith("/")) {
            ClassPath cp = this.env.getCompilationInfo().getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
            if (cp != null) {
                targetFo = cp.findResource(srcPath);
            }
            if (targetFo == null && (cp = this.env.getCompilationInfo().getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE)) != null) {
                targetFo = cp.findResource(srcPath);
            }
        } else {
            try {
                URL u = new URL(this.env.getModel().getBaseURL(), srcPath);
                u.toURI();
                targetFo = URLMapper.findFileObject((URL)u);
            }
            catch (URISyntaxException ex) {
                TextPositions pos = this.env.getTreeUtilities().positions(decl);
                this.env.addError(new ErrorMark(pos.getStart(), pos.getEnd() - pos.getStart(), "invalid-include-path", Bundle.ERR_invalidSourcePath(srcPath, ex.getLocalizedMessage()), decl));
            }
            catch (MalformedURLException ex) {
                TextPositions pos = this.env.getTreeUtilities().positions(decl);
                this.env.addError(new ErrorMark(pos.getStart(), pos.getEnd() - pos.getStart(), "invalid-source-path", Bundle.ERR_invalidSourcePath(srcPath, ex.getLocalizedMessage()), decl));
                this.env.getAccessor().makeBroken(decl);
                return;
            }
        }
        if (targetFo == null) {
            TextPositions pos = this.env.getTreeUtilities().positions(decl);
            this.env.addError(new ErrorMark(pos.getStart(), pos.getEnd() - pos.getStart(), "unresolved-include-path", Bundle.ERR_unresolvedIncludePath(srcPath), decl));
            this.env.getAccessor().makeBroken(decl);
        } else {
            URL resolvedUrl = targetFo.toURL();
            this.env.getAccessor().resolveResource(decl, resolvedUrl);
        }
    }

    @Override
    public FxNodeVisitor createVisitor(BuildEnvironment env) {
        return new IncludeResolver(env);
    }
}

