/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.options;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.Registry;
import org.netbeans.modules.lsp.client.options.GenericDataObject;
import org.netbeans.modules.lsp.client.options.LanguageServersPanel;
import org.netbeans.modules.textmate.lexer.TextmateTokenId;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class LanguageStorage {
    private static final String KEY = "language.descriptions";

    static List<LanguageDescription> load() {
        String descriptions = NbPreferences.forModule(LanguageServersPanel.class).get(KEY, "[]");
        return Arrays.stream((Object[])new Gson().fromJson(descriptions, LanguageDescription[].class)).collect(Collectors.toList());
    }

    static void store(List<LanguageDescription> languages) {
        Set originalMimeTypes = LanguageStorage.load().stream().map(ld -> ld.mimeType).collect(Collectors.toSet());
        HashSet mimeTypesToClear = new HashSet(originalMimeTypes);
        FileUtil.runAtomicAction(() -> {
            FileObject mimeResolver = FileUtil.getConfigFile((String)"Services/MIMEResolver");
            if (mimeResolver == null) {
                try {
                    mimeResolver = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)"Services/MIMEResolver");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            for (FileObject children : mimeResolver.getChildren()) {
                if (!"synthetic".equals(children.getAttribute(LanguageServersPanel.class.getName()))) continue;
                try {
                    children.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            for (LanguageDescription description : languages) {
                try {
                    File iconFile;
                    FileObject resolver = mimeResolver.getFileObject(description.id + ".xml");
                    if (resolver != null) {
                        resolver.delete();
                    }
                    resolver = mimeResolver.createData(description.id + ".xml");
                    Class<?> mimeResolverClass = Class.forName("org.openide.filesystems.MIMEResolver");
                    Method mimeResolverCreate = mimeResolverClass.getDeclaredMethod("create", FileObject.class);
                    resolver.setAttribute("methodvalue:instanceCreate", (Object)mimeResolverCreate);
                    resolver.setAttribute("instanceClass", (Object)"org.openide.filesystems.MIMEResolver");
                    resolver.setAttribute("mimeType", (Object)description.mimeType);
                    int c = 0;
                    for (String ext : description.extensions.split(" +")) {
                        resolver.setAttribute("ext." + c++, (Object)ext);
                    }
                    resolver.setAttribute(LanguageServersPanel.class.getName(), (Object)"synthetic");
                    FileObject syntax = FileUtil.getConfigFile((String)("Editors/" + description.mimeType + "/syntax.json"));
                    if (syntax != null) {
                        syntax.delete();
                    }
                    if ((syntax = FileUtil.getConfigFile((String)("Editors/" + description.mimeType + "/syntax.xml"))) != null) {
                        syntax.delete();
                    }
                    String ext = description.syntaxGrammar.substring(Math.max(0, description.syntaxGrammar.length() - ".json".length())).equalsIgnoreCase(".json") ? "json" : "xml";
                    syntax = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)("Editors/" + description.mimeType + "/syntax." + ext));
                    File grammar = new File(description.syntaxGrammar);
                    syntax.setAttribute("textmate-grammar", (Object)LanguageStorage.findScope(grammar));
                    try (FileInputStream in = new FileInputStream(grammar);
                         OutputStream out = syntax.getOutputStream();){
                        FileUtil.copy((InputStream)in, (OutputStream)out);
                    }
                    FileObject loader = FileUtil.getConfigFile((String)("Loaders/" + description.mimeType + "/Factories/data-object.instance"));
                    if (loader != null) {
                        loader.delete();
                    }
                    loader = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)("Loaders/" + description.mimeType + "/Factories/data-object.instance"));
                    loader.setAttribute("position", (Object)300);
                    Class<GenericDataObject> dataLoaderPoolClass = GenericDataObject.class;
                    Method dataLoaderPoolFactory = dataLoaderPoolClass.getDeclaredMethod("factory", new Class[0]);
                    loader.setAttribute("methodvalue:instanceCreate", (Object)dataLoaderPoolFactory);
                    loader.setAttribute("instanceOf", (Object)DataObject.Factory.class.getName());
                    loader.setAttribute("dataObjectClass", (Object)GenericDataObject.class.getName());
                    loader.setAttribute("mimeType", (Object)description.mimeType);
                    FileObject icon = FileUtil.getConfigFile((String)("Loaders/" + description.mimeType + "/Factories/icon.png"));
                    if (icon != null) {
                        icon.delete();
                    }
                    File file = iconFile = description.icon != null ? new File(description.icon) : null;
                    if (iconFile != null && iconFile.isFile()) {
                        icon = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)("Loaders/" + description.mimeType + "/Factories/icon.png"));
                        try (FileInputStream in = new FileInputStream(iconFile);
                             OutputStream out = icon.getOutputStream();){
                            FileUtil.copy((InputStream)in, (OutputStream)out);
                        }
                        loader.setAttribute("iconBase", (Object)icon.getNameExt());
                    }
                    if (description.languageServer != null && !description.languageServer.isEmpty()) {
                        FileObject langServer = FileUtil.createData((FileObject)FileUtil.getConfigRoot(), (String)("Editors/" + description.mimeType + "/org-netbeans-modules-lsp-client-options-GenericLanguageServer.instance"));
                        langServer.setAttribute("command", (Object)description.languageServer.split(" "));
                        if (description.name != null) {
                            langServer.setAttribute("name", (Object)description.name);
                        }
                    }
                    mimeTypesToClear.remove(description.mimeType);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            for (String mimeType : mimeTypesToClear) {
                try {
                    FileObject loader;
                    FileObject langServer;
                    FileObject syntax = FileUtil.getConfigFile((String)("Editors/" + mimeType + "/syntax.json"));
                    if (syntax != null) {
                        syntax.delete();
                    }
                    if ((langServer = FileUtil.getConfigFile((String)("Editors/" + mimeType + "/org-netbeans-modules-lsp-client-options-GenericLanguageServer.instance"))) != null) {
                        langServer.delete();
                    }
                    if ((loader = FileUtil.getConfigFile((String)("Loaders/" + mimeType + "/Factories/data-object.instance"))) == null) continue;
                    loader.delete();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        try {
            Method resetCache = Class.forName("org.openide.filesystems.MIMESupport").getDeclaredMethod("resetCache", new Class[0]);
            resetCache.setAccessible(true);
            resetCache.invoke(null, new Object[0]);
            GenericDataObject.invalidate();
            Method fireChangeEvent = DataLoaderPool.class.getDeclaredMethod("fireChangeEvent", ChangeEvent.class);
            fireChangeEvent.setAccessible(true);
            fireChangeEvent.invoke((Object)DataLoaderPool.getDefault(), new ChangeEvent(DataLoaderPool.getDefault()));
            TextmateTokenId.LanguageHierarchyImpl.refreshGrammars();
            Class<?> providerRegistry = Class.forName("org.netbeans.modules.navigator.ProviderRegistry", false, NavigatorPanel.class.getClassLoader());
            Method getInstance = providerRegistry.getDeclaredMethod("getInstance", new Class[0]);
            getInstance.setAccessible(true);
            Object providerRegistryInstance = getInstance.invoke(null, new Object[0]);
            if (providerRegistryInstance != null) {
                Field file2Providers = providerRegistry.getDeclaredField("file2Providers");
                file2Providers.setAccessible(true);
                Map file2ProvidersInstance = (Map)file2Providers.get(providerRegistryInstance);
                if (file2ProvidersInstance != null) {
                    file2ProvidersInstance.clear();
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        NbPreferences.forModule(LanguageServersPanel.class).put(KEY, new Gson().toJson(languages));
    }

    private static String findScope(File grammar) throws Exception {
        IRegistryOptions opts = new IRegistryOptions(){

            public String getFilePath(String scopeName) {
                return null;
            }

            public InputStream getInputStream(String scopeName) throws IOException {
                return null;
            }

            public Collection<String> getInjections(String scopeName) {
                return null;
            }
        };
        return new Registry(opts).loadGrammarFromPathSync(grammar).getScopeName();
    }

    public static class LanguageDescription {
        public String id;
        public String extensions;
        public String syntaxGrammar;
        public String languageServer;
        public String name;
        public String icon;
        public String mimeType;

        public LanguageDescription() {
            this.id = null;
            this.extensions = null;
            this.syntaxGrammar = null;
            this.languageServer = null;
            this.name = null;
            this.icon = null;
            this.mimeType = null;
        }

        public LanguageDescription(String id, String extensions, String syntaxGrammar, String languageServer, String name, String icon) {
            this.id = id;
            this.extensions = extensions;
            this.syntaxGrammar = syntaxGrammar;
            this.languageServer = languageServer;
            this.name = name;
            this.icon = icon;
            this.mimeType = "text/x-ext-" + id;
        }
    }
}

