/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.IDResolver;
import com.sun.xml.bind.api.ClassResolver;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.bind.unmarshaller.InfosetScanner;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.v2.ClassFactory;
import com.sun.xml.bind.v2.runtime.AssociationMap;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.unmarshaller.DefaultIDResolver;
import com.sun.xml.bind.v2.runtime.unmarshaller.InterningXmlVisitor;
import com.sun.xml.bind.v2.runtime.unmarshaller.MTOMDecorator;
import com.sun.xml.bind.v2.runtime.unmarshaller.SAXConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.StAXConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.StAXEventConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.StAXStreamConnector;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.unmarshaller.ValidatingUnmarshaller;
import com.sun.xml.bind.v2.runtime.unmarshaller.XmlVisitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.AbstractUnmarshallerImpl;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmarshallerImpl
extends AbstractUnmarshallerImpl
implements ValidationEventHandler,
Closeable {
    protected final JAXBContextImpl context;
    private Schema schema;
    public final UnmarshallingContext coordinator;
    private Unmarshaller.Listener externalListener;
    private AttachmentUnmarshaller attachmentUnmarshaller;
    private IDResolver idResolver = new DefaultIDResolver();
    private static final DefaultHandler dummyHandler = new DefaultHandler();
    public static final String FACTORY = "com.sun.xml.bind.ObjectFactory";

    public UnmarshallerImpl(JAXBContextImpl context, AssociationMap assoc) {
        this.context = context;
        this.coordinator = new UnmarshallingContext(this, assoc);
        try {
            this.setEventHandler(this);
        }
        catch (JAXBException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.getUnmarshallerHandler(true, null);
    }

    private SAXConnector getUnmarshallerHandler(boolean intern, JaxBeanInfo expectedType) {
        XmlVisitor h = this.createUnmarshallerHandler(null, false, expectedType);
        if (intern) {
            h = new InterningXmlVisitor(h);
        }
        return new SAXConnector(h, null);
    }

    public final XmlVisitor createUnmarshallerHandler(InfosetScanner scanner, boolean inplace, JaxBeanInfo expectedType) {
        this.coordinator.reset(scanner, inplace, expectedType, this.idResolver);
        XmlVisitor unmarshaller = this.coordinator;
        if (this.schema != null) {
            unmarshaller = new ValidatingUnmarshaller(this.schema, unmarshaller);
        }
        if (this.attachmentUnmarshaller != null && this.attachmentUnmarshaller.isXOPPackage()) {
            unmarshaller = new MTOMDecorator(this, unmarshaller, this.attachmentUnmarshaller);
        }
        return unmarshaller;
    }

    public static boolean needsInterning(XMLReader reader) {
        try {
            reader.setFeature("http://xml.org/sax/features/string-interning", true);
        }
        catch (SAXException e) {
            // empty catch block
        }
        try {
            if (reader.getFeature("http://xml.org/sax/features/string-interning")) {
                return false;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return true;
    }

    protected Object unmarshal(XMLReader reader, InputSource source) throws JAXBException {
        return this.unmarshal0(reader, source, null);
    }

    protected <T> JAXBElement<T> unmarshal(XMLReader reader, InputSource source, Class<T> expectedType) throws JAXBException {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(reader, source, this.getBeanInfo(expectedType));
    }

    private Object unmarshal0(XMLReader reader, InputSource source, JaxBeanInfo expectedType) throws JAXBException {
        SAXConnector connector = this.getUnmarshallerHandler(UnmarshallerImpl.needsInterning(reader), expectedType);
        reader.setContentHandler((ContentHandler)((Object)connector));
        reader.setErrorHandler(this.coordinator);
        try {
            reader.parse(source);
        }
        catch (IOException e) {
            this.coordinator.clearStates();
            throw new UnmarshalException((Throwable)e);
        }
        catch (SAXException e) {
            this.coordinator.clearStates();
            throw this.createUnmarshalException(e);
        }
        Object result = connector.getResult();
        reader.setContentHandler(dummyHandler);
        reader.setErrorHandler(dummyHandler);
        return result;
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> expectedType) throws JAXBException {
        if (source instanceof SAXSource) {
            SAXSource ss = (SAXSource)source;
            XMLReader reader = ss.getXMLReader();
            if (reader == null) {
                reader = this.getXMLReader();
            }
            return this.unmarshal(reader, ss.getInputSource(), expectedType);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal(this.getXMLReader(), UnmarshallerImpl.streamSourceToInputSource((StreamSource)source), expectedType);
        }
        if (source instanceof DOMSource) {
            return this.unmarshal(((DOMSource)source).getNode(), expectedType);
        }
        throw new IllegalArgumentException();
    }

    public Object unmarshal0(Source source, JaxBeanInfo expectedType) throws JAXBException {
        if (source instanceof SAXSource) {
            SAXSource ss = (SAXSource)source;
            XMLReader reader = ss.getXMLReader();
            if (reader == null) {
                reader = this.getXMLReader();
            }
            return this.unmarshal0(reader, ss.getInputSource(), expectedType);
        }
        if (source instanceof StreamSource) {
            return this.unmarshal0(this.getXMLReader(), UnmarshallerImpl.streamSourceToInputSource((StreamSource)source), expectedType);
        }
        if (source instanceof DOMSource) {
            return this.unmarshal0(((DOMSource)source).getNode(), expectedType);
        }
        throw new IllegalArgumentException();
    }

    public final ValidationEventHandler getEventHandler() {
        try {
            return super.getEventHandler();
        }
        catch (JAXBException e) {
            throw new AssertionError();
        }
    }

    public final boolean hasEventHandler() {
        return this.getEventHandler() != this;
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> expectedType) throws JAXBException {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(node, this.getBeanInfo(expectedType));
    }

    public final Object unmarshal(Node node) throws JAXBException {
        return this.unmarshal0(node, null);
    }

    @Deprecated
    public final Object unmarshal(SAXSource source) throws JAXBException {
        return super.unmarshal((Source)source);
    }

    public final Object unmarshal0(Node node, JaxBeanInfo expectedType) throws JAXBException {
        try {
            DOMScanner scanner = new DOMScanner();
            InterningXmlVisitor handler = new InterningXmlVisitor(this.createUnmarshallerHandler(null, false, expectedType));
            scanner.setContentHandler((ContentHandler)((Object)new SAXConnector(handler, scanner)));
            if (node.getNodeType() == 1) {
                scanner.scan((Element)node);
            } else if (node.getNodeType() == 9) {
                scanner.scan((Document)node);
            } else {
                throw new IllegalArgumentException("Unexpected node type: " + node);
            }
            Object retVal = handler.getContext().getResult();
            handler.getContext().clearResult();
            return retVal;
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
    }

    public Object unmarshal(XMLStreamReader reader) throws JAXBException {
        return this.unmarshal0(reader, null);
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader reader, Class<T> expectedType) throws JAXBException {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(reader, this.getBeanInfo(expectedType));
    }

    public Object unmarshal0(XMLStreamReader reader, JaxBeanInfo expectedType) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException(Messages.format("Unmarshaller.NullReader"));
        }
        int eventType = reader.getEventType();
        if (eventType != 1 && eventType != 7) {
            throw new IllegalStateException(Messages.format("Unmarshaller.IllegalReaderState", eventType));
        }
        XmlVisitor h = this.createUnmarshallerHandler(null, false, expectedType);
        StAXConnector connector = StAXStreamConnector.create(reader, h);
        try {
            connector.bridge();
        }
        catch (XMLStreamException e) {
            throw UnmarshallerImpl.handleStreamException(e);
        }
        Object retVal = h.getContext().getResult();
        h.getContext().clearResult();
        return retVal;
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader reader, Class<T> expectedType) throws JAXBException {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        return (JAXBElement)this.unmarshal0(reader, this.getBeanInfo(expectedType));
    }

    public Object unmarshal(XMLEventReader reader) throws JAXBException {
        return this.unmarshal0(reader, null);
    }

    private Object unmarshal0(XMLEventReader reader, JaxBeanInfo expectedType) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException(Messages.format("Unmarshaller.NullReader"));
        }
        try {
            XMLEvent event = reader.peek();
            if (!event.isStartElement() && !event.isStartDocument()) {
                throw new IllegalStateException(Messages.format("Unmarshaller.IllegalReaderState", event.getEventType()));
            }
            boolean isZephyr = reader.getClass().getName().equals("com.sun.xml.stream.XMLReaderImpl");
            XmlVisitor h = this.createUnmarshallerHandler(null, false, expectedType);
            if (!isZephyr) {
                h = new InterningXmlVisitor(h);
            }
            new StAXEventConnector(reader, h).bridge();
            return h.getContext().getResult();
        }
        catch (XMLStreamException e) {
            throw UnmarshallerImpl.handleStreamException(e);
        }
    }

    public Object unmarshal0(InputStream input, JaxBeanInfo expectedType) throws JAXBException {
        return this.unmarshal0(this.getXMLReader(), new InputSource(input), expectedType);
    }

    private static JAXBException handleStreamException(XMLStreamException e) {
        Throwable ne = e.getNestedException();
        if (ne instanceof JAXBException) {
            return (JAXBException)ne;
        }
        if (ne instanceof SAXException) {
            return new UnmarshalException(ne);
        }
        return new UnmarshalException((Throwable)e);
    }

    public Object getProperty(String name) throws PropertyException {
        if (name.equals(IDResolver.class.getName())) {
            return this.idResolver;
        }
        return super.getProperty(name);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        if (name.equals(FACTORY)) {
            this.coordinator.setFactories(value);
            return;
        }
        if (name.equals(IDResolver.class.getName())) {
            this.idResolver = (IDResolver)value;
            return;
        }
        if (name.equals(ClassResolver.class.getName())) {
            this.coordinator.classResolver = (ClassResolver)value;
            return;
        }
        if (name.equals(ClassLoader.class.getName())) {
            this.coordinator.classLoader = (ClassLoader)value;
            return;
        }
        super.setProperty(name, value);
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.attachmentUnmarshaller;
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller au) {
        this.attachmentUnmarshaller = au;
    }

    public boolean isValidating() {
        throw new UnsupportedOperationException();
    }

    public void setValidating(boolean validating) {
        throw new UnsupportedOperationException();
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.coordinator.putAdapter(type, adapter);
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (this.coordinator.containsAdapter(type)) {
            return this.coordinator.getAdapter(type);
        }
        return null;
    }

    public UnmarshalException createUnmarshalException(SAXException e) {
        return super.createUnmarshalException(e);
    }

    public boolean handleEvent(ValidationEvent event) {
        return event.getSeverity() != 2;
    }

    private static InputSource streamSourceToInputSource(StreamSource ss) {
        InputSource is = new InputSource();
        is.setSystemId(ss.getSystemId());
        is.setByteStream(ss.getInputStream());
        is.setCharacterStream(ss.getReader());
        return is;
    }

    public <T> JaxBeanInfo<T> getBeanInfo(Class<T> clazz) throws JAXBException {
        return this.context.getBeanInfo(clazz, true);
    }

    public Unmarshaller.Listener getListener() {
        return this.externalListener;
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.externalListener = listener;
    }

    public UnmarshallingContext getContext() {
        return this.coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            ClassFactory.cleanCache();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() throws IOException {
        ClassFactory.cleanCache();
    }
}

