/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.options;

import java.io.File;
import org.netbeans.modules.hudson.php.options.Bundle;
import org.netbeans.modules.php.api.util.FileUtils;

public final class HudsonOptionsValidator {
    public static final String BUILD_XML_NAME = "build.xml";
    public static final String JOB_CONFIG_NAME = "config.xml";
    public static final String PHP_UNIT_CONFIG_NAME = "phpunit.xml";
    public static final String PHP_UNIT_CONFIG_DIST_NAME = "phpunit.xml.dist";

    private HudsonOptionsValidator() {
    }

    public static String validate(String buildXml, String jobConfig, String phpUnitConfig) {
        String error = HudsonOptionsValidator.validateBuildXml(buildXml);
        if (error != null) {
            return error;
        }
        error = HudsonOptionsValidator.validateJobConfig(jobConfig);
        if (error != null) {
            return error;
        }
        error = HudsonOptionsValidator.validatePhpUnitConfig(phpUnitConfig);
        if (error != null) {
            return error;
        }
        return null;
    }

    public static String validateBuildXml(String buildXml) {
        return HudsonOptionsValidator.validateFile(Bundle.HudsonOptionsValidator_error_buildXml_file(), buildXml, Bundle.HudsonOptionsValidator_error_buildXml_name(), BUILD_XML_NAME);
    }

    public static String validateJobConfig(String jobConfig) {
        return HudsonOptionsValidator.validateFile(Bundle.HudsonOptionsValidator_error_jobConfig_file(), jobConfig, Bundle.HudsonOptionsValidator_error_jobConfig_name(), JOB_CONFIG_NAME);
    }

    public static String validatePhpUnitConfig(String phpUnitConfig) {
        return HudsonOptionsValidator.validateFile(Bundle.HudsonOptionsValidator_error_phpUnitConfig_file(), phpUnitConfig, Bundle.HudsonOptionsValidator_error_phpUnitConfig_name(), PHP_UNIT_CONFIG_NAME, PHP_UNIT_CONFIG_DIST_NAME);
    }

    private static String validateFile(String fileLabel, String filePath, String fileNameError, String ... fileNames) {
        String error = FileUtils.validateFile((String)fileLabel, (String)filePath, (boolean)false);
        if (error != null) {
            return error;
        }
        boolean found = false;
        for (String fileName : fileNames) {
            if (!fileName.equals(new File(filePath).getName())) continue;
            found = true;
            break;
        }
        if (!found) {
            return fileNameError;
        }
        return null;
    }
}

