/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.hudson.php.util.FileUtils;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.openide.filesystems.FileObject;

public final class BuildXmlUtils {
    static final Charset XML_CHARSET = Charset.forName("UTF-8");
    private static final String PROJECT_NAME_LINE = "<project name=\"%s\" default=\"build\">";
    private static final String DIR_LINE = "${basedir}/%s";

    private BuildXmlUtils() {
    }

    public static void processBuildXml(PhpModule phpModule, Path projectPhpUnitConfig) throws IOException {
        List<String> newLines = BuildXmlUtils.processBuildXmlLines(phpModule.getDisplayName(), phpModule.getProjectDirectory(), phpModule.getSourceDirectory(), phpModule.getTestDirectories(), Files.readAllLines(projectPhpUnitConfig, XML_CHARSET));
        Files.write(projectPhpUnitConfig, newLines, XML_CHARSET, new OpenOption[0]);
    }

    static List<String> processBuildXmlLines(String projectName, FileObject projectDir, FileObject srcDir, List<FileObject> testDirs, List<String> currentLines) {
        ArrayList<String> newLines = new ArrayList<String>(currentLines.size() * 2);
        String projectNameLine = String.format(PROJECT_NAME_LINE, "name-of-project");
        String srcLine = String.format(DIR_LINE, "src");
        String testLine = String.format(DIR_LINE, "tests");
        for (String line : currentLines) {
            if (line.contains(projectNameLine)) {
                newLines.add(line.replace(projectNameLine, String.format(PROJECT_NAME_LINE, projectName)));
                continue;
            }
            if (line.contains(srcLine)) {
                newLines.add(line.replace(srcLine, String.format(DIR_LINE, FileUtils.relativizePath(projectDir, srcDir))));
                continue;
            }
            if (line.contains(testLine)) {
                Iterator<FileObject> iterator = testDirs.iterator();
                if (!iterator.hasNext()) continue;
                FileObject testDir = iterator.next();
                newLines.add(line.replace(testLine, String.format(DIR_LINE, FileUtils.relativizePath(projectDir, testDir))));
                continue;
            }
            newLines.add(line);
        }
        return newLines;
    }
}

