/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.openide.util.NbBundle;

public class JavaPlatformsComboBox
extends JComboBox<Platform> {
    private static final String CONSTRUCTOR_EXCEPTION_MSG = "Data model for a combo box shall not be supplied in constructor.";
    public static final String EMPTY_DISPLAY_NAME = NbBundle.getMessage(JavaPlatformsComboBox.class, (String)"JavaPlatformsComboBox.emptyDisplayName");
    private static final PlatformComparator platformComparator = new PlatformComparator();

    private static Platform[] toPlatform(JavaPlatform[] platformsIn) {
        int size = platformsIn != null ? platformsIn.length : 0;
        Platform[] platformsOut = new Platform[size];
        for (int i = 0; i < size; ++i) {
            platformsOut[i] = new Platform(platformsIn[i]);
        }
        Arrays.sort(platformsOut, platformComparator);
        return platformsOut;
    }

    public JavaPlatformsComboBox(ComboBoxModel comboBoxModel) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(CONSTRUCTOR_EXCEPTION_MSG);
    }

    public JavaPlatformsComboBox(Object[] items) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(CONSTRUCTOR_EXCEPTION_MSG);
    }

    public JavaPlatformsComboBox(Vector<?> items) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(CONSTRUCTOR_EXCEPTION_MSG);
    }

    public JavaPlatformsComboBox() {
        super(new DefaultComboBoxModel<Platform>(JavaPlatformsComboBox.toPlatform(JavaPlatformManager.getDefault().getInstalledPlatforms())));
    }

    public JavaPlatformsComboBox(JavaPlatform[] platforms) {
        super(new DefaultComboBoxModel<Platform>(JavaPlatformsComboBox.toPlatform(platforms)));
    }

    public void updateModel() {
        this.setModel(new DefaultComboBoxModel<Platform>(JavaPlatformsComboBox.toPlatform(JavaPlatformManager.getDefault().getInstalledPlatforms())));
    }

    public void updateModel(JavaPlatform[] platforms) {
        this.setModel(new DefaultComboBoxModel<Platform>(JavaPlatformsComboBox.toPlatform(platforms)));
    }

    @Override
    public void setSelectedItem(Object platform) {
        if (platform == null) {
            platform = JavaPlatform.getDefault();
        }
        if (platform instanceof JavaPlatform) {
            int count = this.dataModel.getSize();
            for (int i = 0; i < count; ++i) {
                if (!((JavaPlatform)platform).getDisplayName().equals(((Platform)this.dataModel.getElementAt(i)).getPlatform().getDisplayName())) continue;
                super.setSelectedItem(this.dataModel.getElementAt(i));
                break;
            }
        } else {
            super.setSelectedItem(platform);
        }
    }

    public static class PlatformComparator
    implements Comparator<Platform> {
        @Override
        public int compare(Platform p1, Platform p2) {
            String d2;
            String d1 = p1 != null ? p1.toString() : null;
            String string = d2 = p2 != null ? p2.toString() : null;
            return d1 != null ? (d2 != null ? d1.compareTo(d2) : 1) : (d2 != null ? -1 : 0);
        }
    }

    public static class Platform {
        private final JavaPlatform platform;

        Platform(JavaPlatform platform) {
            this.platform = platform;
        }

        public JavaPlatform getPlatform() {
            return this.platform;
        }

        public String toString() {
            return this.platform.getDisplayName();
        }

        public boolean isDefault() {
            return this.platform.equals(JavaPlatform.getDefault());
        }
    }
}

