/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import org.eclipse.tm4e.core.internal.oniguruma.IOnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.ICompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.utils.RegexSource;

public class Rule {
    public int id;
    private boolean _nameIsCapturing;
    private String _name;
    private boolean _contentNameIsCapturing;
    private String _contentName;

    public Rule(int id, String name, String contentName) {
        this.id = id;
        this._name = name;
        this._nameIsCapturing = RegexSource.hasCaptures(this._name);
        this._contentName = contentName;
        this._contentNameIsCapturing = RegexSource.hasCaptures(this._contentName);
    }

    public String getName(String lineText, IOnigCaptureIndex[] captureIndices) {
        if (!this._nameIsCapturing) {
            return this._name;
        }
        return RegexSource.replaceCaptures(this._name, lineText, captureIndices);
    }

    public String getContentName(String lineText, IOnigCaptureIndex[] captureIndices) {
        if (!this._contentNameIsCapturing) {
            return this._contentName;
        }
        return RegexSource.replaceCaptures(this._contentName, lineText, captureIndices);
    }

    public void collectPatternsRecursive(IRuleRegistry grammar, RegExpSourceList out, boolean isFirst) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public ICompiledRule compile(IRuleRegistry grammar, String endRegexSource, boolean allowA, boolean allowG) {
        throw new UnsupportedOperationException("Implement me!");
    }
}

