/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.logger;

import org.eclipse.tm4e.core.logger.ILogger;

public abstract class AbstractLogger
implements ILogger {
    private boolean enabled;

    @Override
    public void log(String message) {
        this.log(message, null, ILogger.LogLevel.INFO);
    }

    @Override
    public void log(String message, Throwable exception) {
        this.log(message, exception, ILogger.LogLevel.ERROR);
    }

    @Override
    public void log(String message, Throwable exception, ILogger.LogLevel level) {
        if (!this.isEnabled()) {
            return;
        }
        switch (level) {
            case INFO: {
                this.logInfo(message);
                break;
            }
            case WARN: {
                this.logWarn(message, exception);
                break;
            }
            case ERROR: {
                this.logError(message, exception);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected abstract void logInfo(String var1);

    protected abstract void logWarn(String var1, Throwable var2);

    protected abstract void logError(String var1, Throwable var2);
}

